/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.beans.property.NullCoalescingPropertyBase;
import com.sun.javafx.css.media.MediaQueryContext;
import com.sun.javafx.scene.NodeHelper;
import java.util.List;
import javafx.application.ColorScheme;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Window;

public final class ScenePreferences
implements Scene.Preferences,
MediaQueryContext {
    private final Scene scene;
    private final MediaProperty<ColorScheme> colorScheme = new MediaProperty<ColorScheme>("colorScheme", PlatformImpl.getPlatformPreferences().colorSchemeProperty());
    private final MediaProperty<Boolean> persistentScrollBars = new MediaProperty<Boolean>("persistentScrollBars", PlatformImpl.getPlatformPreferences().persistentScrollBarsProperty());
    private final MediaProperty<Boolean> reducedMotion = new MediaProperty<Boolean>("reducedMotion", PlatformImpl.getPlatformPreferences().reducedMotionProperty());
    private final MediaProperty<Boolean> reducedTransparency = new MediaProperty<Boolean>("reducedTransparency", PlatformImpl.getPlatformPreferences().reducedTransparencyProperty());
    private final MediaProperty<Boolean> reducedData = new MediaProperty<Boolean>("reducedData", PlatformImpl.getPlatformPreferences().reducedDataProperty());

    public ScenePreferences(Scene scene) {
        this.scene = scene;
        scene.windowProperty().flatMap(Window::showingProperty).orElse(false).subscribe(this::onShowingChanged);
    }

    @Override
    public ObjectProperty<ColorScheme> colorSchemeProperty() {
        return this.colorScheme;
    }

    @Override
    public ColorScheme getColorScheme() {
        return (ColorScheme)((Object)this.colorScheme.get());
    }

    @Override
    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme.set(colorScheme);
    }

    @Override
    public ObjectProperty<Boolean> persistentScrollBarsProperty() {
        return this.persistentScrollBars;
    }

    @Override
    public boolean isPersistentScrollBars() {
        return (Boolean)this.persistentScrollBars.get();
    }

    @Override
    public void setPersistentScrollBars(Boolean bl) {
        this.persistentScrollBars.set(bl);
    }

    @Override
    public ObjectProperty<Boolean> reducedMotionProperty() {
        return this.reducedMotion;
    }

    @Override
    public boolean isReducedMotion() {
        return (Boolean)this.reducedMotion.get();
    }

    @Override
    public void setReducedMotion(Boolean bl) {
        this.reducedMotion.set(bl);
    }

    @Override
    public ObjectProperty<Boolean> reducedTransparencyProperty() {
        return this.reducedTransparency;
    }

    @Override
    public boolean isReducedTransparency() {
        return (Boolean)this.reducedTransparency.get();
    }

    @Override
    public void setReducedTransparency(Boolean bl) {
        this.reducedTransparency.set(bl);
    }

    @Override
    public ObjectProperty<Boolean> reducedDataProperty() {
        return this.reducedData;
    }

    @Override
    public boolean isReducedData() {
        return (Boolean)this.reducedData.get();
    }

    @Override
    public void setReducedData(Boolean bl) {
        this.reducedData.set(bl);
    }

    private void onShowingChanged(Boolean bl) {
        for (MediaProperty<Boolean> mediaProperty : List.of(this.colorScheme, this.persistentScrollBars, this.reducedData, this.reducedMotion, this.reducedTransparency)) {
            if (bl.booleanValue()) {
                mediaProperty.connect();
                continue;
            }
            mediaProperty.disconnect();
        }
    }

    private class MediaProperty<T>
    extends NullCoalescingPropertyBase<T> {
        private final String name;

        MediaProperty(String string, ObservableValue<T> observableValue) {
            super(observableValue);
            this.name = string;
        }

        @Override
        public Object getBean() {
            return ScenePreferences.this.scene;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        protected void onInvalidated() {
            Parent parent = ScenePreferences.this.scene.getRoot();
            if (parent != null) {
                NodeHelper.reapplyCSS(parent);
            }
        }
    }
}

