/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.HeaderButtonOverlay;
import com.sun.javafx.binding.StringConstant;
import java.net.URL;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.layout.HeaderButtonType;
import javafx.stage.Window;

public class WinHeaderButtonOverlay
extends HeaderButtonOverlay {
    private static final String HEADER_BUTTONS_STYLESHEET = "WindowDecoration.css";
    private static final double[][] SCALE_FACTORS = new double[][]{{1.0, 1.15}, {1.25, 1.1}, {1.5, 1.15}, {1.75, 1.0}, {2.0, 1.15}, {2.25, 1.05}, {2.5, 0.95}};

    public WinHeaderButtonOverlay(boolean bl, boolean bl2, boolean bl3) {
        super(WinHeaderButtonOverlay.getStylesheet(), bl, bl2, bl3);
        ObservableValue observableValue = this.sceneProperty().flatMap(Scene::windowProperty);
        observableValue.flatMap(Window::renderScaleXProperty).orElse(1.0).map(number -> this.getGlyphScaleFactor(number.doubleValue())).subscribe(this::updateGlyphScaleX);
        observableValue.flatMap(Window::renderScaleYProperty).orElse(1.0).map(number -> this.getGlyphScaleFactor(number.doubleValue())).subscribe(this::updateGlyphScaleY);
    }

    private double getGlyphScaleFactor(double d) {
        for (double[] dArray : SCALE_FACTORS) {
            if (!(d >= dArray[0] - 0.125) || !(d <= dArray[0] + 0.125)) continue;
            return dArray[1];
        }
        return 1.0;
    }

    private void updateGlyphScaleX(double d) {
        for (HeaderButtonType headerButtonType : HeaderButtonType.values()) {
            this.getButtonGlyph(headerButtonType).setScaleX(d);
        }
    }

    private void updateGlyphScaleY(double d) {
        for (HeaderButtonType headerButtonType : HeaderButtonType.values()) {
            this.getButtonGlyph(headerButtonType).setScaleY(d);
        }
    }

    private static ObservableValue<String> getStylesheet() {
        URL uRL = WinHeaderButtonOverlay.class.getResource(HEADER_BUTTONS_STYLESHEET);
        if (uRL == null) {
            throw new RuntimeException("Resource not found: WindowDecoration.css");
        }
        return StringConstant.valueOf(uRL.toExternalForm());
    }
}

