/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.pixgrid;

import club.funcodes.pixgrid.Main;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.ArgsFilter;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.ConfigOption;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.Example;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.graphical.PixelShape;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapBuilderImpl;
import org.refcodes.graphical.ext.javafx.FxGraphicalUtility;
import org.refcodes.graphical.ext.javafx.FxPixGridBannerPanel;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class MainFx
extends Application {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String APPLICATION_ICON = "application.png";
    private static final String NAME = "pixgrid";
    private static final String TITLE = "\u269ePIX\u2a69GRID\u269f";
    private static final String DEFAULT_CONFIG = "pixgrid.ini";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES (see [https://www.funcodes.club])";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String DESCRIPTION = "Tool for displaying a light bulb matrix rendering configurable scrolling and fading pixmaps (PNG, GIF or JPG)";
    private static final String COLOR_NAME_BLACK = "Black";
    private static final String COLOR_NAME_DARK_GREY = "DarkGrey";
    public static final String PARAM_MATRIX_SCROLL_MAP_FILENAMES = "MATRIX_SCROLL_MAP_FILENAMES";
    public static final String PARAM_MATRIX_FADER_MAP_FILENAMES = "MATRIX_FADER_MAP_FILENAMES";
    public static final String PARAM_BANNER_IMAGE_FILE_PARAM_LIST = "BANNER_IMAGE_FILE_PARAM_LIST";
    public static final String PARAM_BACKGROUND_IMAGE_FILE = "BACKGROUND_IMAGE_FILE";
    public static final String PARAM_MATRIX_WIDTH = "MATRIX_WIDTH";
    public static final String PARAM_MATRIX_HEIGHT = "MATRIX_HEIGHT";
    public static final String PARAM_LEFT_BORDER = "LEFT_BORDER";
    public static final String PARAM_RIGHT_BORDER = "RIGHT_BORDER";
    public static final String PARAM_TOP_BORDER = "TOP_BORDER";
    public static final String PARAM_BOTTOM_BORDER = "BOTTOM_BORDER";
    public static final String PARAM_HORIZONTAL_SPACE = "HORIZONTAL_SPACE";
    public static final String PARAM_VERTICAL_SPACE = "VERTICAL_SPACE";
    public static final String PARAM_PIXEL_SHAPE = "PIXEL_SHAPE";
    public static final String PARAM_VALUE_PIXEL_SHAPE_RECTANGLE = "RECTANGLE";
    public static final String PARAM_VALUE_PIXEL_SHAPE_CIRCLE = "ELLIPSE";
    public static final String PARAM_PIXEL_WIDTH = "PIXEL_WIDTH";
    public static final String PARAM_PIXEL_HEIGHT = "PIXEL_HEIGHT";
    public static final String PARAM_BACKGROUND_COLOR = "BACKGROUND_COLOR";
    public static final String PARAM_INACTIVE_PIXEL_COLOR = "INACTIVE_PIXEL_COLOR";
    public static final String PARAM_MIN_PERPENDICULAR_DISTANCE = "MIN_PERPENDICULAR_DISTANCE";
    public static final String PARAM_MAX_PERPENDICULAR_DISTANCE = "MAX_PERPENDICULAR_DISTANCE";
    public static final String PARAM_MIN_PERPENDICULAR_DELAY = "MIN_PERPENDICULAR_DELAY";
    public static final String PARAM_MAX_PERPENDICULAR_DELAY = "MAX_PERPENDICULAR_DELAY";
    public static final String PARAM_MIN_DIAGONAL_DISTANCE = "MIN_DIAGONAL_DISTANCE";
    public static final String PARAM_MAX_DIAGONAL_DISTANCE = "MAX_DIAGONAL_DISTANCE";
    public static final String PARAM_MIN_DIAGONAL_DELAY = "MIN_DIAGONAL_DELAY";
    public static final String PARAM_MAX_DIAGONAL_DELAY = "MAX_DIAGONAL_DELAY";
    public static final String PARAM_MIN_DIRECTION_CHANGES = "MIN_DIRECTION_CHANGES";
    public static final String PARAM_MAX_DIRECTION_CHANGES = "MAX_DIRECTION_CHANGES";
    public static final String PARAM_MIN_FADER_MAP_SHOW_TIME = "MIN_FADER_MAP_SHOW_TIME";
    public static final String PARAM_MAX_FADER_MAP_SHOW_TIME = "MAX_FADER_MAP_SHOW_TIME";
    public static final String PARAM_DRAW_PIXEL_DELAY = "DRAW_PIXEL_DELAY";
    public static final String PARAM_DRAW_PIXEL_PROPABILITY = "DRAW_PIXEL_PROPABILITY";
    public static final String PARAM_PIXEL_BORDER_COLOR = "PIXEL_BORDER_COLOR";
    public static final String PARAM_PIXEL_BORDER_WIDTH = "PIXEL_BORDER_WIDTH";
    private int _matrixWidth;
    private int _matrixHeight;
    private int _pixelWidth;
    private int _pixelHeight;
    private PixelShape _pixelShape;
    private int _topBorder;
    private int _bottomBorder;
    private int _leftBorder;
    private int _rightBorder;
    private int _hoizontalSpace;
    private int _verticalSpace;
    private String _inactivePixelColor;
    private String _backgroundColor;
    private int _minPerpendicularDistance;
    private int _maxPerpendicularDistance;
    private int _minPerpendicularDelay;
    private int _maxPerpendicularDelay;
    private int _minDiagonalDistance;
    private int _maxDiagonalDistance;
    private int _minDiagonalDelay;
    private int _maxDiagonalDelay;
    private int _minDirectionChanges;
    private int _maxDirectionChanges;
    private int _minFaderMapShowTime;
    private int _maxFaderMapShowTime;
    private String[] _scrollMapFileNames;
    private String[] _faderMapFileNames;
    private Integer _drawPixelDelay;
    private Float _drawPixelPropability;
    private String _pixelBorderColor;
    private float _pixelBorderWidth;
    private final List<RgbPixmap.RgbPixmapBuilder> _scrollMapColorArrayList = new ArrayList<RgbPixmap.RgbPixmapBuilder>();
    private List<RgbPixmap.RgbPixmapBuilder> _faderMapColorArrayList = new ArrayList<RgbPixmap.RgbPixmapBuilder>();
    private FxPixGridBannerPanel _pixGridPane;
    private Random _random = new Random();

    public static void main(String[] args) {
        MainFx.launch(args);
    }

    @Override
    public void start(Stage aPrimaryStage) {
        NoneOperand theNoneArg = CliSugar.none("Starts with the default configuration.");
        InitFlag theInitFlag = CliSugar.initFlag(false);
        ConfigOption theConfigOption = CliSugar.configOption();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
        QuietFlag theQuietFlag = CliSugar.quietFlag();
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.xor(theNoneArg, CliSugar.any(theConfigOption, theQuietFlag, theDebugFlag)), CliSugar.and(theInitFlag, CliSugar.any(theConfigOption, theQuietFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theQuietFlag))));
        Example[] theExamples = CliSugar.examples(CliSugar.example("Run (with a custom config in reach), be quiet", theQuietFlag), CliSugar.example("Initialize specific config file", theInitFlag, theConfigOption), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
        String[] theArgs = this.getParameters().getRaw() != null ? this.getParameters().getRaw().toArray(new String[this.getParameters().getRaw().size()]) : new String[]{};
        CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(theArgs, ArgsFilter.D_XX)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withFilePath(DEFAULT_CONFIG)).withResourceClass((Class)MainFx.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
        ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
        try {
            aPrimaryStage.getIcons().add(FxGraphicalUtility.toImage(Main.class.getResourceAsStream("/application.png")));
            aPrimaryStage.setTitle(TITLE);
            this.run(theArgsProperties, aPrimaryStage);
        }
        catch (Throwable e) {
            theCliHelper.exitOnException(e);
        }
    }

    public void run(ApplicationProperties aProperties, final Stage aPrimaryStage) throws IOException {
        this._matrixWidth = aProperties.getIntOr(PARAM_MATRIX_WIDTH, (Integer)80);
        this._matrixHeight = aProperties.getIntOr(PARAM_MATRIX_HEIGHT, (Integer)25);
        this._pixelWidth = aProperties.getIntOr(PARAM_PIXEL_WIDTH, (Integer)10);
        this._pixelHeight = aProperties.getIntOr(PARAM_PIXEL_HEIGHT, (Integer)10);
        this._pixelShape = aProperties.getEnumOr(PARAM_PIXEL_SHAPE, PixelShape.RECTANGLE);
        this._topBorder = aProperties.getIntOr(PARAM_TOP_BORDER, (Integer)0);
        this._bottomBorder = aProperties.getIntOr(PARAM_BOTTOM_BORDER, (Integer)0);
        this._leftBorder = aProperties.getIntOr(PARAM_LEFT_BORDER, (Integer)0);
        this._rightBorder = aProperties.getIntOr(PARAM_RIGHT_BORDER, (Integer)0);
        this._hoizontalSpace = aProperties.getIntOr(PARAM_HORIZONTAL_SPACE, (Integer)0);
        this._verticalSpace = aProperties.getIntOr(PARAM_VERTICAL_SPACE, (Integer)3);
        this._inactivePixelColor = aProperties.getOr(PARAM_INACTIVE_PIXEL_COLOR, COLOR_NAME_DARK_GREY);
        this._backgroundColor = aProperties.getOr(PARAM_BACKGROUND_COLOR, COLOR_NAME_BLACK);
        this._minPerpendicularDistance = aProperties.getIntOr(PARAM_MIN_PERPENDICULAR_DISTANCE, (Integer)100);
        this._maxPerpendicularDistance = aProperties.getIntOr(PARAM_MAX_PERPENDICULAR_DISTANCE, (Integer)150);
        this._minPerpendicularDelay = aProperties.getIntOr(PARAM_MIN_PERPENDICULAR_DELAY, (Integer)15);
        this._maxPerpendicularDelay = aProperties.getIntOr(PARAM_MAX_PERPENDICULAR_DELAY, (Integer)40);
        this._minDiagonalDistance = aProperties.getIntOr(PARAM_MIN_DIAGONAL_DISTANCE, (Integer)25);
        this._maxDiagonalDistance = aProperties.getIntOr(PARAM_MAX_DIAGONAL_DISTANCE, (Integer)50);
        this._minDiagonalDelay = aProperties.getIntOr(PARAM_MIN_DIAGONAL_DELAY, (Integer)25);
        this._maxDiagonalDelay = aProperties.getIntOr(PARAM_MAX_DIAGONAL_DELAY, (Integer)75);
        this._minDirectionChanges = aProperties.getIntOr(PARAM_MIN_DIRECTION_CHANGES, (Integer)25);
        this._maxDirectionChanges = aProperties.getIntOr(PARAM_MAX_DIRECTION_CHANGES, (Integer)75);
        this._minFaderMapShowTime = aProperties.getIntOr(PARAM_MIN_FADER_MAP_SHOW_TIME, (Integer)1000);
        this._maxFaderMapShowTime = aProperties.getIntOr(PARAM_MAX_FADER_MAP_SHOW_TIME, (Integer)5000);
        this._scrollMapFileNames = aProperties.asArray(PARAM_MATRIX_SCROLL_MAP_FILENAMES);
        this._faderMapFileNames = aProperties.asArray(PARAM_MATRIX_FADER_MAP_FILENAMES);
        this._drawPixelDelay = aProperties.getIntOr(PARAM_DRAW_PIXEL_DELAY, (Integer)1);
        this._drawPixelPropability = aProperties.getFloatOr(PARAM_DRAW_PIXEL_PROPABILITY, Float.valueOf(0.33f));
        this._pixelBorderColor = (String)aProperties.get((Object)PARAM_PIXEL_BORDER_COLOR);
        this._pixelBorderWidth = aProperties.getFloatOr(PARAM_PIXEL_BORDER_WIDTH, Float.valueOf(-1.0f)).floatValue();
        if (!aProperties.getBoolean("quiet").booleanValue()) {
            LOGGER.info("MATRIX_WIDTH = " + this._matrixWidth);
            LOGGER.info("MATRIX_HEIGHT = " + this._matrixHeight);
            LOGGER.info("PIXEL_WIDTH = " + this._pixelWidth);
            LOGGER.info("PIXEL_HEIGHT = " + this._pixelHeight);
            LOGGER.info("PIXEL_BORDER_COLOR = " + this._pixelBorderColor);
            LOGGER.info("PIXEL_BORDER_WIDTH = " + this._pixelBorderWidth);
            LOGGER.info("PIXEL_SHAPE = " + String.valueOf((Object)this._pixelShape));
            LOGGER.info("TOP_BORDER = " + this._topBorder);
            LOGGER.info("BOTTOM_BORDER = " + this._bottomBorder);
            LOGGER.info("LEFT_BORDER = " + this._leftBorder);
            LOGGER.info("RIGHT_BORDER = " + this._rightBorder);
            LOGGER.info("HORIZONTAL_SPACE = " + this._hoizontalSpace);
            LOGGER.info("VERTICAL_SPACE = " + this._verticalSpace);
            LOGGER.info("INACTIVE_PIXEL_COLOR = " + this._inactivePixelColor);
            LOGGER.info("BACKGROUND_COLOR = " + this._backgroundColor);
            LOGGER.info("MIN_PERPENDICULAR_DISTANCE = " + this._minPerpendicularDistance);
            LOGGER.info("MAX_PERPENDICULAR_DISTANCE = " + this._maxPerpendicularDistance);
            LOGGER.info("MIN_PERPENDICULAR_DELAY = " + this._minPerpendicularDelay);
            LOGGER.info("MAX_PERPENDICULAR_DELAY = " + this._maxPerpendicularDelay);
            LOGGER.info("MIN_DIAGONAL_DISTANCE = " + this._minDiagonalDistance);
            LOGGER.info("MAX_DIAGONAL_DISTANCE = " + this._maxDiagonalDistance);
            LOGGER.info("MIN_DIAGONAL_DELAY = " + this._minDiagonalDelay);
            LOGGER.info("MAX_DIAGONAL_DELAY = " + this._maxDiagonalDelay);
            LOGGER.info("MIN_DIRECTION_CHANGES = " + this._minDirectionChanges);
            LOGGER.info("MAX_DIRECTION_CHANGES = " + this._maxDirectionChanges);
            LOGGER.info("MIN_FADER_MAP_SHOW_TIME = " + this._minFaderMapShowTime);
            LOGGER.info("MAX_FADER_MAP_SHOW_TIME = " + this._maxFaderMapShowTime);
            LOGGER.info("MATRIX_SCROLL_MAP_FILENAMES = " + VerboseTextBuilder.asString(this._scrollMapFileNames));
            LOGGER.info("MATRIX_FADER_MAP_FILENAMES = " + VerboseTextBuilder.asString(this._faderMapFileNames));
            LOGGER.info("DRAW_PIXEL_DELAY = " + this._drawPixelDelay);
            LOGGER.info("DRAW_PIXEL_PROPABILITY = " + this._drawPixelPropability);
        }
        if (this._scrollMapFileNames != null) {
            for (String eFilename : this._scrollMapFileNames) {
                try {
                    this._scrollMapColorArrayList.add(new RgbPixmapBuilderImpl(new File(eFilename)));
                }
                catch (FileNotFoundException e) {
                    if (eFilename != null && !eFilename.startsWith("/")) {
                        try {
                            this._scrollMapColorArrayList.add(new RgbPixmapBuilderImpl(this.getClass().getResourceAsStream("/" + eFilename)));
                            continue;
                        }
                        catch (Exception ignore) {
                            throw e;
                        }
                    }
                    throw e;
                }
            }
        }
        if (this._faderMapFileNames != null) {
            for (String eFilename : this._faderMapFileNames) {
                try {
                    this._faderMapColorArrayList.add(new RgbPixmapBuilderImpl(new File(eFilename)));
                }
                catch (FileNotFoundException e) {
                    if (eFilename != null && !eFilename.startsWith("/")) {
                        try {
                            this._faderMapColorArrayList.add(new RgbPixmapBuilderImpl(this.getClass().getResourceAsStream("/" + eFilename)));
                            continue;
                        }
                        catch (Exception ignore) {
                            throw e;
                        }
                    }
                    throw e;
                }
            }
        }
        LOGGER.printTail();
        this._pixGridPane = new FxPixGridBannerPanel(this._matrixWidth, this._matrixHeight, this._backgroundColor, this._pixelWidth, this._pixelHeight, this._pixelShape, this._pixelBorderWidth, this._pixelBorderColor, this._inactivePixelColor, this._topBorder, this._bottomBorder, this._leftBorder, this._rightBorder, this._hoizontalSpace, -1.0f, false, this._verticalSpace, -1.0f, false);
        Scene theScene = new Scene((Parent)this._pixGridPane, this._pixGridPane.getWidth(), this._pixGridPane.getHeight(), Color.BLACK);
        this._pixGridPane.setVisible(true);
        aPrimaryStage.setScene(theScene);
        aPrimaryStage.setResizable(false);
        aPrimaryStage.sizeToScene();
        aPrimaryStage.setOnCloseRequest(windowEvent -> Platform.exit());
        if (Platform.isFxApplicationThread()) {
            aPrimaryStage.show();
        } else {
            Platform.runLater(new Runnable(){

                @Override
                public void run() {
                    aPrimaryStage.show();
                }
            });
        }
        Thread t = new Thread(() -> {
            while (true) {
                if (!this._faderMapColorArrayList.isEmpty()) {
                    this.displayFaderMap();
                }
                if (this._scrollMapColorArrayList.isEmpty()) continue;
                this.moveScrollMap();
            }
        });
        t.start();
    }

    private void moveScrollMap() {
        double eRandom = this._random.nextDouble() * (double)this._scrollMapColorArrayList.size();
        int theIndex = (int)eRandom;
        RgbPixmap.RgbPixmapBuilder theColorArray = this._scrollMapColorArrayList.get(theIndex);
        eRandom = this._random.nextDouble() * (double)(theColorArray.getWidth() - 1);
        int theX = (int)eRandom;
        eRandom = this._random.nextDouble() * (double)(theColorArray.getHeight() - 1);
        int theY = (int)eRandom;
        eRandom = this._random.nextDouble() * 2.0;
        if ((int)eRandom == 0) {
            this._pixGridPane.stepFadeToPixmap(theColorArray, theX, theY, this.toRndStepWidth(), this._drawPixelDelay);
        }
        if ((int)eRandom == 1) {
            this._pixGridPane.rndFadeToPixmap(theColorArray, theX, theY, this._drawPixelPropability.floatValue(), this._drawPixelDelay);
        }
        eRandom = this._random.nextDouble() * (double)(this._maxDirectionChanges - this._minDirectionChanges) + (double)this._minDirectionChanges;
        int theLoops = (int)eRandom;
        int eDirection = 2;
        eRandom = this._random.nextDouble() * (double)(this._maxPerpendicularDelay - this._minPerpendicularDelay) + (double)this._minPerpendicularDelay;
        int ePerpendicularSpeed = (int)eRandom;
        eRandom = this._random.nextDouble() * (double)(this._maxPerpendicularDistance - this._minPerpendicularDistance) + (double)this._minPerpendicularDistance;
        int ePerpendicularDistance = (int)eRandom;
        this._pixGridPane.moveEast(ePerpendicularDistance, ePerpendicularSpeed, ePerpendicularSpeed);
        for (int i = 0; i < theLoops; ++i) {
            eRandom = this._random.nextDouble() * 2.0;
            int eFork = (int)eRandom;
            eRandom = this._random.nextDouble() * (double)(this._maxDiagonalDelay - this._minDiagonalDelay) + (double)this._minDiagonalDelay;
            int eDiagonalSpeed = (int)eRandom;
            eRandom = this._random.nextDouble() * (double)(this._maxDiagonalDistance - this._minDiagonalDistance) + (double)this._minDiagonalDistance;
            int eDiagonalDistance = (int)eRandom;
            eRandom = this._random.nextDouble() * (double)(this._maxPerpendicularDelay - this._minPerpendicularDelay) + (double)this._minPerpendicularDelay;
            ePerpendicularSpeed = (int)eRandom;
            eRandom = this._random.nextDouble() * (double)(this._maxPerpendicularDistance - this._minPerpendicularDistance) + (double)this._minPerpendicularDistance;
            ePerpendicularDistance = (int)eRandom;
            if (eDirection == 0) {
                if (eFork == 0) {
                    eDirection = 7;
                    this._pixGridPane.moveNorthWest(ePerpendicularDistance, ePerpendicularSpeed, ePerpendicularSpeed);
                }
                if (eFork != 1) continue;
                eDirection = 1;
                this._pixGridPane.moveNorthEast(ePerpendicularDistance, ePerpendicularSpeed, ePerpendicularSpeed);
                continue;
            }
            if (eDirection == 1) {
                if (eFork == 0) {
                    eDirection = 0;
                    this._pixGridPane.moveNorth(eDiagonalDistance, eDiagonalSpeed, eDiagonalSpeed);
                }
                if (eFork != 1) continue;
                eDirection = 2;
                this._pixGridPane.moveEast(eDiagonalDistance, eDiagonalSpeed, eDiagonalSpeed);
                continue;
            }
            if (eDirection == 2) {
                if (eFork == 0) {
                    eDirection = 1;
                    this._pixGridPane.moveNorthEast(ePerpendicularDistance, ePerpendicularSpeed, ePerpendicularSpeed);
                }
                if (eFork != 1) continue;
                eDirection = 3;
                this._pixGridPane.moveSouthEast(ePerpendicularDistance, ePerpendicularSpeed, ePerpendicularSpeed);
                continue;
            }
            if (eDirection == 3) {
                if (eFork == 0) {
                    eDirection = 2;
                    this._pixGridPane.moveEast(eDiagonalDistance, eDiagonalSpeed, eDiagonalSpeed);
                }
                if (eFork != 1) continue;
                eDirection = 4;
                this._pixGridPane.moveSouth(eDiagonalDistance, eDiagonalSpeed, eDiagonalSpeed);
                continue;
            }
            if (eDirection == 4) {
                if (eFork == 0) {
                    eDirection = 3;
                    this._pixGridPane.moveSouthEast(ePerpendicularDistance, ePerpendicularSpeed, ePerpendicularSpeed);
                }
                if (eFork != 1) continue;
                eDirection = 5;
                this._pixGridPane.moveSouthWest(ePerpendicularDistance, ePerpendicularSpeed, ePerpendicularSpeed);
                continue;
            }
            if (eDirection == 5) {
                if (eFork == 0) {
                    eDirection = 4;
                    this._pixGridPane.moveSouth(eDiagonalDistance, eDiagonalSpeed, eDiagonalSpeed);
                }
                if (eFork != 1) continue;
                eDirection = 6;
                this._pixGridPane.moveWest(eDiagonalDistance, eDiagonalSpeed, eDiagonalSpeed);
                continue;
            }
            if (eDirection == 6) {
                if (eFork == 0) {
                    eDirection = 5;
                    this._pixGridPane.moveSouthWest(ePerpendicularDistance, ePerpendicularSpeed, ePerpendicularSpeed);
                }
                if (eFork != 1) continue;
                eDirection = 7;
                this._pixGridPane.moveNorthWest(ePerpendicularDistance, ePerpendicularSpeed, ePerpendicularSpeed);
                continue;
            }
            if (eDirection != 7) continue;
            if (eFork == 0) {
                eDirection = 6;
                this._pixGridPane.moveWest(eDiagonalDistance, eDiagonalSpeed, eDiagonalSpeed);
            }
            if (eFork != 1) continue;
            eDirection = 0;
            this._pixGridPane.moveNorth(eDiagonalDistance, eDiagonalSpeed, eDiagonalSpeed);
        }
    }

    private void displayFaderMap() {
        int theIndex = this.toRndFaderPixmap();
        RgbPixmap.RgbPixmapBuilder theColorArray = this._faderMapColorArrayList.get(theIndex);
        double eRandom = this._random.nextDouble() * 3.0;
        if ((int)eRandom == 0) {
            this._pixGridPane.rndFadeToPixmap(theColorArray, 0, 0, this._drawPixelPropability.floatValue(), this._drawPixelDelay);
        } else {
            this._pixGridPane.stepFadeToPixmap(theColorArray, 0, 0, this.toRndStepWidth(), this._drawPixelDelay);
        }
        this.delay(this.toRndShowTime());
    }

    private int toRndFaderPixmap() {
        double eRandom = this._random.nextDouble() * (double)this._faderMapColorArrayList.size();
        int theIndex = (int)eRandom;
        return theIndex;
    }

    private int toRndStepWidth() {
        int eRandom = (int)(this._random.nextDouble() * (double)(this._pixGridPane.getMatrixHeight() * this._pixGridPane.getMatrixWidth() - 1));
        if (eRandom < 1) {
            eRandom = 1;
        }
        return eRandom;
    }

    private double toRndShowTime() {
        return this._random.nextDouble() * (double)(this._maxFaderMapShowTime - this._minFaderMapShowTime) + (double)this._minFaderMapShowTime;
    }

    private void delay(double aDelayMillis) {
        try {
            Thread.sleep((int)aDelayMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void stop() throws Exception {
        System.exit(0);
    }
}

