/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.mixin.FamilyAccessor;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.SizeAccessor;
import org.refcodes.mixin.StyleAccessor;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;

public class Font
implements FamilyAccessor.FamilyProperty<FontFamily>,
FamilyAccessor.FamilyBuilder<FontFamily, Font>,
StyleAccessor.StyleProperty<FontStyle>,
StyleAccessor.StyleBuilder<FontStyle, Font>,
SizeAccessor.SizeProperty,
SizeAccessor.SizeBuilder<Font>,
NameAccessor.NameProperty,
NameAccessor.NameBuilder<Font> {
    private FontFamily _family = FontFamily.SANS_SERIF;
    private int _size = 16;
    private FontStyle _style = FontStyle.PLAIN;
    private String _name = this._family.getName();

    public Font() {
    }

    public Font(java.awt.Font aFont) {
        this.setSize(aFont.getSize());
        this.setStyle(FontStyle.fromFontStyleCode(aFont.getStyle()));
        this.setFamily(FontFamily.fromName(aFont.getFamily()));
    }

    public Font(FontFamily aFontType, FontStyle aFontStyle, int aFontSize) {
        this.setFamily(aFontType);
        this._style = aFontStyle;
        this._size = aFontSize;
    }

    public Font(FontFamily aFontType, FontStyle aFontStyle) {
        this(aFontType, aFontStyle, -1);
    }

    public Font(String aFontName, FontStyle aFontStyle, int aFontSize) {
        this.setName(aFontName);
        this._style = aFontStyle;
        this._size = aFontSize;
    }

    public Font(String aFontName, FontStyle aFontStyle) {
        this(aFontName, aFontStyle, -1);
    }

    public java.awt.Font toAwtFont() {
        return new java.awt.Font(this.getName(), (int)this.getStyle().getCode(), this.getSize());
    }

    @Override
    public FontFamily getFamily() {
        return this._family;
    }

    @Override
    public void setFamily(FontFamily aFontCategory) {
        this._family = aFontCategory;
        this._name = aFontCategory.getName();
    }

    @Override
    public Font withFamily(FontFamily aFontName) {
        this.setFamily(aFontName);
        return this;
    }

    @Override
    public FontStyle getStyle() {
        return this._style;
    }

    @Override
    public void setStyle(FontStyle aFontStyle) {
        this._style = aFontStyle;
    }

    @Override
    public Font withStyle(FontStyle aFontStyle) {
        this.setStyle(aFontStyle);
        return this;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    @Override
    public void setSize(int aFontSize) {
        this._size = aFontSize;
    }

    @Override
    public Font withSize(int aFontSize) {
        this.setSize(aFontSize);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._family.getName() + ", " + String.valueOf(this._style) + ", " + this._size + ")@" + this.hashCode();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String aFontName) {
        this._name = aFontName;
        this._family = FontFamily.fromName(aFontName);
    }

    @Override
    public Font withName(String aFontName) {
        this.setName(aFontName);
        return this;
    }
}

