/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.mixin.DetectedAccessor;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.Terminal;

public enum Shell implements DetectedAccessor
{
    SHELL,
    WIN_CMD,
    POWER_SHELL,
    NONE,
    UNKNOWN;

    private static final String CMD_EXE = "cmd.exe";
    private static final String COM_SPEC = "ComSpec";

    public static Shell toShell() {
        if (Terminal.isCygwinTerminal()) {
            return SHELL;
        }
        boolean hasConsole = System.console() != null;
        switch (OperatingSystem.toOperatingSystem()) {
            case WINDOWS: {
                if (!hasConsole) break;
                String theComSpec = System.getenv(COM_SPEC);
                if (theComSpec != null && theComSpec.endsWith(CMD_EXE)) {
                    return WIN_CMD;
                }
                return POWER_SHELL;
            }
            case UNIX: {
                if (!hasConsole) break;
                return SHELL;
            }
        }
        return hasConsole ? UNKNOWN : NONE;
    }

    @Override
    public boolean isDetected() {
        return Shell.toShell() == this;
    }
}

