/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties.ext.obfuscation;

import java.io.IOException;
import java.text.ParseException;
import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.properties.ImmutableResourceProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ReloadMode;
import org.refcodes.properties.ext.obfuscation.AbstractImmutableObfuscationResourcePropertiesDecorator;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosTextDecrypter;
import org.refcodes.textual.SecretHintBuilder;

public class UnmodifyableObfuscationResourceProperties
extends AbstractImmutableObfuscationResourcePropertiesDecorator<ImmutableResourceProperties> {
    private ChaosKey _chaosKey;

    public UnmodifyableObfuscationResourceProperties(ImmutableResourceProperties aProperties) {
        this(aProperties, SystemContext.HOST.toContextString());
    }

    public UnmodifyableObfuscationResourceProperties(ImmutableResourceProperties aProperties, String aDecryptPrefix, String aEncryptPrefix) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, SystemContext.HOST.toContextString());
    }

    public UnmodifyableObfuscationResourceProperties(ImmutableResourceProperties aProperties, String aDecryptPrefix, String aEncryptPrefix, SystemContext aObfuscationMode) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, aObfuscationMode.toContextString());
    }

    public UnmodifyableObfuscationResourceProperties(ImmutableResourceProperties aProperties, String aDecryptPrefix, String aEncryptPrefix, String aSecret) {
        super(aProperties, aDecryptPrefix, aEncryptPrefix);
        int[] theIds = NumericalUtility.toHashCodes(aSecret, 3);
        this._chaosKey = new ChaosKey(theIds[0], theIds[1], theIds[2]);
    }

    public UnmodifyableObfuscationResourceProperties(ImmutableResourceProperties aProperties, SystemContext aObfuscationMode) {
        this(aProperties, aObfuscationMode.toContextString());
    }

    public UnmodifyableObfuscationResourceProperties(ImmutableResourceProperties aProperties, String aSecret) {
        super(aProperties);
        int[] theIds = NumericalUtility.toHashCodes(aSecret, 3);
        this._chaosKey = new ChaosKey(theIds[0], theIds[1], theIds[2]);
    }

    @Override
    public Properties reload() throws IOException, ParseException {
        return ((ImmutableResourceProperties)this.getProperties()).reload();
    }

    @Override
    public Properties reload(ReloadMode aReloadMode) throws IOException, ParseException {
        return ((ImmutableResourceProperties)this.getProperties()).reload(aReloadMode);
    }

    @Override
    public String toSerialized() {
        return ((ImmutableResourceProperties)this.getProperties()).toSerialized();
    }

    @Override
    public String toSerialized(String aComment, char aDelimiter) {
        return ((ImmutableResourceProperties)this.getProperties()).toSerialized(aComment, aDelimiter);
    }

    @Override
    protected String toDecrypted(String aValue) {
        try {
            return new ChaosTextDecrypter(this._chaosKey).toDecrypted(aValue);
        }
        catch (DecryptionException e) {
            throw new BugException("Encountered a bug while decrypting value <" + SecretHintBuilder.asString(aValue) + "> with <" + String.valueOf((Object)SystemContext.HOST_USER_APPLICATION_SESSION) + "> system context!", e);
        }
    }
}

