/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties.ext.obfuscation;

import java.io.IOException;
import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ext.obfuscation.AbstractObfuscationResourcePropertiesDecorator;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosTextDecrypter;
import org.refcodes.security.alt.chaos.ChaosTextEncrypter;
import org.refcodes.textual.SecretHintBuilder;

public class ObfuscationResourcePropertiesDecorator
extends AbstractObfuscationResourcePropertiesDecorator {
    private ChaosKey _chaosKey;

    public ObfuscationResourcePropertiesDecorator(ResourceProperties aProperties) throws IOException {
        this(aProperties, SystemContext.HOST.toContextString());
    }

    public ObfuscationResourcePropertiesDecorator(ResourceProperties aProperties, String aSecret) throws IOException {
        super(aProperties);
        this._chaosKey = new ChaosKey(aSecret);
        if (this.encryptAll() && this.isFlushable()) {
            this.flush();
        }
    }

    public ObfuscationResourcePropertiesDecorator(ResourceProperties aProperties, String aDecryptPrefix, String aEncryptPrefix) throws IOException {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, SystemContext.HOST.toContextString());
    }

    public ObfuscationResourcePropertiesDecorator(ResourceProperties aProperties, String aDecryptPrefix, String aEncryptPrefix, String aSecret) throws IOException {
        super(aProperties);
        int[] theIds = NumericalUtility.toHashCodes(aSecret, 3);
        this._chaosKey = new ChaosKey(theIds[0], theIds[1], theIds[2]);
        this._decryptPrefix = aDecryptPrefix;
        this._encryptPrefix = aEncryptPrefix;
        if (this.encryptAll() && this.isFlushable()) {
            this.flush();
        }
    }

    public ObfuscationResourcePropertiesDecorator(ResourceProperties aProperties, String aDecryptPrefix, String aEncryptPrefix, SystemContext aObfuscationMode) throws IOException {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, aObfuscationMode.toContextString());
    }

    public ObfuscationResourcePropertiesDecorator(ResourceProperties aProperties, SystemContext aObfuscationMode) throws IOException {
        this(aProperties, aObfuscationMode.toContextString());
    }

    @Override
    String toDecrypted(String aValue) {
        try {
            return new ChaosTextDecrypter(this._chaosKey).toDecrypted(aValue);
        }
        catch (DecryptionException e) {
            throw new BugException("Encountered a bug while decrypting value <" + SecretHintBuilder.asString(aValue) + "> with <" + String.valueOf((Object)SystemContext.HOST_USER_APPLICATION_SESSION) + "> system context!", e);
        }
    }

    @Override
    String toEncrypted(String aValue) {
        try {
            return new ChaosTextEncrypter(this._chaosKey).toEncrypted(aValue);
        }
        catch (EncryptionException e) {
            throw new BugException("Encountered a bug while encrypting value <" + SecretHintBuilder.asString(aValue) + "> with <" + String.valueOf((Object)SystemContext.HOST_USER_APPLICATION_SESSION) + "> system context!", e);
        }
    }

    @Override
    public ObfuscationResourcePropertiesDecorator withPutShort(Object[] aPathElements, Short aValue) {
        this.putShort(this.toPath(aPathElements), aValue);
        return this;
    }

    @Override
    public ObfuscationResourcePropertiesDecorator withPutShort(String[] aPathElements, Short aValue) {
        this.putShort(this.toPath(aPathElements), aValue);
        return this;
    }
}

