/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.picdat;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.FilenameExtension;
import org.refcodes.exception.BugException;
import org.refcodes.graphical.ColorDepth;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.runtime.Execution;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "picdat";
    private static final String TITLE = "PIC\ud83d\udc53DAT";
    private static final String DEFAULT_CONFIG = "picdat.ini";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/picdat_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String DESCRIPTION = "Tool for converting (raw) data to a pixmap image (\"[pic]ture[dat]a\") and extracting raw (pixmap) data from an image (see [https://www.metacodes.pro/manpages/picdat_manpage]).";
    private static final String HEIGHT_PROPERTY = "height";
    private static final String WIDTH_PROPERTY = "width";
    private static final String OUTPUTFILE_PROPERTY = "outputFile";
    private static final String INPUTFILE_PROPERTY = "inputFile";
    private static final String COLOR_DEPTH_PROPERTY = "colorDepth";
    private static final String CONVERT_PROPERTY = "convert";
    private static final String EXTRACT_PROPERTY = "extract";
    private static final String OFFSET_PROPERTY = "offset";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        byte[] eReads;
        BufferedImage theImage;
        ColorDepth theColorDepth;
        String theFileNameExtension;
        int theHeight;
        int theWidth2;
        OutputStream theOutputStream;
        InputStream theInputStream;
        block57: {
            Flag theConvertFlag = CliSugar.flag(Character.valueOf('c'), CONVERT_PROPERTY, CONVERT_PROPERTY, "Converts given data into an image.");
            Flag theExtractFlag = CliSugar.flag(Character.valueOf('e'), EXTRACT_PROPERTY, EXTRACT_PROPERTY, "Extracts pixel data from an image.");
            StringOption theInputFileArg = CliSugar.stringOption(Character.valueOf('i'), "input-file", INPUTFILE_PROPERTY, "The input file which to process from.");
            StringOption theOutputFileArg = CliSugar.stringOption(Character.valueOf('o'), "output-file", OUTPUTFILE_PROPERTY, "The output file which to process to.");
            IntOption theWidthArg = CliSugar.intOption(WIDTH_PROPERTY, WIDTH_PROPERTY, "The width for the targeted image.");
            IntOption theHeightArg = CliSugar.intOption(HEIGHT_PROPERTY, HEIGHT_PROPERTY, "The height for the targeted image.");
            IntOption theOffsetArg = CliSugar.intOption(OFFSET_PROPERTY, OFFSET_PROPERTY, "The offset where to start interpreting the data as image data (e.g. the number of bytes to skip, first byte is at offset 0).");
            EnumOption<ColorDepth> theColorDepthArg = CliSugar.enumOption("color-depth", ColorDepth.class, COLOR_DEPTH_PROPERTY, "The color depth of the targeted image: " + VerboseTextBuilder.asString((Object[])ColorDepth.values()));
            VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
            SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
            HelpFlag theHelpFlag = CliSugar.helpFlag();
            CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(CliSugar.xor(CliSugar.and(theConvertFlag, theWidthArg, theHeightArg, CliSugar.any(theColorDepthArg, theOffsetArg)), theExtractFlag), theInputFileArg, theOutputFileArg, CliSugar.any(theVerboseFlag)), CliSugar.and(CliSugar.xor(CliSugar.and(theConvertFlag, theWidthArg, theHeightArg, CliSugar.any(theColorDepthArg, theOffsetArg)), theExtractFlag), CliSugar.xor(theInputFileArg, CliSugar.and(theOutputFileArg, CliSugar.any(theVerboseFlag)))), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theVerboseFlag))));
            Example[] theExamples = CliSugar.examples(CliSugar.example("Extract a pixmap (image) file's (raw) data to a file", theExtractFlag, theInputFileArg, theOutputFileArg, theVerboseFlag), CliSugar.example("Convert a data file to a pixmap", theConvertFlag, theInputFileArg, theOutputFileArg, theWidthArg, theHeightArg, theVerboseFlag), CliSugar.example("Convert a data file to a pixmap with given color depth", theConvertFlag, theInputFileArg, theOutputFileArg, theWidthArg, theHeightArg, theColorDepthArg, theVerboseFlag), CliSugar.example("Convert a data file starting at given offset to a pixmap", theConvertFlag, theInputFileArg, theOutputFileArg, theWidthArg, theHeightArg, theOffsetArg, theVerboseFlag), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
            CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withFilePath(DEFAULT_CONFIG)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
            ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
            boolean isVerbose = theVerboseFlag.isEnabled();
            theInputStream = Execution.toBootstrapStandardIn();
            theOutputStream = Execution.toBootstrapStandardOut();
            try {
                theWidth2 = theArgsProperties.getIntOr(theWidthArg, (Integer)-1);
                theHeight = theArgsProperties.getIntOr(theHeightArg, (Integer)-1);
                int theOffset = theArgsProperties.getIntOr(theOffsetArg, (Integer)0);
                if (theOffset < 0) {
                    throw new IllegalArgumentException("The provided offset <" + theOffset + "> for the offset argument <" + String.valueOf(theOffsetArg) + "> must be >= 0 !");
                }
                String theInputFilePath = (String)theArgsProperties.get((Object)theInputFileArg);
                String theOutputFilePath = (String)theArgsProperties.get((Object)theOutputFileArg);
                boolean isConvert = theArgsProperties.getBoolean((Object)theConvertFlag);
                boolean isExtract = theArgsProperties.getBoolean((Object)theExtractFlag);
                theFileNameExtension = FilenameExtension.toRawFileNameExtension(theOutputFilePath);
                theColorDepth = theArgsProperties.getEnum(ColorDepth.class, (Object)theColorDepthArg);
                if (isVerbose) {
                    if (theWidth2 != -1) {
                        LOGGER.info("Pixmap width = " + theWidth2);
                    }
                    if (theHeight != -1) {
                        LOGGER.info("Pixmap height= " + theHeight);
                    }
                    if (theColorDepth != null) {
                        LOGGER.info("Color depth = " + String.valueOf((Object)theColorDepth));
                    }
                    if (theOffset != 0) {
                        LOGGER.info("Offset = " + theOffset);
                    }
                    LOGGER.info("Operation = " + (isConvert ? "Converting" : (isExtract ? "Extracting" : "?")));
                }
                if (theInputFilePath != null && theInputFilePath.length() != 0) {
                    File theInputFile = new File(theInputFilePath);
                    if (isVerbose) {
                        LOGGER.info("Input file = \"" + theInputFilePath + "\" (<" + theInputFile.getAbsolutePath() + ">)");
                    }
                    if (!theInputFile.exists()) throw new FileNotFoundException("No file \"" + theInputFilePath + "\" (<" + theInputFile.getAbsolutePath() + ">) found!");
                    if (!theInputFile.isFile()) {
                        throw new FileNotFoundException("No file \"" + theInputFilePath + "\" (<" + theInputFile.getAbsolutePath() + ">) found!");
                    }
                    theInputStream = new FileInputStream(theInputFile);
                }
                theInputStream = new BufferedInputStream(theInputStream);
                if (theOutputFilePath != null && theOutputFilePath.length() != 0) {
                    File theOutputFile = new File(theOutputFilePath);
                    if (isVerbose) {
                        LOGGER.info("Output file = \"" + theOutputFilePath + "\" (<" + theOutputFile.getAbsolutePath() + ">)");
                    }
                    theOutputStream = new FileOutputStream(theOutputFile);
                }
                theOutputStream = new BufferedOutputStream(theOutputStream);
                if (isConvert) {
                    long theSkipped;
                    if (theOffset > 0 && (theSkipped = theInputStream.skip(theOffset)) != (long)theOffset) {
                        throw new IOException("Can only skip <" + theSkipped + "> of the specified (<" + String.valueOf(theOffsetArg) + ">) <" + theOffset + " bytes!");
                    }
                    if (theColorDepth == null) {
                        theColorDepth = ColorDepth.AWT_COLOR_24_BIT;
                    }
                    theImage = new BufferedImage(theWidth2, theHeight, switch (theColorDepth) {
                        case ColorDepth.HIGH_COLOR_16_BIT -> 1;
                        case ColorDepth.MONOCHROME_1_BIT -> 12;
                        case ColorDepth.GRAYSCALE_8_BIT -> 10;
                        case ColorDepth.TRUE_COLOR_24_BIT -> 1;
                        case ColorDepth.TRUE_COLOR_32_BIT -> 2;
                        default -> 1;
                    });
                    eReads = new byte[theColorDepth.getBytes()];
                    break block57;
                }
                if (!isExtract) throw new BugException("We encountered a bug, none argument was processed.");
                BufferedImage theImage2 = ImageIO.read(theInputStream);
                if (isVerbose) {
                    LOGGER.info("Width = " + theImage2.getWidth());
                    LOGGER.info("Height = " + theImage2.getHeight());
                }
                boolean isMoochrome = theImage2.getType() == 10;
                int y = 0;
                while (y < theImage2.getHeight()) {
                    for (int x = 0; x < theImage2.getWidth(); ++x) {
                        int ePixel = theImage2.getRGB(x, y);
                        if (isMoochrome) {
                            theOutputStream.write((ColorDepth.AWT_COLOR_24_BIT.toRedValue(ePixel) + ColorDepth.AWT_COLOR_24_BIT.toGreenValue(ePixel) + ColorDepth.AWT_COLOR_24_BIT.toBlueValue(ePixel)) / 3);
                            continue;
                        }
                        theOutputStream.write(ColorDepth.AWT_COLOR_24_BIT.toRedValue(ePixel));
                        theOutputStream.write(ColorDepth.AWT_COLOR_24_BIT.toGreenValue(ePixel));
                        theOutputStream.write(ColorDepth.AWT_COLOR_24_BIT.toBlueValue(ePixel));
                    }
                    ++y;
                }
                return;
            }
            catch (Throwable e) {
                theCliHelper.exitOnException(e);
                return;
            }
            finally {
                if (theInputStream != null) {
                    try {
                        theInputStream.close();
                    }
                    catch (IOException theWidth2) {}
                }
                if (theOutputStream != null) {
                    try {
                        theOutputStream.close();
                    }
                    catch (IOException theWidth2) {}
                }
            }
        }
        block35: for (int y = 0; y < theHeight; ++y) {
            int x = 0;
            while (x < theWidth2) {
                int i;
                for (i = 0; i < eReads.length; ++i) {
                    eReads[i] = 0;
                }
                if (theInputStream.read(eReads) == -1) break block35;
                switch (theColorDepth) {
                    case MONOCHROME_1_BIT: {
                        for (i = 0; i < 8; ++i) {
                            theImage.setRGB(x, y, ColorDepth.AWT_COLOR_24_BIT.toColor(NumericalUtility.isBitSetAt(eReads[0], i) ? 1 : 0, theColorDepth));
                            if (++x < theWidth2) continue;
                            x = 0;
                            if (++y >= theHeight) break block35;
                        }
                        break;
                    }
                    case GRAYSCALE_8_BIT: {
                        theImage.setRGB(x, y, ColorDepth.AWT_COLOR_24_BIT.toColor(eReads[0], theColorDepth));
                        break;
                    }
                    case MSX_8_BIT: {
                        theImage.setRGB(x, y, ColorDepth.AWT_COLOR_24_BIT.toColor(eReads[0], theColorDepth));
                        break;
                    }
                    case HIGH_COLOR_16_BIT: {
                        theImage.setRGB(x, y, ColorDepth.AWT_COLOR_24_BIT.toColor(NumericalUtility.toInt(eReads), theColorDepth));
                        break;
                    }
                    case TRUE_COLOR_24_BIT: {
                        theImage.setRGB(x, y, NumericalUtility.toInt(eReads));
                        break;
                    }
                    case AWT_COLOR_24_BIT: {
                        theImage.setRGB(x, y, NumericalUtility.toInt(eReads));
                        break;
                    }
                    case TRUE_COLOR_32_BIT: {
                        theImage.setRGB(x, y, NumericalUtility.toInt(eReads));
                    }
                }
                ++x;
            }
        }
        ImageIO.write((RenderedImage)theImage, theFileNameExtension, theOutputStream);
    }
}

