/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.time;

public enum TimeUnit {
    NANOSECOND(1L),
    MILLISECOND(1000000L),
    SECOND(1000000000L),
    MINUTE(60000000000L),
    HOUR(3600000000000L),
    DAY(86400000000000L),
    YEAR(31536000000000000L);

    private long _milliseconds;

    private TimeUnit(long aMilliseconds) {
        this._milliseconds = aMilliseconds;
    }

    public long getMilliseconds() {
        return this._milliseconds;
    }

    public float toTime(TimeUnit aFromTimeUnit, long aFromTime) {
        return TimeUnit.toTimeUnit(aFromTimeUnit, aFromTime, this);
    }

    public static float toTimeUnit(TimeUnit aFromTimeUnit, long aTime, TimeUnit aToTimeUnit) {
        long theMillis = aTime * aFromTimeUnit.getMilliseconds();
        return theMillis / aToTimeUnit.getMilliseconds();
    }

    public static long toMilliseconds(TimeUnit aTimeUnit, long aTime) {
        return aTime * aTimeUnit.getMilliseconds() / MILLISECOND.getMilliseconds();
    }
}

