/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.alt.chaos;

import java.io.IOException;
import java.io.InputStream;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.DecryptionInputStream;
import org.refcodes.security.alt.chaos.ChaosDecrypter;
import org.refcodes.security.alt.chaos.ChaosKey;

public class ChaosDecryptionInputStream
extends DecryptionInputStream {
    public ChaosDecryptionInputStream(InputStream aInputStream, ChaosKey aKey) throws IOException {
        super(ChaosDecryptionInputStream.toInputStrean(aInputStream, aKey), ChaosDecryptionInputStream.toChaosDecrypter(aInputStream, aKey));
    }

    private static InputStream toInputStrean(InputStream aInputStream, ChaosKey aKey) throws IOException {
        return (aKey = aKey.nextVariableLengthChild()) == null ? aInputStream : new ChaosDecryptionInputStream(aInputStream, aKey);
    }

    private static ChaosDecrypter toChaosDecrypter(InputStream aInputStream, ChaosKey aKey) throws IOException {
        int theFixedLengthChildDepth = aKey.fixedLengthChildDepth();
        ChaosDecrypter theDecrypter = new ChaosDecrypter(aKey, theFixedLengthChildDepth);
        try {
            if (aKey.getOptions().hasRndPrefix()) {
                short theSize = aKey.getOptions().getRndPrefixSize();
                byte[] thePrefix = new byte[theSize];
                int theRead = aInputStream.read(thePrefix);
                if (theRead != theSize) {
                    throw new IOException("Read only <" + theRead + "> bytes of <" + theSize + "> bytes required by the RND prefix.");
                }
                theDecrypter.toDecrypted(thePrefix);
            }
            if (aKey.getOptions().isSalted()) {
                byte[] theEncrypted = new byte[ChaosKey.getEncodedLength()];
                int theRead = aInputStream.read(theEncrypted, 0, ChaosKey.getEncodedLength());
                if (theRead != ChaosKey.getEncodedLength()) {
                    throw new IOException("Read only <" + theRead + "> bytes of <" + ChaosKey.getEncodedLength() + "> bytes requried for the salt key.");
                }
                byte[] theEncoding = theDecrypter.toDecrypted(theEncrypted);
                ChaosKey theSaltKey = new ChaosKey(theEncoding);
                return new ChaosDecrypter(theSaltKey, theFixedLengthChildDepth, theDecrypter);
            }
        }
        catch (DecryptionException e) {
            throw new IllegalStateException("Encountered an illegal sate while decrypting!", e);
        }
        return theDecrypter;
    }
}

