/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.refcodes.mixin.DescriptionAccessor;
import org.refcodes.mixin.EnvironmentVariableNameAccessor;
import org.refcodes.mixin.SystemPropertyNameAccessor;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.runtime.Diagnosable;
import org.refcodes.runtime.DiagnosticOptions;
import org.refcodes.runtime.EnvironmentVariable;
import org.refcodes.runtime.OptionsSchema;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.schema.Schema;

public class Options
extends HashMap<String, Object>
implements Diagnosable {
    private static final long serialVersionUID = 1L;
    private static final String SYSTEM_PROPERTY_NAME = "SYSTEM_PROPERTY_NAME";
    private static final String SYSTEM_PROPERTY_VALUE = "SYSTEM_PROPERTY_VALUE";
    private static final String ENVIRONMENT_VARIABLE_NAME = "ENVIRONMENT_VARIABLE_NAME";
    private static final String ENVIRONMENT_VARIABLE_VALUE = "ENVIRONMENT_VARIABLE_VALUE";
    private static final String PROVIDED_NAME = "PROVIDED_NAME";
    private static final String PROVIDED_VALUE = "PROVIDED_VALUE";
    private final Map<String, Option> _options = new HashMap<String, Option>();

    public Options() {
    }

    protected Options(Builder aBuilder) {
        this.putAll(aBuilder.configuration);
    }

    protected Options(Builder aBuilder, Class<? extends Enum<?>> aConfiguration) {
        this(aBuilder);
        this.registerOptions(aConfiguration);
    }

    public Object get(Enum<?> aKey) {
        return this.get(aKey.name());
    }

    public Object getOr(Enum<?> aKey, Object aValue) {
        Object theValue = this.get(aKey);
        return theValue != null ? theValue : aValue;
    }

    public <T> T get(Enum<?> aKey, Class<T> aType) {
        Object value = this.get(aKey);
        return aType.isInstance(value) ? (T)aType.cast(value) : null;
    }

    public <T> T getOr(Enum<?> aKey, Class<T> aType, T aValue) {
        Object theValue = this.get(aKey);
        return aType.isInstance(theValue) ? aType.cast(theValue) : aValue;
    }

    public <T> T get(String aKey, Class<T> aType) {
        Object value = this.get(aKey);
        return aType.isInstance(value) ? (T)aType.cast(value) : null;
    }

    public <T> T getOr(String aKey, Class<T> aType, T aValue) {
        Object theValue = this.get(aKey);
        return aType.isInstance(theValue) ? aType.cast(theValue) : aValue;
    }

    @Override
    public Object get(Object aKey) {
        Object theValue = super.get(aKey);
        if (theValue == null && aKey != null) {
            String theKey;
            Option theOption = this._options.get(aKey.toString());
            String string = theKey = theOption != null ? theOption.systemPropertyName : SystemProperty.toSystemPropertyName(aKey.toString());
            if (theKey != null) {
                theValue = System.getProperty(theKey);
            }
            if (theValue == null) {
                String string2 = theKey = theOption != null ? theOption.environmentVariableName : EnvironmentVariable.toEnvironmentVariableName(aKey.toString());
                if (theKey != null) {
                    theValue = System.getenv(theKey);
                }
            }
        }
        return theValue;
    }

    @Override
    public Object put(Enum<?> aKey, Object aValue) {
        return this.put(aKey != null ? aKey.name() : null, aValue);
    }

    @Override
    public Object put(String aKey, Object aValue) {
        Option theOption;
        if (aValue != null && (theOption = this._options.get(aKey)) != null && theOption.type != null && !theOption.type.isInstance(aValue)) {
            throw new IllegalArgumentException("Unexpected type <" + aValue.getClass().getName() + "for the registered option \"" + aKey + "\" with the registered type <" + theOption.type.getName() + ">!");
        }
        return super.put(aKey, aValue);
    }

    @Override
    public Schema toSchema() {
        return this.toSchema(null);
    }

    public OptionsSchema toSchema(DiagnosticOptions aOptions) {
        OptionsSchema.Builder theBuilder = OptionsSchema.builder().withInstance(this);
        HashSet<String> theKeys = new HashSet<String>(this._options.keySet());
        theKeys.addAll(this.keySet());
        Object[] theSortedKeys = theKeys.toArray(new String[theKeys.size()]);
        Arrays.sort(theSortedKeys);
        for (Object eKey : theSortedKeys) {
            String theEnvironmentVariableName;
            String theSystemPropertyName;
            OptionsSchema.Builder eBuilder = OptionsSchema.builder();
            eBuilder.withIdentifier((String)eKey);
            eBuilder.withAlias((String)eKey);
            eBuilder.withInstance(eKey);
            eBuilder.withValue(this.get(eKey));
            Option eOption = this.getOption((String)eKey);
            Class<?> theType = null;
            if (eOption != null) {
                if (eOption.description != null) {
                    eBuilder.withDescription(eOption.description);
                }
                theSystemPropertyName = eOption.systemPropertyName;
                theEnvironmentVariableName = eOption.environmentVariableName;
                theType = eOption.type;
            } else {
                theSystemPropertyName = SystemProperty.toSystemPropertyName((String)eKey);
                theEnvironmentVariableName = EnvironmentVariable.toEnvironmentVariableName((String)eKey);
            }
            Object theProvidedValue = super.get(eKey);
            if (theType != null && theProvidedValue != null) {
                theType = theProvidedValue.getClass();
            }
            eBuilder.withType((Class)theType);
            String theSystemPropertyValue = System.getProperty(theSystemPropertyName);
            String theEnvironmentVariableValue = System.getenv(theEnvironmentVariableName);
            eBuilder.withProperty(PROVIDED_NAME, eKey);
            eBuilder.withProperty(PROVIDED_VALUE, theProvidedValue);
            eBuilder.withProperty(SYSTEM_PROPERTY_NAME, theSystemPropertyName);
            eBuilder.withProperty(SYSTEM_PROPERTY_VALUE, theSystemPropertyValue);
            eBuilder.withProperty(ENVIRONMENT_VARIABLE_NAME, theEnvironmentVariableName);
            eBuilder.withProperty(ENVIRONMENT_VARIABLE_VALUE, theEnvironmentVariableValue);
            eBuilder.withProperty(VALUE_SOURCE.class.getSimpleName(), (Object)(theProvidedValue != null ? VALUE_SOURCE.PROVIDED : (theSystemPropertyValue != null ? VALUE_SOURCE.SYSTEM_PROPERTY : (theEnvironmentVariableValue != null ? VALUE_SOURCE.ENVIRONMENT_VARIABLE : VALUE_SOURCE.NONE))));
            theBuilder.withAddChildren(eBuilder.build());
        }
        return theBuilder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected void registerOptions(Class<? extends Enum<?>> aConfiguration) {
        for (Enum<?> eElement : aConfiguration.getEnumConstants()) {
            Class clazz;
            String eDescritpion;
            String eEnvironmentVariable;
            String eSystemProperty;
            Object theName;
            if (eElement instanceof SystemPropertyNameAccessor) {
                theName = (SystemPropertyNameAccessor)((Object)eElement);
                v0 = theName.getSystemPropertyName();
            } else {
                v0 = eSystemProperty = SystemProperty.toSystemPropertyName(eElement.name());
            }
            if (eElement instanceof EnvironmentVariableNameAccessor) {
                theName = (EnvironmentVariableNameAccessor)((Object)eElement);
                v1 = theName.getEnvironmentVariableName();
            } else {
                v1 = eEnvironmentVariable = EnvironmentVariable.toEnvironmentVariableName(eElement.name());
            }
            if (eElement instanceof DescriptionAccessor) {
                DescriptionAccessor theComment = (DescriptionAccessor)((Object)eElement);
                v2 = theComment.getDescription();
            } else {
                v2 = eDescritpion = null;
            }
            if (eElement instanceof TypeAccessor) {
                TypeAccessor theType = (TypeAccessor)((Object)eElement);
                clazz = theType.getType();
            } else {
                clazz = null;
            }
            Class eType = clazz;
            this._options.put(eElement.name(), new Option(eSystemProperty, eEnvironmentVariable, eType, eDescritpion));
        }
    }

    protected Option getOption(String aKey) {
        return this._options.get(aKey);
    }

    public static class Builder {
        private final Map<String, Object> configuration = new HashMap<String, Object>();

        public Builder withProperty(String aKey, Object aValue) {
            this.configuration.put(aKey, aValue);
            return this;
        }

        public Builder withProperty(Enum aKey, Object aValue) {
            this.configuration.put(aKey != null ? aKey.name() : null, aValue);
            return this;
        }

        public Options build() {
            return new Options(this);
        }
    }

    record Option(String systemPropertyName, String environmentVariableName, Class<?> type, String description) {
        boolean hasSystemProperty() {
            return System.getProperty(this.systemPropertyName) != null;
        }

        boolean hasEnvirnmentVariable() {
            return System.getenv(this.environmentVariableName) != null;
        }
    }

    private static enum VALUE_SOURCE {
        ENVIRONMENT_VARIABLE,
        SYSTEM_PROPERTY,
        PROVIDED,
        NONE;

    }
}

