/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.refcodes.properties.AbstractResourcePropertiesDecorator;
import org.refcodes.properties.DocumentMetrics;
import org.refcodes.properties.DocumentNotation;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.JavaPropertiesFactory;
import org.refcodes.properties.JsonPropertiesFactory;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ReloadMode;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ResourcePropertiesFactory;
import org.refcodes.properties.TomlPropertiesFactory;
import org.refcodes.properties.XmlPropertiesFactory;
import org.refcodes.properties.YamlPropertiesFactory;
import org.refcodes.runtime.ConfigLocator;

public class PolyglotProperties
extends AbstractResourcePropertiesDecorator<ResourceProperties> {
    private final DocumentMetrics _documentMetrics;

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties((Class)aResourceClass, aFilePath));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties((Class)aResourceClass, aFilePath));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties((Class)aResourceClass, aFilePath, aConfigLocator));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties((Class)aResourceClass, aFilePath, aConfigLocator));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(File aFile) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFile));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(File aFile, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aFile));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFile, aConfigLocator));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(File aFile, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aFile, aConfigLocator));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(InputStream aInputStream) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aInputStream));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(InputStream aInputStream, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aInputStream));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(Map<?, ?> aMap) {
        super(new PolyglotPropertiesFactory().toProperties((Map)aMap));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(Map<?, ?> aMap, DocumentMetrics aDocumentMetrics) {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties((Map)aMap));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(Object aObj) {
        super(new PolyglotPropertiesFactory().toProperties(aObj));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(Object aObj, DocumentMetrics aDocumentMetrics) {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aObj));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(ImmutableProperties aProperties) {
        super(new PolyglotPropertiesFactory().toProperties(aProperties));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(ImmutableProperties aProperties, DocumentMetrics aDocumentMetrics) {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aProperties));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(Properties aProperties) {
        super(new PolyglotPropertiesFactory().toProperties(aProperties));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(Properties aProperties, DocumentMetrics aDocumentMetrics) {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aProperties));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(String aFilePath) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFilePath));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(String aFilePath, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aFilePath));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFilePath, aConfigLocator));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(String aFilePath, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aFilePath, aConfigLocator));
        this._documentMetrics = aDocumentMetrics;
    }

    public PolyglotProperties(URL aUrl) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aUrl));
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public PolyglotProperties(URL aUrl, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aUrl));
        this._documentMetrics = aDocumentMetrics;
    }

    @Override
    public Properties loadFrom(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aResourceClass, aFilePath, this._documentMetrics);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties loadFrom(File aFile) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aFile, this._documentMetrics);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties loadFrom(InputStream aInputStream) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aInputStream, this._documentMetrics);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties loadFrom(String aFilePath) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aFilePath, this._documentMetrics);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties loadFrom(URL aUrl) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aUrl, this._documentMetrics);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties reload() throws IOException, ParseException {
        return super.reload();
    }

    @Override
    public Properties reload(ReloadMode aReloadMode) throws IOException, ParseException {
        return super.reload(aReloadMode);
    }

    @Override
    public Properties seekFrom(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aResourceClass, aFilePath, aConfigLocator, this._documentMetrics);
        this.insert(theProperties);
        return theProperties;
    }

    public static class PolyglotPropertiesFactory
    implements ResourcePropertiesFactory {
        private final List<ResourcePropertiesFactory> _factories = new ArrayList<ResourcePropertiesFactory>();

        public PolyglotPropertiesFactory() {
            this(DocumentNotation.DEFAULT);
        }

        public PolyglotPropertiesFactory(DocumentMetrics aDocumentMetrics) {
            this._factories.add(new TomlPropertiesFactory(aDocumentMetrics));
            this._factories.add(new YamlPropertiesFactory());
            this._factories.add(new XmlPropertiesFactory(aDocumentMetrics));
            this._factories.add(new JsonPropertiesFactory());
            this._factories.add(new JavaPropertiesFactory(aDocumentMetrics));
        }

        public PolyglotPropertiesFactory(ResourcePropertiesFactory ... aFactories) {
            for (ResourcePropertiesFactory eFactory : aFactories) {
                this._factories.add(eFactory);
            }
        }

        @Override
        public String[] getFilenameSuffixes() {
            ArrayList<String> theExtensions = new ArrayList<String>();
            for (ResourcePropertiesFactory _factorie : this._factories) {
                String[] eExtensions = _factorie.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    theExtensions.add(eExtension);
                }
            }
            return theExtensions.toArray(new String[theExtensions.size()]);
        }

        @Override
        public ResourceProperties toProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause = null;
            try {
                return this.toPropertiesFromFilePath(aFilePath, aConfigLocator);
            }
            catch (Exception e) {
                if (theCause == null) {
                    theCause = e;
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    try {
                        return eFactory.toProperties((Class)aResourceClass, aFilePath, aConfigLocator);
                    }
                    catch (ParseException e2) {
                        if (eFactory.hasFilenameSuffix(aFilePath)) {
                            throw new ParseException("Error parsing file <" + aFilePath + "> at offset <" + e2.getErrorOffset() + ">!", e2.getErrorOffset());
                        }
                        if (theCause != null) continue;
                        theCause = e2;
                    }
                    catch (Exception e3) {
                        if (theCause != null) continue;
                        theCause = e3;
                    }
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    String[] eExtensions = eFactory.getFilenameSuffixes();
                    if (eExtensions == null) continue;
                    for (String eExtension : eExtensions) {
                        String eFilePath = aFilePath + eExtension;
                        try {
                            return eFactory.toProperties(eFilePath, aConfigLocator);
                        }
                        catch (ParseException e4) {
                            if (eFactory.hasFilenameSuffix(eFilePath)) {
                                throw new ParseException("Error parsing file <" + eFilePath + "> at offset <" + e4.getErrorOffset() + ">!", e4.getErrorOffset());
                            }
                            if (theCause != null) continue;
                            theCause = e4;
                        }
                        catch (Exception e5) {
                            if (theCause != null) continue;
                            theCause = e5;
                        }
                    }
                }
                if (theCause instanceof IOException) {
                    throw (IOException)theCause;
                }
                if (theCause instanceof ParseException) {
                    throw (ParseException)theCause;
                }
                throw new IOException("No configuration file with name scheme <" + aFilePath + ".*> found, where a suffix (if applicable) might by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
            }
        }

        @Override
        public ResourceProperties toProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause = null;
            try {
                return this.toPropertiesFromFilePath(aFile.getPath(), aConfigLocator);
            }
            catch (Exception e) {
                if (theCause == null) {
                    theCause = e;
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    try {
                        return eFactory.toProperties(aFile, aConfigLocator);
                    }
                    catch (Exception e2) {
                        if (theCause != null) continue;
                        theCause = e2;
                    }
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    String[] eExtensions = eFactory.getFilenameSuffixes();
                    if (eExtensions == null) continue;
                    for (String eExtension : eExtensions) {
                        File eFile = new File(aFile.getAbsolutePath() + eExtension);
                        try {
                            return eFactory.toProperties(eFile, aConfigLocator);
                        }
                        catch (Exception e3) {
                            if (theCause != null) continue;
                            theCause = e3;
                        }
                    }
                }
                if (theCause instanceof IOException) {
                    throw (IOException)theCause;
                }
                if (theCause instanceof ParseException) {
                    throw (ParseException)theCause;
                }
                throw new IOException("No configuration file with (base) file <" + aFile.getPath() + "> found!");
            }
        }

        @Override
        public ResourceProperties toProperties(InputStream aInputStream) throws IOException, ParseException {
            Exception theCause = null;
            byte[] theBytes = PolyglotPropertiesFactory.toByteArray(aInputStream);
            for (ResourcePropertiesFactory eFactory : this._factories) {
                try {
                    return eFactory.toProperties(new ByteArrayInputStream(theBytes));
                }
                catch (Exception e) {
                    if (theCause != null) continue;
                    theCause = e;
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file for the given InputStream found!");
        }

        @Override
        public ResourceProperties toProperties(Map<?, ?> aPropertiesBuilder) {
            return this._factories.get(0).toProperties((Map)aPropertiesBuilder);
        }

        @Override
        public ResourceProperties toProperties(Object aObj) {
            return this._factories.get(0).toProperties(aObj);
        }

        @Override
        public ResourceProperties toProperties(ImmutableProperties aProperties) {
            return this._factories.get(0).toProperties(aProperties);
        }

        @Override
        public ResourceProperties toProperties(Properties aProperties) {
            return this._factories.get(0).toProperties(aProperties);
        }

        @Override
        public ResourceProperties toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return this.toProperties((Class)null, aFilePath, aConfigLocator);
        }

        @Override
        public ResourceProperties toProperties(URL aUrl) throws IOException, ParseException {
            Exception theCause;
            block12: {
                theCause = null;
                try {
                    ResourcePropertiesFactory theFactory = this.fromFilenameExtension(aUrl.toExternalForm());
                    if (theFactory != null) {
                        return theFactory.toProperties(aUrl);
                    }
                }
                catch (Exception e) {
                    if (theCause != null) break block12;
                    theCause = e;
                }
            }
            for (ResourcePropertiesFactory eFactory : this._factories) {
                try {
                    return eFactory.toProperties(aUrl);
                }
                catch (Exception e) {
                    if (theCause != null) continue;
                    theCause = e;
                }
            }
            for (ResourcePropertiesFactory eFactory : this._factories) {
                String[] eExtensions = eFactory.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    URL eUrl = PolyglotPropertiesFactory.toURL(aUrl.toExternalForm() + eExtension);
                    try {
                        return eFactory.toProperties(eUrl);
                    }
                    catch (Exception e) {
                        if (theCause != null) continue;
                        theCause = e;
                    }
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file with (base) URL <" + aUrl.toExternalForm() + "> found!");
        }

        private static URL toURL(String aStr) throws MalformedURLException {
            try {
                return URI.create(aStr).toURL();
            }
            catch (IllegalArgumentException e) {
                throw new MalformedURLException(e.getMessage());
            }
        }

        private ResourcePropertiesFactory fromFilenameExtension(String aFilePath) {
            for (ResourcePropertiesFactory eFactory : this._factories) {
                String[] eExtensions = eFactory.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    if (!aFilePath.toLowerCase().endsWith(eExtension.toLowerCase())) continue;
                    return eFactory;
                }
            }
            return null;
        }

        private ResourceProperties toPropertiesFromFilePath(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause;
            block24: {
                theCause = null;
                File theFile = new File(aFilePath);
                if (theFile.exists()) {
                    ResourcePropertiesFactory theFactory = this.fromFilenameExtension(theFile.getAbsolutePath());
                    try {
                        if (theFactory != null) {
                            return theFactory.toProperties(theFile, ConfigLocator.ABSOLUTE);
                        }
                    }
                    catch (ParseException e) {
                        if (theFactory.hasFilenameSuffix(theFile)) {
                            throw new ParseException("Error parsing file <" + theFile.getAbsolutePath() + "> at offset <" + e.getErrorOffset() + ">!", e.getErrorOffset());
                        }
                        if (theCause == null) {
                            theCause = e;
                        }
                    }
                    catch (Exception e) {
                        if (theCause != null) break block24;
                        theCause = e;
                    }
                } else {
                    File eFile;
                    for (ResourcePropertiesFactory eFactory : this._factories) {
                        String[] stringArray = eFactory.getFilenameSuffixes();
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String eExtension = stringArray[i];
                            eFile = new File(aFilePath + eExtension);
                            if (!eFile.exists()) continue;
                            try {
                                return eFactory.toProperties(eFile, ConfigLocator.ABSOLUTE);
                            }
                            catch (ParseException e) {
                                if (eFactory.hasFilenameSuffix(eFile)) {
                                    throw new ParseException("Error parsing file <" + eFile.getAbsolutePath() + "> at offset <" + e.getErrorOffset() + ">!", e.getErrorOffset());
                                }
                                if (theCause != null) continue;
                                theCause = e;
                                continue;
                            }
                            catch (Exception e) {
                                if (theCause != null) continue;
                                theCause = e;
                            }
                        }
                    }
                    if (aConfigLocator != null && aConfigLocator != ConfigLocator.ABSOLUTE) {
                        File[] theFolders;
                        for (File eDir : theFolders = aConfigLocator.getFolders()) {
                            for (ResourcePropertiesFactory eFactory : this._factories) {
                                for (String eExtension : eFactory.getFilenameSuffixes()) {
                                    eFile = new File(eDir, aFilePath + eExtension);
                                    if (!eFile.exists()) continue;
                                    try {
                                        return eFactory.toProperties(eFile, ConfigLocator.ABSOLUTE);
                                    }
                                    catch (ParseException e) {
                                        if (eFactory.hasFilenameSuffix(eFile)) {
                                            throw new ParseException("Error parsing file <" + eFile.getAbsolutePath() + "> at offset <" + e.getErrorOffset() + ">!", e.getErrorOffset());
                                        }
                                        if (theCause != null) continue;
                                        theCause = e;
                                    }
                                    catch (Exception e) {
                                        if (theCause != null) continue;
                                        theCause = e;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file with name (scheme) <" + aFilePath + "> found, where a suffix (if applicable) might by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
        }

        public static byte[] toByteArray(InputStream aInputStream) throws IOException {
            int eRead;
            ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
            byte[] theData = new byte[16384];
            while ((eRead = aInputStream.read(theData, 0, theData.length)) != -1) {
                theBuffer.write(theData, 0, eRead);
            }
            theBuffer.flush();
            return theBuffer.toByteArray();
        }
    }
}

