/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.io.BytesSource;
import org.refcodes.struct.ByteArrayAccessor;

public class ByteArraySource
implements BytesSource,
ByteArrayAccessor {
    private final List<Byte> _byteList = new ArrayList<Byte>();

    @Override
    public void transmitByte(byte aByte) throws IOException {
        this._byteList.add(aByte);
    }

    @Override
    public void transmitBytes(byte[] aBytes, int aOffset, int aLength) throws IOException {
        for (int i = aOffset; i < aLength; ++i) {
            this._byteList.add(aBytes[i]);
        }
    }

    @Override
    public byte[] getBytes() {
        return ByteArraySource.toPrimitiveType(this._byteList.toArray(new Byte[this._byteList.size()]));
    }

    private static byte[] toPrimitiveType(Byte[] aBytes) {
        if (aBytes == null) {
            return null;
        }
        byte[] thePrimitives = new byte[aBytes.length];
        for (int i = 0; i < aBytes.length; ++i) {
            thePrimitives[i] = aBytes[i];
        }
        return thePrimitives;
    }
}

