/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;

public class XorCondition
extends AbstractCondition {
    public XorCondition(Term ... aArgs) {
        super("Exactly one (XOR) syntax branch must match from the command line arguments.", aArgs);
    }

    protected XorCondition(String aDescription, Term ... aArgs) {
        super(aDescription, aArgs);
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aKeywords, CliContext aCliCtx) throws ArgsSyntaxException {
        ArrayList<AnyCondition> theOptionals = new ArrayList<AnyCondition>();
        Operand<?>[] theResult = null;
        Term theResultSyntaxable = null;
        Operand<?>[] eOperands = null;
        int theMatchCount = this._children.length;
        ArgsSyntaxException theCause = null;
        for (Term eChild : this._children) {
            if (eChild instanceof AnyCondition) {
                theOptionals.add((AnyCondition)eChild);
            }
            try {
                eOperands = theResult != null && eChild instanceof Operand && theResultSyntaxable instanceof Option ? eChild.parseArgs(XorCondition.toArgsDiff(aArgs, theResult), aKeywords, aCliCtx) : eChild.parseArgs(aArgs, aKeywords, aCliCtx);
                if (eOperands != null && eOperands.length == 0) {
                    eOperands = null;
                }
            }
            catch (ArgsSyntaxException e) {
                if (theCause == null) {
                    theCause = e;
                } else {
                    theCause.addSuppressed(e);
                }
                --theMatchCount;
            }
            theResult = XorCondition.removeDuplicates(theResult, eOperands);
            if (theResult != null && eOperands != null) {
                this._exception = new AmbiguousArgsException("More than one syntax branch matched the command line arguments, though exactly one (XOR) syntax branch must match!", aArgs, (Term)this, theCause);
                throw this._exception;
            }
            if (eOperands != null && eOperands.length != 0 && theResult == null) {
                theResult = eOperands;
                theResultSyntaxable = eChild;
            }
            eOperands = null;
        }
        if (theMatchCount == 0) {
            this._exception = new UnknownArgsException("No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match!", aArgs, (Term)this, theCause);
            throw this._exception;
        }
        if (theMatchCount > 1) {
            if (theOptionals.size() > 1 && aArgs != null && aArgs.length > 0) {
                this._exception = new AmbiguousArgsException("No syntax branch (fully) matched the command line arguments causing exclusive (XOR) ambiguity for the according syntax branch!", aArgs, (Term)this, theCause);
                throw this._exception;
            }
            if ((theMatchCount -= theOptionals.size()) > 1) {
                this._exception = new AmbiguousArgsException("No syntax branch (fully) matched the command line arguments causing exclusive (XOR) ambiguity for the according syntax branch!", aArgs, (Term)this, theCause);
                throw this._exception;
            }
        }
        if (theResult != null) {
            return theResult;
        }
        if (theOptionals.size() == 0) {
            return new Operand[0];
        }
        this._exception = new UnknownArgsException("No syntax branch (fully) matched the provided command line arguments, though one (XOR) syntax branch must match!", aArgs, (Term)this, theCause);
        throw this._exception;
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        Object theSynopsis = "";
        for (Term eChild : this._children) {
            if (!eChild.isVisible()) continue;
            if (((String)theSynopsis).length() != 0) {
                theSynopsis = (String)theSynopsis + (String)(aCliCtx.getSyntaxMetrics().getXorSymbol() != null && aCliCtx.getSyntaxMetrics().getXorSymbol().length() != 0 ? " " + aCliCtx.getSyntaxMetrics().getXorSymbol() + " " : " ");
            }
            theSynopsis = (String)theSynopsis + eChild.toSyntax(aCliCtx);
        }
        return theSynopsis;
    }

    @Override
    public XorCondition withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return this;
    }

    private static Operand<?>[] removeDuplicates(Operand<?>[] aOperands, Operand<?>[] aDuplicates) {
        if (aOperands != null && aDuplicates != null) {
            ArrayList theResult = new ArrayList();
            for (Operand<?> eOperand : aOperands) {
                theResult.add(eOperand);
            }
            for (Operand<?> eOperand : aDuplicates) {
                if (!theResult.contains(eOperand)) continue;
                theResult.remove(eOperand);
            }
            aOperands = theResult.isEmpty() ? null : theResult.toArray(new Operand[theResult.size()]);
        }
        return aOperands;
    }
}

