/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Directive;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseDirectiveArgsException;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownOperationArgsException;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;

public abstract class AbstractDirective<T>
extends AbstractOperand<T>
implements Directive<T> {
    private static final String OPERATION_KEY = "OPERATION";
    private String _operation;

    public AbstractDirective(String aOperation, Class<T> aType, String aAlias, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aType, aAlias != null ? aAlias : (aOperation != null ? aOperation : null), aDescription, aConsumer);
        this._operation = aOperation;
    }

    public AbstractDirective(Relation<String, T> aProperty, Class<T> aType) {
        this(aProperty, aType, null);
    }

    public AbstractDirective(Relation<String, T> aProperty, Class<T> aType, Consumer<? extends Operand<T>> aConsumer) {
        super(aProperty, aType, aConsumer);
        this._operation = ((String)aProperty.getKey()).length() > 1 ? (String)aProperty.getKey() : null;
    }

    public AbstractDirective(String aOperation, Class<T> aType, String aAlias, String aDescription) {
        this(aOperation, aType, aAlias, aDescription, null);
    }

    protected AbstractDirective(String aOperation, Class<T> aType, String aDescription) {
        this(aOperation, aType, null, aDescription);
    }

    protected AbstractDirective(String aOperation, Class<T> aType, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        this(aOperation, aType, null, aDescription, aConsumer);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getOperation() {
        return this._operation;
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aKeywords, CliContext aCliCtx) throws ArgsSyntaxException {
        Relation<String, String> theOptionArgument = this.toOperationOperand(aArgs, this._operation, aKeywords);
        if (theOptionArgument != null) {
            this.setParsedArgs(new String[]{(String)theOptionArgument.getKey(), (String)theOptionArgument.getValue()});
            this.setValue(this.toType((String)theOptionArgument.getValue()));
            this._matchCount = 1;
            return new Operand[]{this};
        }
        if (AbstractDirective.contains(aArgs, this._operation)) {
            this._exception = new ParseDirectiveArgsException("Missing value for operation \"{1}\" requiring a value.", aArgs, this._operation, (Term)this);
            throw this._exception;
        }
        throw new UnknownOperationArgsException("No operation \"{1}\" was found in the command line arguments, provide it to match the according syntax branch!", aArgs, this._operation, this);
    }

    @Override
    public CliSchema toSchema() {
        CliSchema theSchema = super.toSchema();
        theSchema.put(OPERATION_KEY, this._operation);
        return theSchema;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this.getAlias() + ", args=" + Arrays.toString(this.getParsedArgs()) + ", operation=" + this._operation + ", type=" + String.valueOf(this.getType()) + ", value=" + String.valueOf(this.getValue()) + ", matchCount=" + this.getMatchCount() + ", description=" + this.getDescription() + "]";
    }

    @Override
    protected void setParsedArgs(String[] aArgs) {
        super.setParsedArgs(aArgs);
    }

    @Override
    protected void setValue(T aValue) {
        super.setValue(aValue);
    }

    protected static boolean contains(String[] aArgs, String aArg) {
        if (aArg != null) {
            ArrayList<String> theList = new ArrayList<String>(Arrays.asList(aArgs));
            return theList.contains(aArg);
        }
        return false;
    }

    private Relation<String, String> toOperationOperand(String[] aArgs, String aOperation, String[] aKeywords) {
        for (int i = 0; i < aArgs.length - 1; ++i) {
            String eArg = aArgs[i];
            if (!eArg.equals(aOperation)) continue;
            String eOptArg = aArgs[i + 1];
            if (aKeywords != null) {
                for (String eKeyword : aKeywords) {
                    if (this.getOperation().equals(eKeyword) || !eOptArg.equalsIgnoreCase(eKeyword)) continue;
                    return null;
                }
            }
            return new RelationImpl<String, String>(aOperation, eOptArg);
        }
        return null;
    }
}

