/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.passgen;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.CharSet;
import org.refcodes.generator.AlphabetCounterComposite;
import org.refcodes.generator.AlphabetCounterMetrics;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "passgen";
    private static final String TITLE = "\ud83d\uddddPASS\ud83d\udd13GEN";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/passgen_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String DESCRIPTION = "A tool for generating password lists written into a file or printed to <STDOUT> by providing rule expressions (see [https://www.metacodes.pro/manpages/passgen_manpage]).";
    private static final String OUTPUTFILE_PROPERTY = "outputFile";
    private static final String CHARSET_PROPERTY = "charSet";
    private static final String ALPHABET_PROPERTY = "alphabet";
    private static final String MINLENGTH_PROPERTY = "minLength";
    private static final String MAXLENGTH_PROPERTY = "maxLength";
    private static final String EXPRESSION_PROPERTY = "expression";
    private static final int DEFAULT_MINLENGTH = 1;
    private static final int DEFAULT_MAXLENGTH = -1;
    private static final CharSet DEFAULT_CHARSET = CharSet.ASCII;

    public static void main(String[] args) {
        EnumOption<CharSet> theCharSetArg = CliSugar.enumOption("char-set", CharSet.class, CHARSET_PROPERTY, "The character set to use when generating passwords: " + VerboseTextBuilder.asString(CharSet.values()));
        StringOption theAlphabetArg = CliSugar.stringOption(Character.valueOf('a'), ALPHABET_PROPERTY, ALPHABET_PROPERTY, "The alphabet to when generating passwords.");
        StringOption theOutputFileArg = CliSugar.stringOption(Character.valueOf('o'), "output-file", OUTPUTFILE_PROPERTY, "The output file which to write to.");
        StringOption theExpressionArg = CliSugar.stringOption(Character.valueOf('e'), EXPRESSION_PROPERTY, EXPRESSION_PROPERTY, "The expression(s) in combination defining the password each as of \"[minLength-maxLength]:{char(s),char(s),...,char(s)}:'startValue'\". e.g. \"[3-12]:{A-Z,0-9,ASCII_SPECIAL,U+03B1,U+03B2,U+03B3,a,b,c}:'a10!Y'\" (generated password's min length is 3, max length is 12, valid characters include all upper case letters from 'A' to 'Z', all digits from '0' to '9', the ASCII_SPECIAL char(s), the letters 'alpha', 'beta', 'gamma' as of the given UTF codepoints as well as the letters 'a', 'b', 'c' and the section's start value \"a10!Y\"). Predefined char sets as of: " + VerboseTextBuilder.asString(CharSet.values()));
        ArrayOption<String> theExpressionArgs = CliSugar.asArray(theExpressionArg);
        DebugFlag theDebugFlag = CliSugar.debugFlag(false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        IntOption theMinLengthArg = CliSugar.intOption("min-length", MINLENGTH_PROPERTY, "Min password length to generate (defaults to <1>).");
        IntOption theMaxLengthArg = CliSugar.intOption("max-length", MAXLENGTH_PROPERTY, "Max password length to generate, a value of -1 denotes an infinite max length (defaults to <-1>).");
        CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(CliSugar.xor(theExpressionArgs, CliSugar.any(theMinLengthArg, theMaxLengthArg, CliSugar.xor(theCharSetArg, theAlphabetArg))), CliSugar.any(theOutputFileArg, theVerboseFlag, theDebugFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theVerboseFlag))));
        Example[] theExamples = CliSugar.examples(CliSugar.example("Generate passwords using a char set", theCharSetArg, theVerboseFlag), CliSugar.example("Generate passwords using a custom alphabet", theAlphabetArg, theVerboseFlag), CliSugar.example("Generate passwords [min..max] using a char set", theCharSetArg, theMinLengthArg, theMaxLengthArg, theVerboseFlag), CliSugar.example("Generate passwords [min..max] using a custom alphabet", theAlphabetArg, theMinLengthArg, theMaxLengthArg, theVerboseFlag), CliSugar.example("Generate complex passwords with three expressions", theExpressionArg, theExpressionArg, theExpressionArg), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
        CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
        ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
        boolean isVerbose = theCliHelper.isVerbose();
        try {
            AlphabetCounterMetrics[] theAlphabetCounterMetrics;
            String theOutputFileName = (String)theArgsProperties.get((Object)theOutputFileArg);
            OutputStream theOutputStream = Execution.toBootstrapStandardOut();
            if (theOutputFileName != null && theOutputFileName.length() != 0) {
                File theOutputFile = new File(theOutputFileName);
                if (isVerbose) {
                    LOGGER.info("Output file = \"" + theOutputFileName + "\" (<" + theOutputFile.getAbsolutePath() + ">)");
                }
                theOutputStream = new FileOutputStream(theOutputFile);
            }
            if (theMinLengthArg.hasValue() || theMaxLengthArg.hasValue() || theAlphabetArg.hasValue() || theCharSetArg.hasValue()) {
                int theMinLength = theArgsProperties.getIntOr(theMinLengthArg, (Integer)1);
                int theMaxLength = theArgsProperties.getIntOr(theMaxLengthArg, (Integer)-1);
                String theAlphabet = (String)theArgsProperties.get((Object)theAlphabetArg);
                CharSet theCharSet = theArgsProperties.getEnum(CharSet.class, (Object)theCharSetArg);
                theAlphabetCounterMetrics = new AlphabetCounterMetrics[]{Main.toAlphabetCounterMetrics(theMinLength, theMaxLength, theAlphabet, theCharSet)};
            } else if (theExpressionArgs.hasValue()) {
                String[] theExpressions = (String[])theArgsProperties.getArray((Object)theExpressionArg);
                if (theExpressions == null || theExpressions.length == 0) {
                    throw new IllegalArgumentException("You provided empty expression(s) " + (theExpressions == null ? "<null>" : "<{}>") + " for argument (property) <expression> though at least one expression is required!");
                }
                theAlphabetCounterMetrics = new AlphabetCounterMetrics[theExpressions.length];
                for (int i = 0; i < theExpressions.length; ++i) {
                    theAlphabetCounterMetrics[i] = new AlphabetCounterMetrics(theExpressions[i]);
                }
            } else {
                throw new IllegalArgumentException("Either an alphabet as of \"" + theAlphabetArg.toUsage() + " \" must be defined or expressions as of \"" + theExpressionArg.toUsage() + "\" must be provided.");
            }
            if (isVerbose) {
                LOGGER.info("Number of expressions being processed = " + theAlphabetCounterMetrics.length);
                for (AlphabetCounterMetrics eMetrics : theAlphabetCounterMetrics) {
                    LOGGER.printSeparator();
                    LOGGER.info("Expression = '" + eMetrics.toAlphabetExpression() + "'");
                    LOGGER.info("Min length = " + eMetrics.getMinLength());
                    LOGGER.info("Max length = " + String.valueOf(eMetrics.getMaxLength() == -1 ? "\u221e" : Integer.valueOf(eMetrics.getMaxLength())));
                    if (eMetrics.getAlphabet() != null) {
                        LOGGER.info("Alphabet = " + VerboseTextBuilder.asString(eMetrics.getAlphabet()));
                    }
                    if (eMetrics.getStartValue() != null) {
                        LOGGER.info("Start value = " + eMetrics.getStartValue());
                    }
                    if (eMetrics.getWords() == null) continue;
                    LOGGER.info("Words = " + VerboseTextBuilder.asString(eMetrics.getWords()));
                }
                LOGGER.printTail();
            }
            AlphabetCounterComposite theAlphabetCounter = new AlphabetCounterComposite(theAlphabetCounterMetrics);
            try (BufferedOutputStream theBufferedOutputStream = new BufferedOutputStream(theOutputStream);
                 OutputStreamWriter theWriter = new OutputStreamWriter(theBufferedOutputStream);){
                while (theAlphabetCounter.hasNext()) {
                    theWriter.write(theAlphabetCounter.next());
                    theWriter.write(Terminal.getLineBreak());
                }
            }
        }
        catch (Throwable e) {
            theCliHelper.exitOnException(e);
        }
    }

    private static AlphabetCounterMetrics toAlphabetCounterMetrics(int aMinLength, int aMaxLength, String aAlphabet, CharSet theCharSet) {
        if (aAlphabet == null && theCharSet == null) {
            theCharSet = DEFAULT_CHARSET;
        }
        ArrayList<Character> theChars = new ArrayList<Character>();
        if (aAlphabet != null && aAlphabet.length() != 0) {
            for (int i = 0; i < aAlphabet.length(); ++i) {
                if (theChars.contains(Character.valueOf(aAlphabet.charAt(i)))) continue;
                theChars.add(Character.valueOf(aAlphabet.charAt(i)));
            }
        }
        if (theCharSet != null) {
            for (char eChar : theCharSet.getCharSet()) {
                if (theChars.contains(Character.valueOf(eChar))) continue;
                theChars.add(Character.valueOf(eChar));
            }
        }
        if (theChars.isEmpty()) {
            throw new IllegalStateException("Either the <alphabet> or the <charSet> arguments (properties) must be set!");
        }
        Collections.sort(theChars);
        char[] theAlphabet = new char[theChars.size()];
        for (int i = 0; i < theAlphabet.length; ++i) {
            theAlphabet[i] = ((Character)theChars.get(i)).charValue();
        }
        return new AlphabetCounterMetrics(aMinLength, aMaxLength, theAlphabet);
    }
}

