/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.refcodes.data.Delimiter;
import org.refcodes.web.AbstractHttpFields;
import org.refcodes.web.Cookie;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HeaderFields;

public abstract class AbstractHeaderFields<C extends Cookie, T extends HeaderFields<C, T>>
extends AbstractHttpFields<T>
implements HeaderFields<C, T> {
    private final List<C> _cookies = new ArrayList<C>();

    public AbstractHeaderFields() {
    }

    public AbstractHeaderFields(Map<String, List<String>> aHttpFields) {
        AbstractHeaderFields.toHeaderFields(aHttpFields, this);
    }

    @Override
    public List<String> get(Object aKey) {
        String theKey = this.toHeaderField(aKey);
        if (theKey != null && theKey.equalsIgnoreCase(this.getCookieFieldName())) {
            String[] theCookies = this.toHttpCookies();
            if (theCookies != null) {
                return new ArrayList<String>(Arrays.asList(theCookies));
            }
            return null;
        }
        return (List)super.get(theKey);
    }

    @Override
    public Set<String> keySet() {
        if (this._cookies.size() != 0) {
            HashSet<String> theKeySet = new HashSet<String>(super.keySet());
            theKeySet.add(this.getCookieFieldName());
            return theKeySet;
        }
        return super.keySet();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        String[] theCookies;
        if (this._cookies.size() != 0 && (theCookies = this.toHttpCookies()) != null) {
            HashSet<Map.Entry<String, List<String>>> theEntrySet = new HashSet<Map.Entry<String, List<String>>>(super.entrySet());
            theEntrySet.add(new Field(this.getCookieFieldName(), new ArrayList<String>(Arrays.asList(theCookies))));
            return theEntrySet;
        }
        return super.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> put(String aKey, List<String> aValue) {
        String theKey = this.toHeaderField(aKey);
        if (theKey != null && theKey.equalsIgnoreCase(this.getCookieFieldName())) {
            List<C> list = this._cookies;
            synchronized (list) {
                ArrayList<String> theCookieFields = null;
                if (this._cookies != null && this._cookies.size() != 0) {
                    theCookieFields = new ArrayList<String>();
                    for (Cookie eCookie : this._cookies) {
                        theCookieFields.add(eCookie.toHttpCookie());
                    }
                }
                this._cookies.clear();
                for (String aHttpCookie : aValue) {
                    this.addCookie(this.createCookie(aHttpCookie));
                }
                return theCookieFields;
            }
        }
        return super.put(theKey, aValue);
    }

    @Override
    public void addTo(String aHeaderField, String aValue) {
        String theKey = this.toHeaderField(aHeaderField);
        if (theKey.equals(this.getCookieFieldName())) {
            this.addCookie(this.createCookie(aValue));
        } else {
            HeaderFields.super.addTo(theKey, aValue);
        }
    }

    @Override
    public C addCookie(C aCookie) {
        this._cookies.add(aCookie);
        return aCookie;
    }

    @Override
    public List<C> getAllCookies() {
        return this._cookies;
    }

    @Override
    public C addCookie(String aCookieName, String aValue) {
        return this.addCookie(this.createCookie(aCookieName, aValue));
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> aMap) {
        for (String string : aMap.keySet()) {
            List<String> eValues = aMap.get(string);
            String string2 = HeaderField.toHttpHeaderField(string);
            if (this.getCookieFieldName().equalsIgnoreCase(string2)) {
                if (eValues == null || eValues.isEmpty()) continue;
                for (String eHttpCookie : eValues) {
                    this.addCookie((C)eHttpCookie);
                }
                continue;
            }
            this.put(string2, (List<String>)new ArrayList<String>(eValues));
        }
    }

    protected static boolean isCommaSeparatedHeaderField(String aHeaderName) {
        return HeaderField.ACCEPT.getName().equalsIgnoreCase(aHeaderName) || HeaderField.COOKIE.getName().equalsIgnoreCase(aHeaderName) || HeaderField.SET_COOKIE.getName().equalsIgnoreCase(aHeaderName);
    }

    protected static void toHeaderFields(Map<String, List<String>> aFromFields, HeaderFields<?, ?> aToFields) {
        for (String eKey : aFromFields.keySet()) {
            List<String> eValues = aFromFields.get(eKey);
            eKey = HeaderField.toHttpHeaderField(eKey);
            if (eValues == null) continue;
            for (String eElement : eValues) {
                if (eElement == null || eElement.trim().length() == 0) continue;
                if (AbstractHeaderFields.isCommaSeparatedHeaderField(eKey)) {
                    String[] eElements = eElement.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar());
                    aToFields.addTo(eKey, eElements);
                    continue;
                }
                aToFields.addTo(eKey, eElement);
            }
        }
    }

    protected String toHeaderField(Object aHeaderField) {
        if (aHeaderField == null) {
            return null;
        }
        String theHeaderField = !(aHeaderField instanceof String) ? aHeaderField.toString() : (String)aHeaderField;
        return HeaderField.toHttpHeaderField(theHeaderField);
    }

    protected abstract String getCookieFieldName();

    protected abstract C createCookie(String var1, String var2);

    protected abstract C createCookie(String var1);

    private static class Field
    implements Map.Entry<String, List<String>> {
        private final String _key;
        private List<String> _value;

        public Field(String aKey, List<String> aValue) {
            this._key = aKey;
            this._value = aValue;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public List<String> getValue() {
            return this._value;
        }

        @Override
        public List<String> setValue(List<String> value) {
            List<String> theReturn = this._value;
            this._value = value;
            return theReturn;
        }
    }
}

