/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.alt.chaos;

import org.refcodes.security.Decrypter;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.alt.chaos.ChaosDecryptionInputStream;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosMode;
import org.refcodes.security.alt.chaos.ChaosOptions;

public class ChaosDecrypter
implements Decrypter<byte[], byte[], DecryptionException> {
    private double _x;
    private double _a;
    private long _s;
    private byte _previousEncrypted = 0;
    private ChaosOptions _chaosMetrics;
    private ChaosDecrypter _childDecrypter = null;

    public ChaosDecrypter(ChaosKey aKey) {
        this(aKey, -1);
    }

    public ChaosDecrypter(ChaosKey aKey, int aChildDepth) {
        this.init(aKey, aChildDepth);
    }

    protected ChaosDecrypter(ChaosKey aKey, int aChildDepth, ChaosDecrypter aChildDecrypter) {
        if (aChildDecrypter != null && aKey.getChild() != null) {
            throw new IllegalArgumentException("You provided a chaos key with child and a child encrypiter, either the key can have a child or a child encrypter is provided, but not both at the same time!");
        }
        this.init(aKey, aChildDepth);
        if (aChildDecrypter != null) {
            this._childDecrypter = aChildDecrypter;
        }
    }

    private void init(ChaosKey aKey, int aChildDepth) {
        this._x = aKey.getX0();
        this._a = aKey.getA();
        this._s = aKey.getS();
        ChaosOptions chaosOptions = this._chaosMetrics = aKey.getOptions() != null ? aKey.getOptions() : ChaosMode.NONE;
        if (aChildDepth != 0 && aKey.getChild() != null) {
            if (!aKey.getChild().getOptions().isFixedLength()) {
                throw new IllegalArgumentException("The provided chaos key chain is not(!) of a fixed length (<" + String.valueOf(aKey.getChild().getOptions()) + ">) when applied and requires something like a <" + ChaosDecryptionInputStream.class.getSimpleName() + "> supporting the variable length features when applied!");
            }
            this._childDecrypter = new ChaosDecrypter(aKey.getChild(), aChildDepth != -1 ? aChildDepth - 1 : -1);
        }
    }

    @Override
    public byte[] toDecrypted(byte[] aEncrypted) throws DecryptionException {
        byte[] theDecrypted = new byte[aEncrypted.length];
        this.toDecrypted(aEncrypted, 0, aEncrypted.length, theDecrypted, 0);
        return theDecrypted;
    }

    @Override
    public int toDecrypted(byte[] aBuffer, int aOffset, int aLength, byte[] aOutBuffer, int aOutOffset) throws DecryptionException {
        if (aOutBuffer.length - aOutOffset < aLength) {
            throw new ArrayIndexOutOfBoundsException("Buffer at index <\" + aOutBuffer.length + \"> too short to hold encrypted data!");
        }
        if (aBuffer.length < aLength + aOffset) {
            throw new IllegalArgumentException("The input length <" + aBuffer.length + "> is smaller than the offset <" + aOffset + "> and the processable length <" + aLength + ">!");
        }
        byte[] theBuffer = aBuffer;
        int theOffset = aOffset;
        if (this._childDecrypter != null) {
            theBuffer = new byte[aLength];
            theOffset = 0;
            System.arraycopy(aBuffer, aOffset, theBuffer, 0, aLength);
            this._childDecrypter.toDecrypted(aBuffer, aOffset, aLength, theBuffer, 0);
        }
        for (int i = 0; i < theBuffer.length; ++i) {
            byte n = theBuffer[theOffset + i];
            if (this._chaosMetrics.isMutateS()) {
                this._s = ChaosKey.addToS(this._s, this._previousEncrypted);
            }
            this._x = this._x * this._a * (1.0 - this._x);
            double k = (double)this._s * this._x;
            byte y = (byte)(((double)n - k) % 256.0);
            if (this._chaosMetrics.isXorNext()) {
                y = (byte)(0xFF & (y ^ this._previousEncrypted));
            }
            this._previousEncrypted = theBuffer[theOffset + i];
            aOutBuffer[i + aOutOffset] = y;
        }
        return aLength;
    }

    @Override
    public void dispose() {
        this._a = -1.0;
        this._s = -1L;
        this._x = -1.0;
        this._previousEncrypted = (byte)-1;
        this._chaosMetrics = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [x=" + this._x + ", a=" + this._a + ", s=" + this._s + ", prev=" + this._previousEncrypted + ", chaosMetrics=" + String.valueOf(this._chaosMetrics) + "]";
    }
}

