/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.exception.Trap;
import org.refcodes.rest.RestClient;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestResponseConsumer;
import org.refcodes.rest.RestResponseEvent;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.FormFields;
import org.refcodes.web.HeaderFieldsAccessor;
import org.refcodes.web.HttpClientRequest;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;
import org.refcodes.web.HttpRequestBuilder;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.QueryFieldsAccessor;
import org.refcodes.web.RedirectDepthAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlAccessor;
import org.refcodes.web.UrlBuilder;

public class RestResponseHandler
extends HttpClientRequest
implements RestResponseConsumer,
QueryFieldsAccessor.QueryFieldsProperty,
HeaderFieldsAccessor.HeaderFieldsProperty<RequestHeaderFields>,
RedirectDepthAccessor.RedirectDepthBuilder<RestResponseHandler>,
HttpRequestBuilder<RestResponseHandler>,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestResponseHandler>,
LinkComponent.LinkComponentBuilder<RestResponseHandler>,
ConnectionStatusAccessor,
HeaderFieldsAccessor.HeaderFieldsBuilder<RequestHeaderFields, RestResponseHandler> {
    private static final Logger LOGGER = Logger.getLogger(RestResponseHandler.class.getName());
    private RestResponseConsumer _responseObserver = null;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public RestResponseHandler(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, RestResponseConsumer aResponseConsumer, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, aHeaderFields, aRequest, -1, aResponseConsumer, aMediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod aHttpMethod, Url aUrl, RestResponseConsumer aResponseConsumer, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, null, null, aResponseConsumer, aMediaTypeFactoryLookup);
    }

    public RestResponseHandler(MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(null, null, null, null, null, aMediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod aHttpMethod, Url aUrl, Object aRequest, RestResponseConsumer aResponseConsumer, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, null, aRequest, aResponseConsumer, aMediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod aHttpMethod, Url aUrl, RestResponseConsumer aResponseConsumer, int aRedirectDepth, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, null, null, aRedirectDepth, aResponseConsumer, aMediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod aHttpMethod, Url aUrl, Object aRequest, int aRedirectDepth, RestResponseConsumer aResponseConsumer, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, null, aRequest, aRedirectDepth, aResponseConsumer, aMediaTypeFactoryLookup);
    }

    public RestResponseHandler(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, int aRedirectDepth, RestResponseConsumer aResponseConsumer, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, aUrl instanceof UrlBuilder ? aUrl : new UrlBuilder(aUrl), aHeaderFields, aRequest, aRedirectDepth, aMediaTypeFactoryLookup);
        this._responseObserver = aResponseConsumer;
    }

    @Override
    public RestResponseHandler withRedirectDepth(int aRedirectDepth) {
        this.setRedirectDepth(aRedirectDepth);
        return this;
    }

    @Override
    public void setQueryFields(FormFields aQueryFields) {
        Url theUrl = this.getUrl();
        UrlBuilder theUrlBuilder = theUrl instanceof UrlAccessor.UrlBuilder ? (UrlBuilder)theUrl : new UrlBuilder(theUrl);
        theUrlBuilder.setQueryFields(aQueryFields);
        this.setUrl(theUrlBuilder);
    }

    @Override
    public FormFields getQueryFields() {
        return this.getUrl().getQueryFields();
    }

    @Override
    public RestResponseHandler withUrl(Url aUrl) {
        this.setUrl(aUrl);
        return this;
    }

    @Override
    public RestResponseHandler withHttpMethod(HttpMethod aHttpMethod) {
        this.setHttpMethod(aHttpMethod);
        return this;
    }

    public <REQ> RestResponseHandler withRequest(REQ aRequest) {
        this.setRequest(aRequest);
        return this;
    }

    @Override
    public void onResponse(RestResponseEvent aResponse) throws HttpResponseException {
        if (this._connectionStatus != ConnectionStatus.CLOSED) {
            this._responseObserver.onResponse(aResponse);
        } else {
            LOGGER.log(Level.WARNING, "Ignoring response <" + String.valueOf(aResponse) + "> as this rest endpoint is in status <" + String.valueOf((Object)this._connectionStatus) + ">, you may have closed it already?");
        }
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethod aHttpMethod) {
        this._httpMethod = aHttpMethod;
    }

    public RestResponseConsumer getResponseObserver() {
        return this._responseObserver;
    }

    public void setResponseObserver(RestResponseConsumer aLambda) {
        this._responseObserver = aLambda;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        this._connectionStatus = ConnectionStatus.OPENED;
        RestResponseHandler restResponseHandler = this;
        synchronized (restResponseHandler) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
        RestResponseHandler restResponseHandler = this;
        synchronized (restResponseHandler) {
            this.notifyAll();
        }
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    @Override
    public void setHeaderFields(RequestHeaderFields aHeaderFields) {
        this._headerFields = aHeaderFields;
    }

    @Override
    public Url getUrl() {
        return this._url;
    }

    @Override
    public void setUrl(Url aUrl) {
        this._url = aUrl;
    }

    public RestResponseHandler withResponseObserver(RestResponseConsumer aLambda) {
        this.setResponseObserver(aLambda);
        return this;
    }

    @Override
    public RestResponseHandler withHeaderFields(RequestHeaderFields aRequestHeaderFields) {
        this.setHeaderFields(aRequestHeaderFields);
        return this;
    }

    @Override
    public RestResponseHandler withOpen() throws IOException {
        this.open();
        return this;
    }

    @Override
    public RestResponseHandler withClose() throws IOException {
        this.close();
        return this;
    }

    @Override
    public RestResponseHandler withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    @Override
    public RestResponseHandler withCloseIn(int aCloseMillis) {
        this.closeIn(aCloseMillis);
        return this;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf((Object)this._httpMethod) + ": " + this._url.toHttpUrl() + "?" + new VerboseTextBuilder().withElements(this._url.getQueryFields()).toString() + ")@" + this.hashCode();
    }

    public static RestResponseHandler build(RestClient aRestClient) {
        return new RestResponseHandler(aRestClient);
    }

    static class RestResponseHandlerDaemon
    implements Runnable {
        private final RestResponseHandler _responseHandler;
        private final RestRequestHandler _requestHandler;
        private final RestClient _source;

        protected RestResponseHandlerDaemon(RestResponseHandler aResponseHandler, RestRequestHandler aRequestHandler, RestClient aSource) {
            Objects.requireNonNull(aRequestHandler, "The request-handler argument must not be null!");
            this._responseHandler = aResponseHandler;
            this._requestHandler = aRequestHandler;
            this._source = aSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RestResponseHandler restResponseHandler = this._responseHandler;
                synchronized (restResponseHandler) {
                    while (this._responseHandler.getConnectionStatus() == ConnectionStatus.NONE) {
                        try {
                            this._responseHandler.wait(DaemonLoopSleepTime.MAX.getTimeMillis());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this._responseHandler.getConnectionStatus() != ConnectionStatus.NONE) continue;
                        LOGGER.log(Level.WARNING, "Your handler's <" + String.valueOf(this._responseHandler) + "> connection status is still <" + String.valueOf((Object)this._responseHandler.getConnectionStatus()) + "> after <" + DaemonLoopSleepTime.MAX.getTimeMillis() + "> ms, execution of your request starts not earlier than you calling the #open() method.");
                    }
                }
                if (this._responseHandler.getConnectionStatus() != ConnectionStatus.OPENED) {
                    throw new IllegalStateException("Aborting your request as of your handler <" + String.valueOf(this._responseHandler) + "> connection status is <" + String.valueOf((Object)this._responseHandler.getConnectionStatus()) + "> although it is expected to e <" + String.valueOf((Object)ConnectionStatus.OPENED) + ">.");
                }
                RestResponse theResponse = this._requestHandler.doRequest(this._responseHandler);
                this._responseHandler.onResponse(new RestResponseEvent(theResponse, this._source));
            }
            catch (HttpResponseException e) {
                LOGGER.log(Level.SEVERE, Trap.asMessage(e), e);
            }
        }
    }
}

