/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.component.Openable;
import org.refcodes.rest.RestClient;
import org.refcodes.security.StoreType;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;
import org.refcodes.web.BaseUrlAccessor;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.HttpClientContext;
import org.refcodes.web.HttpClientInterceptable;
import org.refcodes.web.OauthToken;
import org.refcodes.web.Url;

public interface HttpRestClient
extends RestClient,
HttpClientInterceptable,
ConnectionStatusAccessor,
ConnectionComponent<HttpClientContext>,
LinkComponent,
Openable.OpenBuilder<HttpRestClient>,
BaseUrlAccessor.BaseUrlProperty,
BaseUrlAccessor.BaseUrlBuilder<HttpRestClient>,
TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty,
TrustStoreDescriptorAccessor.TrustStoreDescriptorBuilder<HttpRestClient> {
    public static final String DEFAULT_KEYSTORE_TYPE = StoreType.JKS.name();
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";

    @Override
    default public void open() throws IOException {
        this.open(this.getBaseUrl(), this.getTrustStoreDescriptor());
    }

    @Override
    default public void open(HttpClientContext aCtx) throws IOException {
        this.open(aCtx.getBaseUrl(), aCtx.getTrustStoreDescriptor());
    }

    @Override
    default public void open(TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this.open(this.getBaseUrl(), aStoreDescriptor);
    }

    @Override
    default public void open(Url aBaseUrl) throws IOException {
        this.open(aBaseUrl, this.getTrustStoreDescriptor());
    }

    public void open(Url var1, TrustStoreDescriptor var2) throws IOException;

    @Override
    default public HttpRestClient withOpen() throws IOException {
        this.open();
        return this;
    }

    default public HttpRestClient withOpen(HttpClientContext aCtx) throws IOException {
        this.open(aCtx);
        return this;
    }

    default public HttpRestClient withOpen(TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this.open(this.getBaseUrl(), aStoreDescriptor);
        return this;
    }

    default public HttpRestClient withOpen(Url aBaseUrl) throws IOException {
        this.open(aBaseUrl, this.getTrustStoreDescriptor());
        return this;
    }

    default public HttpRestClient withOpen(Url aBaseUrl, TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this.open(aBaseUrl, aStoreDescriptor);
        return this;
    }

    @Override
    default public HttpRestClient withBaseUrl(String aBaseUrl) throws MalformedURLException {
        this.setBaseUrl(aBaseUrl);
        return this;
    }

    @Override
    default public HttpRestClient withBaseUrl(Url aBaseUrl) {
        this.setBaseUrl(aBaseUrl);
        return this;
    }

    @Override
    default public HttpRestClient withBaseUrl(URL aBaseURL) {
        this.setBaseUrl(aBaseURL);
        return this;
    }

    @Override
    default public HttpRestClient withBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        this.setBasicAuthCredentials(aBasicAuthCredentials);
        return this;
    }

    @Override
    default public HttpRestClient withBasicAuthCredentials(String aUserName, String aSecret) {
        this.setBasicAuthCredentials(aUserName, aSecret);
        return this;
    }

    @Override
    default public HttpRestClient withOAuthToken(OauthToken aOauthToken) {
        this.setOauthToken(aOauthToken);
        return this;
    }

    @Override
    default public HttpRestClient withTrustStoreDescriptor(TrustStoreDescriptor aStoreDescriptor) {
        this.setTrustStoreDescriptor(aStoreDescriptor);
        return this;
    }

    @Override
    default public HttpRestClient withUserAgent(String aUserAgent) {
        this.setUserAgent(aUserAgent);
        return this;
    }
}

