/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.refcodes.data.Text;
import org.refcodes.properties.MapProperties;
import org.refcodes.properties.Properties;
import org.refcodes.struct.ImmutableCanonicalTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;

public interface ImmutableProperties
extends ImmutableCanonicalTable {
    public static final String DEFAULT_COMMENT = "Generated by <" + String.valueOf(Text.REFCODES_ORG) + "> (http://www.refcodes.org)";

    @Override
    default public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    default public char getAnnotator() {
        return ANNOTATOR;
    }

    @Override
    default public char getDelimiter() {
        return DELIMITER;
    }

    @Override
    default public Properties getDir(Collection<?> aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    @Override
    default public Properties getDir(Object aPath) {
        return this.getDir(this.toPath(aPath));
    }

    @Override
    default public Properties getDir(Object ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    @Override
    default public Properties getDir(String aPath) {
        return this.retrieveFrom(aPath);
    }

    @Override
    default public Properties getDir(String ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    @Override
    default public Properties getDirAt(Collection<?> aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    @Override
    default public Properties getDirAt(int aIndex) {
        return this.getDirAt(this.getRootPath(), aIndex);
    }

    @Override
    default public Properties getDirAt(Object aPath, int aIndex) {
        return this.getDirAt(this.toPath(aPath), aIndex);
    }

    @Override
    default public Properties getDirAt(Object[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    @Override
    default public Properties getDirAt(String aPath, int aIndex) {
        return this.retrieveFrom(this.toPath(aPath, Integer.toString(aIndex)));
    }

    @Override
    default public Properties getDirAt(String[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public Properties[] getDirs(Collection<?> aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public Properties[] getDirs(Object aPath) {
        return this.getDirs(this.toPath(aPath));
    }

    default public Properties[] getDirs(Object ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public Properties[] getDirs(String aPath) {
        Properties[] theDirs;
        if (this.isIndexDir(aPath)) {
            int[] theIndexes = this.getDirIndexes(aPath);
            theDirs = new Properties[theIndexes[theIndexes.length - 1] + 1];
            for (int i : theIndexes) {
                theDirs[theIndexes[i]] = this.getDirAt(aPath, theIndexes[i]);
            }
        } else {
            theDirs = new Properties[]{this.getDir(aPath)};
        }
        return theDirs;
    }

    default public Properties[] getDirs(String ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    @Override
    default public Class<String> getType() {
        return String.class;
    }

    @Override
    default public Properties query(Collection<?> aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    @Override
    default public Properties query(Object ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    @Override
    default public Properties query(Pattern aRegExp) {
        return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.super.query(aRegExp));
    }

    @Override
    default public Properties query(String aPathQuery) {
        return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.super.query(aPathQuery));
    }

    @Override
    default public Properties query(String ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    @Override
    default public Properties queryBetween(Collection<?> aFromPath, Collection<?> aPathQuery, Collection<?> aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    @Override
    default public Properties queryBetween(Object aFromPath, Object aPathQuery, Object aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    @Override
    default public Properties queryBetween(Object[] aFromPath, Object[] aPathQuery, Object[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    @Override
    default public Properties queryBetween(String aPathQuery, String aFromPath, String aToPath) {
        return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.super.queryBetween(aPathQuery, aFromPath, aToPath));
    }

    @Override
    default public Properties queryBetween(String[] aFromPath, String[] aPathQuery, String[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    @Override
    default public Properties queryFrom(Collection<?> aPathQuery, Collection<?> aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    @Override
    default public Properties queryFrom(Object aPathQuery, Object aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    @Override
    default public Properties queryFrom(Object[] aPathQuery, Object[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    @Override
    default public Properties queryFrom(Pattern aRegExp, String aFromPath) {
        return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.super.queryFrom(aRegExp, aFromPath));
    }

    @Override
    default public Properties queryFrom(String aPathQuery, String aFromPath) {
        return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.super.queryFrom(aPathQuery, aFromPath));
    }

    @Override
    default public Properties queryFrom(String[] aPathQuery, String[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    @Override
    default public Properties queryTo(Collection<?> aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    @Override
    default public Properties queryTo(Object aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    @Override
    default public Properties queryTo(Object[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    @Override
    default public Properties queryTo(Pattern aRegExp, String aToPath) {
        return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.super.queryTo(aRegExp, aToPath));
    }

    @Override
    default public Properties queryTo(String aPathQuery, String aToPath) {
        return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.super.queryTo(aPathQuery, aToPath));
    }

    @Override
    default public Properties queryTo(String[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    @Override
    default public Properties retrieveBetween(Collection<?> aFromPath, Collection<?> aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    @Override
    default public Properties retrieveBetween(Object aFromPath, Object aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    @Override
    default public Properties retrieveBetween(Object[] aFromPath, Object[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    @Override
    default public Properties retrieveBetween(String aFromPath, String aToPath) {
        Properties theProperties = this.retrieveFrom(aFromPath);
        return theProperties.retrieveTo(aToPath);
    }

    @Override
    default public Properties retrieveBetween(String[] aFromPath, String[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    @Override
    default public Properties retrieveFrom(Collection<?> aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    @Override
    default public Properties retrieveFrom(Object aParentPath) {
        return this.retrieveFrom(this.toPath(aParentPath));
    }

    @Override
    default public Properties retrieveFrom(Object ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    @Override
    public Properties retrieveFrom(String var1);

    @Override
    default public Properties retrieveFrom(String ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    @Override
    default public Properties retrieveTo(Collection<?> aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    @Override
    default public Properties retrieveTo(Object aToPath) {
        return this.retrieveTo(this.toPath(aToPath));
    }

    @Override
    default public Properties retrieveTo(Object ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    @Override
    public Properties retrieveTo(String var1);

    @Override
    default public Properties retrieveTo(String ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public static interface MutableProperties
    extends ImmutableProperties,
    ImmutableCanonicalTable.MutableCanonicalTable {
        @Override
        default public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        default public String delete(Property aProperty) {
            if (aProperty != null) {
                return (String)this.remove(aProperty.getKey());
            }
            return null;
        }

        default public void insert(ImmutableProperties aFrom) {
            this.insert((Object)aFrom);
        }

        default public void insert(Properties aFrom) {
            this.insert((Object)aFrom);
        }

        default public void insertBetween(String aToPath, ImmutableProperties aFrom, String aFromPath) {
            this.insertBetween(aToPath, (Object)aFrom, aFromPath);
        }

        default public void insertFrom(ImmutableProperties aFrom, String aFromPath) {
            this.insertFrom((Object)aFrom, aFromPath);
        }

        default public void insertTo(String aToPath, ImmutableProperties aFrom) {
            this.insertTo(aToPath, (Object)aFrom);
        }

        @Override
        default public String put(Relation<String, String> aRelation) {
            return this.put((String)aRelation.getKey(), (String)aRelation.getValue());
        }

        @Override
        default public void putAll(java.util.Properties aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (String)aProperties.get(eKey));
            }
        }

        @Override
        default public void putAll(Map<? extends String, ? extends String> aProperties) {
            for (String string : aProperties.keySet()) {
                this.put(string, aProperties.get(string));
            }
        }

        default public void putAll(ImmutableProperties aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (String)aProperties.get(eKey));
            }
        }

        @Override
        default public Properties putDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        @Override
        default public Properties putDirAt(Collection<?> aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
        }

        @Override
        default public Properties putDirAt(int aIndex, Object aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, aDir);
        }

        @Override
        default public Properties putDirAt(int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, (ImmutablePathTable)aDir);
        }

        @Override
        default public Properties putDirAt(Object aPath, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, aDir);
        }

        @Override
        default public Properties putDirAt(Object aPath, int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, (ImmutablePathTable)aDir);
        }

        @Override
        default public Properties putDirAt(Object[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        @Override
        default public Properties putDirAt(Object[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
        }

        @Override
        default public Properties putDirAt(String aPath, int aIndex, Object aDir) {
            Properties theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        @Override
        default public Properties putDirAt(String aPath, int aIndex, ImmutablePathTable<String> aDir) {
            Properties theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        @Override
        default public Properties putDirAt(String[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        @Override
        default public Properties putDirAt(String[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
        }

        @Override
        default public Properties removeAll(Collection<?> aPathQueryElemments) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeAll((Collection)aPathQueryElemments));
        }

        @Override
        default public Properties removeAll(Object ... aPathQueryElemments) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeAll(aPathQueryElemments));
        }

        @Override
        default public Properties removeAll(Object aPathQuery) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeAll(aPathQuery));
        }

        @Override
        default public Properties removeAll(Pattern aRegExp) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeAll(aRegExp));
        }

        @Override
        default public Properties removeAll(String ... aPathQueryElemments) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeAll(aPathQueryElemments));
        }

        @Override
        default public Properties removeAll(String aPathQuery) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeAll(aPathQuery));
        }

        @Override
        default public Properties removeDirAt(int aIndex) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeDirAt(aIndex));
        }

        @Override
        default public Properties removeDirAt(Object aPath, int aIndex) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeDirAt(aPath, aIndex));
        }

        @Override
        default public Properties removeDirAt(Object[] aPathElements, int aIndex) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeDirAt(aPathElements, aIndex));
        }

        @Override
        default public Properties removeDirAt(String aPath, int aIndex) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeDirAt(aPath, aIndex));
        }

        @Override
        default public Properties removeDirAt(String[] aPathElements, int aIndex) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeDirAt(aPathElements, aIndex));
        }

        @Override
        default public Properties removeFrom(Object ... aPathElements) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeFrom(aPathElements));
        }

        @Override
        default public Properties removeFrom(Object aPath) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeFrom(aPath));
        }

        @Override
        default public Properties removeFrom(String aPath) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeFrom(aPath));
        }

        @Override
        default public Properties removeFrom(String ... aPathElements) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removeFrom(aPathElements));
        }

        @Override
        default public Properties removePaths(Collection<?> aPaths) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removePaths((Collection)aPaths));
        }

        @Override
        default public Properties removePaths(String ... aPaths) {
            return new MapProperties((Map<?, ?>)ImmutableCanonicalTable.MutableCanonicalTable.super.removePaths(aPaths));
        }
    }
}

