/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer;

import org.refcodes.matcher.MatcherSchema;
import org.refcodes.observer.AbstractEventMatcher;
import org.refcodes.observer.EventMetaData;
import org.refcodes.observer.MetaDataEvent;

public class UniversalIdEqualWithEventMatcher<E extends MetaDataEvent<?, ?>>
extends AbstractEventMatcher<E> {
    public static final String ALIAS = "UNIVERSAL_ID_EQUAL_WITH";
    private final String _universalId;

    public UniversalIdEqualWithEventMatcher(String aUid) {
        super(ALIAS, "Matches the given universal ID <" + aUid + "> with the universal ID stored in an event's meta data (UNIVERSAL ID EQUAL WITH).");
        this._universalId = aUid;
    }

    @Override
    public boolean isMatching(E aEvent) {
        if (this._universalId != null) {
            return this._universalId.equals(((EventMetaData)aEvent.getMetaData()).getUniversalId());
        }
        return ((EventMetaData)aEvent.getMetaData()).getUniversalId() == null;
    }

    @Override
    public MatcherSchema toSchema() {
        MatcherSchema theSchema = super.toSchema();
        theSchema.put("VALUE", this._universalId);
        return theSchema;
    }
}

