/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.data.CharSet;
import org.refcodes.mixin.CharSetAccessor;
import org.refcodes.numerical.NumberBaseAccessor;
import org.refcodes.numerical.NumericalUtility;

public class BaseConverterBuilder
implements CharSetAccessor.CharSetProperty,
CharSetAccessor.CharSetBuilder<BaseConverterBuilder>,
NumberBaseAccessor.NumberBaseProperty,
NumberBaseAccessor.NumberBaseBuilder<BaseConverterBuilder> {
    private static final int DECIMAL_NUMBER_BASE = 10;
    private int _numberBase = 10;
    private String _digits = null;
    private long _number;
    private char[] _charSet = null;

    public BaseConverterBuilder() {
        this.setCharSet(CharSet.ARABIC_BASE64.getCharSet());
    }

    @Override
    public char[] getCharSet() {
        return this._charSet;
    }

    @Override
    public void setCharSet(char[] aCharSet) {
        this._charSet = aCharSet;
    }

    @Override
    public BaseConverterBuilder withCharSet(char[] aCharSet) {
        this.setCharSet(aCharSet);
        return this;
    }

    @Override
    public void setNumberBase(int aNumberBase) {
        this._numberBase = aNumberBase;
    }

    @Override
    public int getNumberBase() {
        return this._numberBase;
    }

    public String toDigits(long aNumber) {
        return BaseConverterBuilder.asEncoded(aNumber, this._numberBase, this._charSet);
    }

    public long getNumber() {
        return this._number;
    }

    public long toNumber(String aDigits) {
        return BaseConverterBuilder.asDecoded(aDigits, this._numberBase, this._charSet);
    }

    public void setNumber(long aNumber) {
        this._number = aNumber;
    }

    public String getDigits() {
        this._digits = BaseConverterBuilder.asEncoded(this._number, this._numberBase, this._charSet);
        return this._digits;
    }

    public void setDigits(String aDigits) {
        this._digits = aDigits;
        this._number = BaseConverterBuilder.asDecoded(aDigits, this._numberBase, this._charSet);
    }

    @Override
    public BaseConverterBuilder withNumberBase(int aNumberBase) {
        this.setNumberBase(aNumberBase);
        return this;
    }

    public BaseConverterBuilder withDigits(String aDigits) {
        this.setDigits(aDigits);
        return this;
    }

    public BaseConverterBuilder withNumber(long aNumber) {
        this.setNumber(aNumber);
        return this;
    }

    public static String asEncoded(long aNumber, int aNumberBase, char ... aCharSet) {
        return NumericalUtility.toNumberBase(aNumber, aNumberBase, aCharSet);
    }

    public static long asDecoded(String aDigits, int aNumberBase, char ... aCharSet) {
        return NumericalUtility.fromNumberBase(aNumberBase, aCharSet, aDigits);
    }
}

