/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.matcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.refcodes.matcher.AbstractMatcher;
import org.refcodes.mixin.WildcardSubstitutes;

public abstract class AbstractWildcardMatcher<M>
extends AbstractMatcher<M> {
    public static final String ALIAS = "WILDCARD";
    protected static final String REGEX_PATTERN = "REGEX_PATTERN";
    protected static final String WILDCARD_NAMES = "WILDCARD_NAMES";

    public AbstractWildcardMatcher(String aDescription) {
        super(ALIAS, aDescription);
    }

    protected static class WildcardMatcherSubstitutes
    implements WildcardSubstitutes {
        private final String[] _wildcardSubstitutes;
        private final Map<String, String> _namedWildcardSubstittutes;

        public WildcardMatcherSubstitutes(String[] aWildcardSubstitutes, Map<String, String> aNamedWildcardSubstittutes) {
            this._wildcardSubstitutes = aWildcardSubstitutes;
            this._namedWildcardSubstittutes = aNamedWildcardSubstittutes;
        }

        @Override
        public String[] getWildcardReplacements() {
            return this._wildcardSubstitutes;
        }

        @Override
        public String getWildcardReplacementAt(int aIndex) {
            if (this._wildcardSubstitutes != null && this._wildcardSubstitutes.length > aIndex) {
                return this._wildcardSubstitutes[aIndex];
            }
            return null;
        }

        @Override
        public String getWildcardReplacement(String aWildcardName) {
            if (this._namedWildcardSubstittutes != null) {
                return this._namedWildcardSubstittutes.get(aWildcardName);
            }
            return null;
        }

        @Override
        public String[] getWildcardReplacements(String ... aWildcardNames) {
            ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
            for (String eName : aWildcardNames) {
                String eSubstitute = this.getWildcardReplacement(eName);
                if (eSubstitute == null) {
                    throw new IllegalArgumentException("There is none such named wildcard substitute for name <" + eName + ">, check your pattern!.");
                }
                theWildcardSubstitutes.add(eSubstitute);
            }
            return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
        }

        @Override
        public String[] getWildcardReplacementsAt(int ... aIndexes) {
            ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
            for (int i : aIndexes) {
                if (i >= this._wildcardSubstitutes.length) {
                    throw new IllegalArgumentException("Your provided index <" + i + "> exceeds the number of wildcards <" + this._wildcardSubstitutes.length + "> defined in your pattern.");
                }
                theWildcardSubstitutes.add(this._wildcardSubstitutes[i]);
            }
            return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
        }

        @Override
        public String[] getWildcardNames() {
            if (this._namedWildcardSubstittutes != null && this._namedWildcardSubstittutes.size() != 0) {
                return this._namedWildcardSubstittutes.keySet().toArray(new String[this._namedWildcardSubstittutes.size()]);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [wildcardSubstitutes=" + Arrays.toString(this._wildcardSubstitutes) + ", namedWildcardSubstittutes=" + String.valueOf(this._namedWildcardSubstittutes) + "]";
        }
    }
}

