/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class YamlMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_YAML, MediaType.TEXT_YAML};
    private final ObjectMapper _mapper = new ObjectMapper(new YAMLFactory());

    public YamlMediaTypeFactory() {
        this._mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public String toMarshaled(Object aObject) throws MarshalException {
        try {
            String theYaml = this._mapper.writeValueAsString(aObject);
            return theYaml;
        }
        catch (Exception e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + aObject.getClass().getName() + ">.", e);
        }
    }

    @Override
    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType) throws UnmarshalException {
        try {
            if (aHttpBody == null) {
                return null;
            }
            if (aHttpBody.isEmpty()) {
                return aType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            T theFromYaml = this._mapper.readValue(aHttpBody, aType);
            return theFromYaml;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + ">! ", e);
        }
    }
}

