/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.refcodes.data.MarshalParameter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.ext.factory.XmlCanonicalMapFactorySingleton;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class XmlMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_XML, MediaType.TEXT_XML, MediaType.APPLICATION_HAL_XML, MediaType.APPLICATION_SCHEMA_XML};

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public <SRC> String toMarshaled(SRC aContext) throws MarshalException {
        return this.toMarshaled((Object)aContext, (Map)null);
    }

    @Override
    public <SRC> String toMarshaled(SRC aObject, Map<String, String> aProperties) throws MarshalException {
        CanonicalMapBuilderImpl theCanoniocalMap = new CanonicalMapBuilderImpl(aObject);
        if (aObject.getClass().isArray()) {
            theCanoniocalMap = new CanonicalMapBuilderImpl(theCanoniocalMap.retrieveTo("array", "value"));
            theCanoniocalMap.put(new String[]{"array", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (Collection.class.isAssignableFrom(aObject.getClass())) {
            theCanoniocalMap = new CanonicalMapBuilderImpl(theCanoniocalMap.retrieveTo("collection", "value"));
            theCanoniocalMap.put(new String[]{"collection", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (theCanoniocalMap.children().size() > 1 || SimpleType.isSimpleType(aObject.getClass())) {
            String theRootElement;
            String string = theRootElement = aProperties != null ? aProperties.get(MarshalParameter.ROOT_ELEMENT.getName()) : null;
            if (theRootElement == null || theRootElement.isEmpty()) {
                theRootElement = "value";
            }
            theCanoniocalMap = new CanonicalMapBuilderImpl(theCanoniocalMap.retrieveTo(theRootElement));
        }
        return XmlCanonicalMapFactorySingleton.getInstance().toMarshaled(theCanoniocalMap, aProperties);
    }

    @Override
    public <T> T toUnmarshaled(String aContext, Class<T> aType) throws UnmarshalException {
        return this.toUnmarshaled(aContext, aType, (Map<String, String>)null);
    }

    @Override
    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType, Map<String, String> aProperties) throws UnmarshalException {
        CanonicalMap theCanoniocalMap = XmlCanonicalMapFactorySingleton.getInstance().toUnmarshaled(aHttpBody, aProperties);
        if (aType.isArray() && theCanoniocalMap.isDir("array") && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir("array", "value") && theCanoniocalMap.dirs("array").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("array", "value");
        } else if (Collection.class.isAssignableFrom(aType) && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir("collection", "value") && theCanoniocalMap.dirs("collection").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("collection", "value");
        } else {
            if (aType.isAssignableFrom(HttpBodyMap.class)) {
                return (T)new HttpBodyMap((Object)theCanoniocalMap);
            }
            if (theCanoniocalMap.hasValue("value") && theCanoniocalMap.leaves().size() == 1 && theCanoniocalMap.dirs().size() == 0 || theCanoniocalMap.isDir("value") && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.dirs().size() == 1) {
                theCanoniocalMap = theCanoniocalMap.retrieveFrom("value");
            }
        }
        return theCanoniocalMap.toType(aType);
    }

    @Override
    public <T> T fromMarshaled(InputStream aContentInputStream, Class<T> aType) throws UnmarshalException {
        return this.fromMarshaled(aContentInputStream, aType, (Map<String, String>)null);
    }

    @Override
    public Object fromMarshaled(InputStream aContentInputStream, Map<String, String> aProperties, Class<?> ... aTypes) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder theBuilder = XmlCanonicalMapFactorySingleton.getInstance().fromMarshaled(aContentInputStream, aProperties);
        for (Class<?> eType : aTypes) {
            try {
                return theBuilder.toType(eType);
            }
            catch (Exception exception) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the input stream to fit into one of the provided types.");
    }
}

