/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Encoding;
import org.refcodes.mixin.DomainAccessor;
import org.refcodes.mixin.PathAccessor;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.time.DateFormat;
import org.refcodes.time.DateFormats;
import org.refcodes.time.TimeUnit;
import org.refcodes.web.Cookie;
import org.refcodes.web.CookieAttribute;

public class ResponseCookie
extends PropertyImpl.PropertyBuilderImpl
implements Cookie,
PathAccessor.PathProperty,
PathAccessor.PathBuilder<ResponseCookie>,
DomainAccessor.DomainProperty,
DomainAccessor.DomainBuilder<ResponseCookie> {
    private Date _expiresDate = null;
    private int _maxAge = -1;
    private String _domain = null;
    private String _path = null;
    private boolean _isSecure = false;
    private boolean _isHttpOnly = false;
    private String _version = null;

    public ResponseCookie() {
    }

    public ResponseCookie(String aCookieName, String aValue) {
        super(aCookieName, aValue);
    }

    public ResponseCookie(String aHttpCookie) {
        this.fromHttpCookie(aHttpCookie);
    }

    public ResponseCookie(Cookie aCookie) {
        super((String)aCookie.getKey(), (String)aCookie.getValue());
        if (aCookie instanceof ResponseCookie) {
            ResponseCookie theResponseCookie = (ResponseCookie)aCookie;
            this.setDomain(theResponseCookie.getDomain());
            this.setPath(theResponseCookie.getPath());
            this.setExpiresDate(theResponseCookie.getExpiresDate());
            this.setHttpOnly(theResponseCookie.isHttpOnly());
            this.setSecure(theResponseCookie.isSecure());
            this.setMaxAge(theResponseCookie.getMaxAge());
            this.setVersion(theResponseCookie.getVersion());
        }
    }

    public ResponseCookie(String aCookieName, String aValue, Date aExpiresDate, String aDomain, String aPath, boolean isSecure, boolean isHttpOnly, String aVersion) {
        super(aCookieName, aValue);
        this._expiresDate = aExpiresDate;
        this._domain = aDomain;
        this._path = aPath;
        this._isSecure = isSecure;
        this._isHttpOnly = isHttpOnly;
        this._version = aVersion;
    }

    public ResponseCookie(String aCookieName, String aValue, int aMaxAge, String aDomain, String aPath, boolean isSecure, boolean isHttpOnly, String aVersion) {
        super(aCookieName, aValue);
        this._maxAge = aMaxAge;
        this._domain = aDomain;
        this._path = aPath;
        this._isSecure = isSecure;
        this._isHttpOnly = isHttpOnly;
        this._version = aVersion;
    }

    public int getMaxAge() {
        return this._maxAge;
    }

    public void setMaxAge(int aMaxAge) {
        this._maxAge = aMaxAge;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String aVersion) {
        this._version = aVersion;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public void setPath(String aPath) {
        this._path = aPath;
    }

    public Date getExpiresDate() {
        return this._expiresDate;
    }

    public void setExpiresDate(Date aExpireDate) {
        this._expiresDate = aExpireDate;
    }

    @Override
    public String getDomain() {
        return this._domain;
    }

    @Override
    public void setDomain(String aDomain) {
        this._domain = aDomain;
    }

    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public boolean isHttpOnly() {
        return this._isHttpOnly;
    }

    public void setHttpOnly(boolean isHttpOnly) {
        this._isHttpOnly = isHttpOnly;
    }

    public void setExpiresAfter(TimeUnit aTimeUnit, long aTime) {
        long theMilliseconds = TimeUnit.toMilliseconds(aTimeUnit, aTime);
        Date theExpiresDate = new Date();
        theExpiresDate = new Date(theExpiresDate.getTime() + theMilliseconds);
        this.setExpiresDate(theExpiresDate);
    }

    public ResponseCookie withExpiresDate(Date aExpiresDate) {
        this.setExpiresDate(aExpiresDate);
        return this;
    }

    @Override
    public ResponseCookie withPath(String aPath) {
        this.setPath(aPath);
        return this;
    }

    @Override
    public ResponseCookie withDomain(String aDomain) {
        this.setDomain(aDomain);
        return this;
    }

    public ResponseCookie withHttpOnly(boolean isHttpOnly) {
        this.setHttpOnly(isHttpOnly);
        return this;
    }

    public ResponseCookie withExpiresAfter(TimeUnit aTimeUnit, long aTime) {
        this.setExpiresAfter(aTimeUnit, aTime);
        return this;
    }

    public ResponseCookie withVersion(String aVersion) {
        this.setVersion(aVersion);
        return this;
    }

    public ResponseCookie withMaxAge(int aMaxAge) {
        this.setMaxAge(aMaxAge);
        return this;
    }

    public ResponseCookie withSecure(boolean isSecure) {
        this.setSecure(isSecure);
        return this;
    }

    @Override
    public ResponseCookie withHttpCookie(String aCookie) {
        this.fromHttpCookie(aCookie);
        return this;
    }

    @Override
    public void fromHttpCookie(String aHttpCookie) {
        StringTokenizer theTokenizer = new StringTokenizer(aHttpCookie, "" + Delimiter.COOKIE_PROPERTIES.getChar());
        String eTupel = theTokenizer.nextToken();
        PropertyImpl eProperty = new PropertyImpl(eTupel);
        this.setKey((String)eProperty.getKey());
        try {
            this.setValue(URLDecoder.decode((String)eProperty.getValue(), Encoding.UTF_8.getCode()));
        }
        catch (UnsupportedEncodingException ignore) {
            this.setValue((String)eProperty.getValue());
        }
        block15: while (theTokenizer.hasMoreTokens()) {
            CookieAttribute eCookieKey;
            eTupel = theTokenizer.nextToken();
            if (eTupel.equalsIgnoreCase(CookieAttribute.SECURE.getKey())) {
                eCookieKey = CookieAttribute.SECURE;
            } else if (eTupel.equalsIgnoreCase(CookieAttribute.HTTPONLY.getKey())) {
                eCookieKey = CookieAttribute.HTTPONLY;
            } else {
                eProperty = new PropertyImpl(eTupel);
                eCookieKey = CookieAttribute.fromKey((String)eProperty.getKey());
            }
            if (eCookieKey == null) continue;
            switch (eCookieKey) {
                case DOMAIN: {
                    this.setDomain((String)eProperty.getValue());
                    continue block15;
                }
                case EXPIRES: {
                    try {
                        this.setExpiresDate(DateFormats.COOKIE_DATE_FORMATS.toDate((String)eProperty.getValue()));
                        continue block15;
                    }
                    catch (DateTimeException e) {
                        throw new IllegalArgumentException("Encountered unparsable date <" + (String)eProperty.getValue() + "> for key <" + eCookieKey.getKey() + ">.", e);
                    }
                }
                case HTTPONLY: {
                    this.setHttpOnly(true);
                    continue block15;
                }
                case PATH: {
                    this.setPath((String)eProperty.getValue());
                    continue block15;
                }
                case SECURE: {
                    this.setSecure(true);
                    continue block15;
                }
                case VERSION: {
                    this.setVersion((String)eProperty.getValue());
                    continue block15;
                }
                case MAX_AGE: {
                    int theMaxAgeInSeconds = -1;
                    try {
                        theMaxAgeInSeconds = Integer.parseInt((String)eProperty.getValue());
                        this.setMaxAge(theMaxAgeInSeconds);
                        continue block15;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Encountered unparsable max-age <" + (String)eProperty.getValue() + "> for key <" + eCookieKey.getKey() + ">.", e);
                    }
                }
            }
        }
    }

    @Override
    public String toHttpCookie() {
        String theValue = null;
        try {
            theValue = URLEncoder.encode((String)this.getValue(), Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException ignore) {
            theValue = (String)this.getValue();
        }
        String theHttpCookie = (String)this.getKey() + Delimiter.COOKIE_TUPEL.getChar() + theValue;
        if (this.getExpiresDate() != null) {
            theHttpCookie = theHttpCookie + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.EXPIRES.getKey() + Delimiter.COOKIE_TUPEL.getChar() + DateFormat.NETSCAPE_COOKIE_DATE_FORMAT.getFormatter().withLocale(Locale.ENGLISH).format(Instant.ofEpochMilli(this.getExpiresDate().getTime()));
        }
        if (this.getMaxAge() != -1) {
            theHttpCookie = theHttpCookie + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.MAX_AGE.getKey() + Delimiter.COOKIE_TUPEL.getChar() + this.getMaxAge();
        }
        if (this.getDomain() != null) {
            theHttpCookie = theHttpCookie + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.DOMAIN.getKey() + Delimiter.COOKIE_TUPEL.getChar() + this.getDomain();
        }
        if (this.getPath() != null) {
            theHttpCookie = theHttpCookie + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.PATH.getKey() + Delimiter.COOKIE_TUPEL.getChar() + this.getPath();
        }
        if (this.isSecure()) {
            theHttpCookie = theHttpCookie + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.SECURE.getKey();
        }
        if (this.isHttpOnly()) {
            theHttpCookie = theHttpCookie + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.HTTPONLY.getKey();
        }
        if (this.getVersion() != null) {
            theHttpCookie = theHttpCookie + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.VERSION.getKey() + Delimiter.COOKIE_TUPEL.getChar() + this.getVersion();
        }
        return theHttpCookie;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@[key=" + (String)this._key + ", value=" + (String)this._value + ", expiresDate=" + this._expiresDate + ", maxAge=" + this._maxAge + ", domain=" + this._domain + ", path=" + this._path + ", isSecure=" + this._isSecure + ", isHttpOnly=" + this._isHttpOnly + ", version=" + this._version + "]";
    }
}

