/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.mixin.Disposable;
import org.refcodes.mixin.ValidAccessor;
import org.refcodes.web.GrantType;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.OauthField;

public class OauthToken
implements ValidAccessor,
Disposable {
    private static final String PREFIX_TOKEN_PATH = "token";
    private long _creationTimeMillis;
    protected String _accessToken;
    protected String _refreshToken;
    protected String _tokenType;
    protected Integer _expiresIn;
    protected Integer _refreshExpiresIn;
    protected String _scope;
    protected String _notBeforePolicy;
    protected String _sessionState;
    protected GrantType _grantType;
    protected String _customGrant;
    protected boolean _isDisposed;

    public OauthToken(OauthToken aOauthToken) {
        this(aOauthToken.getAccessToken(), aOauthToken.getRefreshToken(), aOauthToken.getTokenType(), aOauthToken.getGrantType(), aOauthToken._customGrant, aOauthToken.getNotBeforePolicy(), aOauthToken.getExpiresIn(), aOauthToken.getRefreshExpiresIn(), aOauthToken.getScope(), aOauthToken.getSessionState());
    }

    public OauthToken(String aAccessToken, String aRefreshToken, String aTokenType, Integer aExpiresIn, String aScope) {
        this(aAccessToken, aRefreshToken, aTokenType, null, null, null, aExpiresIn, null, aScope, null);
    }

    public OauthToken(String aAccessToken, String aRefreshToken, String aTokenType, String aNotBeforePolicy, Integer aExpiresIn, Integer aRefreshExpiresIn, String aScope, String aSessionState) {
        this(aAccessToken, aRefreshToken, aTokenType, null, null, aNotBeforePolicy, aExpiresIn, aRefreshExpiresIn, aScope, aSessionState);
    }

    public OauthToken(String aAccessToken, String aRefreshToken, String aTokenType, GrantType aGrantType, String aNotBeforePolicy, Integer aExpiresIn, Integer aRefreshExpiresIn, String aScope, String aSessionState) {
        this(aAccessToken, aRefreshToken, aTokenType, aGrantType, null, aNotBeforePolicy, aExpiresIn, aRefreshExpiresIn, aScope, aSessionState);
    }

    public OauthToken(String aAccessToken, String aRefreshToken, String aTokenType, String aGrantType, String aNotBeforePolicy, Integer aExpiresIn, Integer aRefreshExpiresIn, String aScope, String aSessionState) {
        this(aAccessToken, aRefreshToken, aTokenType, null, aGrantType, aNotBeforePolicy, aExpiresIn, aRefreshExpiresIn, aScope, aSessionState);
    }

    public OauthToken(String aAccessToken, String aRefreshToken, String aTokenType, GrantType aGrantType, String aCustomGrant, String aNotBeforePolicy, Integer aExpiresIn, Integer aRefreshExpiresIn, String aScope, String aSessionState) {
        this._creationTimeMillis = System.currentTimeMillis();
        this._accessToken = aAccessToken;
        this._refreshToken = aRefreshToken;
        this._tokenType = aTokenType;
        this._notBeforePolicy = aNotBeforePolicy;
        this._expiresIn = aExpiresIn;
        this._refreshExpiresIn = aRefreshExpiresIn;
        this._scope = aScope;
        this._sessionState = aSessionState;
        this._grantType = aGrantType;
        if (this._grantType == null) {
            this._grantType = GrantType.fromName(aCustomGrant);
            if (this._grantType == null) {
                this._customGrant = aCustomGrant;
            }
        }
    }

    public OauthToken(HttpBodyMap aOauthToken) {
        this.updateToken(aOauthToken);
    }

    @Override
    public void dispose() {
        this._isDisposed = true;
        this._accessToken = null;
        this._expiresIn = null;
        this._refreshToken = null;
        this._scope = null;
        this._tokenType = null;
        this._sessionState = null;
        this._refreshExpiresIn = null;
        this._notBeforePolicy = null;
    }

    public String getAccessToken() {
        return this._accessToken;
    }

    public String getRefreshToken() {
        return this._refreshToken;
    }

    public String getScope() {
        return this._scope;
    }

    public String getTokenType() {
        return this._tokenType;
    }

    public GrantType getGrantType() {
        return this._grantType;
    }

    public Integer getExpiresIn() {
        return this._expiresIn;
    }

    public String getNotBeforePolicy() {
        return this._notBeforePolicy;
    }

    public String getSessionState() {
        return this._sessionState;
    }

    public Integer getRefreshExpiresIn() {
        return this._refreshExpiresIn;
    }

    @Override
    public boolean isValid() {
        if (this._isDisposed) {
            return false;
        }
        if (this._expiresIn == null) {
            return true;
        }
        return this._creationTimeMillis + (long)(this._expiresIn * 1000) > System.currentTimeMillis();
    }

    protected void updateToken(HttpBodyMap aOauthToken) {
        this._creationTimeMillis = System.currentTimeMillis();
        if (aOauthToken.containsKey((Object)OauthField.ACCESS_TOKEN.getPath())) {
            this._accessToken = (String)aOauthToken.get((Object)OauthField.ACCESS_TOKEN.getPath());
        }
        if (aOauthToken.containsKey((Object)OauthField.REFRESH_TOKEN.getPath())) {
            this._refreshToken = (String)aOauthToken.get((Object)OauthField.REFRESH_TOKEN.getPath());
        }
        if (aOauthToken.containsKey((Object)OauthField.TOKEN_TYPE.getPath())) {
            this._tokenType = (String)aOauthToken.get((Object)OauthField.TOKEN_TYPE.getPath());
        }
        if (aOauthToken.containsKey((Object)OauthField.NOT_BEFORE_POLICY.getPath())) {
            this._notBeforePolicy = (String)aOauthToken.get((Object)OauthField.NOT_BEFORE_POLICY.getPath());
        }
        if (aOauthToken.containsKey((Object)OauthField.EXPIRES_IN.getPath())) {
            this._expiresIn = aOauthToken.getInt(OauthField.EXPIRES_IN.getPath());
        }
        if (aOauthToken.containsKey((Object)OauthField.REFRESH_EXPIRES_IN.getPath())) {
            this._refreshExpiresIn = aOauthToken.getInt(OauthField.REFRESH_EXPIRES_IN.getPath());
        }
        if (aOauthToken.containsKey((Object)OauthField.SCOPE.getPath())) {
            this._scope = (String)aOauthToken.get((Object)OauthField.SCOPE.getPath());
        }
        if (aOauthToken.containsKey((Object)OauthField.SESSION_STATE.getPath())) {
            this._sessionState = (String)aOauthToken.get((Object)OauthField.SESSION_STATE.getPath());
        }
        if (aOauthToken.containsKey((Object)OauthField.GRANT_TYPE.getPath())) {
            this._grantType = GrantType.fromName((String)aOauthToken.get((Object)OauthField.GRANT_TYPE.getPath()));
        }
        if (aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.ACCESS_TOKEN.getPath()) && (this._accessToken == null || this._accessToken.isEmpty())) {
            this._accessToken = (String)aOauthToken.get(PREFIX_TOKEN_PATH, OauthField.ACCESS_TOKEN.getPath());
        }
        if (aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.REFRESH_TOKEN.getPath()) && (this._refreshToken == null || this._refreshToken.isEmpty())) {
            this._refreshToken = (String)aOauthToken.get(PREFIX_TOKEN_PATH, OauthField.REFRESH_TOKEN.getPath());
        }
        if (aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.TOKEN_TYPE.getPath()) && (this._tokenType == null || this._tokenType.isEmpty())) {
            this._tokenType = (String)aOauthToken.get(PREFIX_TOKEN_PATH, OauthField.TOKEN_TYPE.getPath());
        }
        if (aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.NOT_BEFORE_POLICY.getPath()) && (this._notBeforePolicy == null || this._notBeforePolicy.isEmpty())) {
            this._notBeforePolicy = (String)aOauthToken.get(PREFIX_TOKEN_PATH, OauthField.NOT_BEFORE_POLICY.getPath());
        }
        if (aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.EXPIRES_IN.getPath()) && this._expiresIn == null) {
            this._expiresIn = aOauthToken.getInt(PREFIX_TOKEN_PATH, OauthField.EXPIRES_IN.getPath());
        }
        if (aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.REFRESH_EXPIRES_IN.getPath()) && this._refreshExpiresIn == null) {
            this._refreshExpiresIn = aOauthToken.getInt(PREFIX_TOKEN_PATH, OauthField.REFRESH_EXPIRES_IN.getPath());
        }
        if (aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.SCOPE.getPath()) && (this._scope == null || this._scope.isEmpty())) {
            this._scope = (String)aOauthToken.get(PREFIX_TOKEN_PATH, OauthField.SCOPE.getPath());
        }
        if (aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.SESSION_STATE.getPath()) && (this._sessionState == null || this._sessionState.isEmpty())) {
            this._sessionState = (String)aOauthToken.get(PREFIX_TOKEN_PATH, OauthField.SESSION_STATE.getPath());
        }
        if (aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.GRANT_TYPE.getPath()) && this._grantType == null) {
            this._grantType = GrantType.fromName((String)aOauthToken.get(PREFIX_TOKEN_PATH, OauthField.GRANT_TYPE.getPath()));
        }
        if (this._grantType == null) {
            if (aOauthToken.containsKey((Object)OauthField.GRANT_TYPE.getPath())) {
                this._customGrant = (String)aOauthToken.get((Object)OauthField.GRANT_TYPE.getPath());
            }
            if (this._customGrant == null && aOauthToken.containsKey(PREFIX_TOKEN_PATH, OauthField.GRANT_TYPE.getPath())) {
                this._customGrant = (String)aOauthToken.get(PREFIX_TOKEN_PATH, OauthField.GRANT_TYPE.getPath());
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [creationTimeMillis=" + this._creationTimeMillis + ", tokenType=" + this._tokenType + ", expiresIn=" + this._expiresIn + ", refreshExpiresIn=" + this._refreshExpiresIn + ", scope=" + this._scope + ", notBeforePolicy=" + this._notBeforePolicy + ", sessionState=" + this._sessionState + ", grantType=" + (this._grantType != null ? this._grantType.getValue() : this._customGrant) + "]";
    }
}

