/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class JsonMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_HAL_JSON, MediaType.APPLICATION_SCHEMA_JSON};
    private final ObjectMapper _mapper = new ObjectMapper();

    public JsonMediaTypeFactory() {
        this._mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public String toMarshaled(Object aObject) throws MarshalException {
        try {
            String theJson = this._mapper.writeValueAsString(aObject);
            return theJson;
        }
        catch (Exception e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + aObject.getClass().getName() + ">.", e);
        }
    }

    @Override
    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType) throws UnmarshalException {
        try {
            if (aHttpBody == null) {
                return null;
            }
            if (aHttpBody.isEmpty()) {
                return aType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            T theFromJson = this._mapper.readValue(aHttpBody, aType);
            return theFromJson;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + ">!", e);
        }
    }

    protected String toPlainJson(String aJson) {
        return aJson.replaceFirst("^\"[A-Za-z][A-Za-z0-9]+\"\\s*:", "");
    }

    protected String toUnboxed(String aJson) {
        if (aJson.startsWith("{") && aJson.endsWith("}")) {
            aJson = aJson.substring(1, aJson.length() - 1);
            aJson = this.toPlainJson(aJson);
        }
        return aJson;
    }

    protected String toElementName(Class<?> aClass) {
        Object theElementName = aClass.getSimpleName();
        if (aClass.isArray()) {
            theElementName = ((String)theElementName).substring(0, ((String)theElementName).length() - 2) + "Array";
        }
        String theFirstLetter = ("" + ((String)theElementName).charAt(0)).toLowerCase();
        theElementName = theFirstLetter + ((String)theElementName).substring(1);
        return theElementName;
    }

    protected String toVariableDeclaration(Class<?> aClass) {
        return "\"" + this.toElementName(aClass) + "\": ";
    }
}

