/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.mixin.StatusCodeAccessor;

public enum HttpSuccessCode implements StatusCodeAccessor<Integer>
{
    OK(200),
    CREATED(201),
    ACCEPTED(202),
    NON_AUTHORITATIVE_INFORMATION(203),
    NO_CONTENT(204),
    RESET_CONTENT(205),
    PARTIAL_CONTENT(206),
    MULTI_STATUS(207);

    private Integer _statusCode;

    private HttpSuccessCode(Integer aStatusCode) {
        this._statusCode = aStatusCode;
    }

    @Override
    public Integer getStatusCode() {
        return this._statusCode;
    }

    public static HttpSuccessCode toHttpSuccessCode(int aHttpStatusCode) {
        for (HttpSuccessCode eCode : HttpSuccessCode.values()) {
            if (!eCode.getStatusCode().equals(aHttpStatusCode)) continue;
            return eCode;
        }
        return null;
    }

    public static HttpSuccessCode toHttpSuccessCode(StatusCodeAccessor<Integer> aHttpStatusCode) {
        for (HttpSuccessCode eCode : HttpSuccessCode.values()) {
            if (!eCode.getStatusCode().equals(aHttpStatusCode.getStatusCode())) continue;
            return eCode;
        }
        return null;
    }
}

