/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.HashMap;
import org.refcodes.exception.MarshalException;
import org.refcodes.mixin.Dumpable;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.AbstractHttpResponse;
import org.refcodes.web.BadResponseException;
import org.refcodes.web.ContentType;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyAccessor;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpStatusCode;
import org.refcodes.web.HttpStatusCodeAccessor;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.ResponseHeaderFields;

public class HttpServerResponse
extends AbstractHttpResponse
implements HttpStatusCodeAccessor.HttpStatusCodeProperty,
HttpStatusCodeAccessor.HttpStatusCodeBuilder<HttpServerResponse>,
HttpBodyAccessor.HttpBodyProvider<BadResponseException>,
Dumpable {
    protected MediaTypeFactoryLookup _mediaTypeFactoryLookup;
    private Object _response = null;

    public HttpServerResponse(MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this._mediaTypeFactoryLookup = aMediaTypeFactoryLookup;
    }

    public HttpServerResponse(HttpStatusCode aHttpStatusCode, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpStatusCode);
        this._mediaTypeFactoryLookup = aMediaTypeFactoryLookup;
    }

    public HttpServerResponse(ResponseHeaderFields aResponseHeaderFields, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aResponseHeaderFields);
        this._mediaTypeFactoryLookup = aMediaTypeFactoryLookup;
    }

    @Override
    public HttpServerResponse withHttpStatusCode(HttpStatusCode aStatusCode) {
        this.setHttpStatusCode(aStatusCode);
        return this;
    }

    public <RES> HttpServerResponse withResponse(RES aResponse) {
        this.setResponse(aResponse);
        return this;
    }

    public <RES> RES getResponse() {
        return (RES)this._response;
    }

    public <RES> void setResponse(RES aResponse) {
        this._response = aResponse;
    }

    @Override
    public void setHttpStatusCode(HttpStatusCode aStatusCode) {
        this._httpStatusCode = aStatusCode;
    }

    @Override
    public String toHttpBody() throws BadResponseException {
        if (this._response != null) {
            MediaTypeFactory theFactory = null;
            ContentType theContentType = this.getHeaderFields().getContentType();
            String theCharset = null;
            if (theContentType == null) {
                throw new BadResponseException("No (known) Media-Type provided in response's Header-Field <" + HeaderField.CONTENT_TYPE.getName() + ">: " + new VerboseTextBuilder().withElements(this.getHeaderFields().get(HeaderField.CONTENT_TYPE)));
            }
            theFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(theContentType.getMediaType());
            theCharset = theContentType.getCharsetParametrer();
            if (theFactory == null) {
                throw new BadResponseException("No Media-Type factory found (added) for Media-Type <" + theContentType + "> (raw requested Media-Type is <" + this.getHeaderFields().get(HeaderField.CONTENT_TYPE) + ">)");
            }
            HashMap<String, String> theProperties = null;
            if (theCharset != null) {
                theProperties = new HashMap<String, String>();
                theProperties.put(MediaTypeParameter.CHARSET.getName(), theCharset);
            }
            try {
                Object theResponse = this._response;
                if (this._response instanceof HttpBodyMap) {
                    theResponse = ((HttpBodyMap)this._response).toDataStructure();
                }
                return (String)theFactory.toMarshaled(theResponse, theProperties);
            }
            catch (MarshalException e) {
                throw new BadResponseException("Unable to marshal response <" + this.getResponse() + ">.", (Throwable)e);
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + " [_httpStatusCode=" + this._httpStatusCode + "]";
    }
}

