/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.data.Scheme;
import org.refcodes.io.MaxConnectionsAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.security.KeyStoreDescriptor;
import org.refcodes.security.KeyStoreDescriptorAccessor;
import org.refcodes.web.HttpServerContext;
import org.refcodes.web.SchemeAccessor;

public class HttpServerContextBuilder
implements HttpServerContext,
SchemeAccessor.SchemeProperty,
SchemeAccessor.SchemeBuilder<HttpServerContextBuilder>,
KeyStoreDescriptorAccessor.KeyStoreDescriptorProperty,
KeyStoreDescriptorAccessor.KeyStoreDescriptorBuilder<HttpServerContextBuilder>,
PortAccessor.PortProperty,
PortAccessor.PortBuilder<HttpServerContextBuilder>,
MaxConnectionsAccessor.MaxConnectionsProperty,
MaxConnectionsAccessor.MaxConnectionsBuilder<HttpServerContextBuilder> {
    public static final Scheme DEFAULT_SCHEME = Scheme.HTTP;
    public static final int DEFAULT_PORT = 8080;
    private KeyStoreDescriptor _keyStoreDescriptor = null;
    private int _maxConnections = -1;
    private int _port = 8080;
    private Scheme _scheme = DEFAULT_SCHEME;
    private String _protocol = null;

    public HttpServerContextBuilder() {
    }

    public HttpServerContextBuilder(int aPort) {
        this._port = aPort;
    }

    public HttpServerContextBuilder(Scheme aScheme, int aPort) {
        this.setScheme(aScheme);
        this._port = aPort;
    }

    public HttpServerContextBuilder(String aProtocol, int aPort) {
        this.setProtocol(aProtocol);
        this._port = aPort;
    }

    public HttpServerContextBuilder(Scheme aScheme, int aPort, KeyStoreDescriptor aKeyStoreDescriptor, int aMaxConnections) {
        this.setScheme(aScheme);
        this._port = aPort;
        this._keyStoreDescriptor = aKeyStoreDescriptor;
        this._maxConnections = aMaxConnections;
    }

    public HttpServerContextBuilder(String aProtocol, int aPort, KeyStoreDescriptor aKeyStoreDescriptor, int aMaxConnections) {
        this.setProtocol(aProtocol);
        this._port = aPort;
        this._keyStoreDescriptor = aKeyStoreDescriptor;
        this._maxConnections = aMaxConnections;
    }

    @Override
    public KeyStoreDescriptor getKeyStoreDescriptor() {
        return this._keyStoreDescriptor;
    }

    @Override
    public int getMaxConnections() {
        return this._maxConnections;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public Scheme getScheme() {
        return this._scheme;
    }

    @Override
    public void setKeyStoreDescriptor(KeyStoreDescriptor aKeyStoreDescriptor) {
        this._keyStoreDescriptor = aKeyStoreDescriptor;
    }

    @Override
    public void setMaxConnections(int aMaxConnections) {
        this._maxConnections = aMaxConnections;
    }

    @Override
    public void setPort(int aPort) {
        this._port = aPort;
    }

    @Override
    public void setScheme(Scheme aScheme) {
        this._scheme = aScheme;
        this._protocol = null;
    }

    @Override
    public String toProtocol() {
        return this._scheme != null ? this._scheme.toProtocol() : this._protocol;
    }

    @Override
    public void setProtocol(String aProtocol) {
        Scheme theScheme = Scheme.fromProtocol(aProtocol);
        if (theScheme != null) {
            this._scheme = theScheme;
            this._protocol = null;
        } else {
            this._protocol = aProtocol;
            this._scheme = null;
        }
    }

    @Override
    public HttpServerContextBuilder withKeyStoreDescriptor(KeyStoreDescriptor aKeyStoreDescriptor) {
        this.setKeyStoreDescriptor(aKeyStoreDescriptor);
        return this;
    }

    @Override
    public HttpServerContextBuilder withMaxConnections(int aMaxConnections) {
        this.setMaxConnections(aMaxConnections);
        return this;
    }

    @Override
    public HttpServerContextBuilder withPort(int aPort) {
        this.setPort(aPort);
        return this;
    }

    @Override
    public HttpServerContextBuilder withProtocol(String aProtocol) {
        this.setProtocol(aProtocol);
        return this;
    }

    @Override
    public HttpServerContextBuilder withScheme(Scheme aScheme) {
        this.setScheme(aScheme);
        return this;
    }
}

