/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.data.Encoding;
import org.refcodes.io.InputStreamStringBuilder;
import org.refcodes.web.AbstractHttpResponse;
import org.refcodes.web.BadResponseException;
import org.refcodes.web.ContentType;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyAccessor;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpInputStreamAccessor;
import org.refcodes.web.HttpStatusCode;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.ResponseHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlAccessor;

public class HttpClientResponse
extends AbstractHttpResponse
implements HttpBodyAccessor,
HttpInputStreamAccessor,
UrlAccessor {
    protected MediaTypeFactoryLookup _mediaTypeFactoryLookup;
    private Url _url = null;
    private String _httpBody = null;
    private InputStream _httpInputStream = null;

    public HttpClientResponse(Url aUrl, ResponseHeaderFields aHeaderFields, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aUrl, null, aHeaderFields, null, aMediaTypeFactoryLookup);
    }

    public HttpClientResponse(Url aUrl, HttpStatusCode aHttpStatusCode, ResponseHeaderFields aHeaderFields, InputStream aHttpInputStream, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpStatusCode, aHeaderFields != null ? aHeaderFields : new ResponseHeaderFields());
        this._mediaTypeFactoryLookup = aMediaTypeFactoryLookup;
        this._httpInputStream = aHttpInputStream;
        this._url = aUrl;
    }

    public HttpBodyMap getResponse() throws BadResponseException {
        return this.getResponse(HttpBodyMap.class);
    }

    public <RES> RES getResponse(Class<RES> aResponseType) throws BadResponseException {
        if (aResponseType.isAssignableFrom(InputStream.class)) {
            return (RES)this._httpInputStream;
        }
        if (aResponseType.isAssignableFrom(String.class)) {
            return (RES)this.getHttpBody();
        }
        MediaTypeFactory theFactory = null;
        HashMap<String, String> theProperties = new HashMap<String, String>();
        String theHttpBody = this.getHttpBody();
        if (theHttpBody != null) {
            ContentType theContentType = this.getHeaderFields().getContentType();
            if (theContentType == null) {
                MediaType[] theMediaTypes = this._mediaTypeFactoryLookup.getFactoryMediaTypes();
                if (theMediaTypes != null && theMediaTypes.length != 0) {
                    theFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(theMediaTypes[0]);
                }
            } else {
                theFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(theContentType.getMediaType());
                String theCharset = theContentType.getCharsetParametrer();
                if (theCharset != null) {
                    theProperties.put(MediaTypeParameter.CHARSET.getName(), theCharset);
                }
            }
            if (theFactory == null) {
                throw new BadResponseException("No Media-Type factory found (added) for Media-Type <" + theContentType + "> (raw requested Media-Type is <" + this.getHeaderFields().get(HeaderField.CONTENT_TYPE) + ">)");
            }
            try {
                theProperties.put(MediaTypeParameter.BASE_URL.getName(), this._url.toHttpUrl());
                if (HttpBodyMap.class.isAssignableFrom(aResponseType)) {
                    Map theUnmarshaled = theFactory.toUnmarshaled(theHttpBody, HashMap.class, theProperties);
                    return (RES)new HttpBodyMap(theUnmarshaled);
                }
                return theFactory.toUnmarshaled(theHttpBody, aResponseType, theProperties);
            }
            catch (Exception e) {
                throw new BadResponseException("Unable to parse response body {" + this.getHttpBody() + "}.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public InputStream getHttpInputStream() {
        return this._httpInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHttpBody() {
        if (this._httpBody == null) {
            HttpClientResponse httpClientResponse = this;
            synchronized (httpClientResponse) {
                if (this._httpBody == null) {
                    try {
                        ContentType theContentType = this.getHeaderFields().getContentType();
                        String theEncoding = theContentType != null && theContentType.getCharsetParametrer() != null ? theContentType.getCharsetParametrer() : Encoding.UTF_8.getCode();
                        this._httpBody = new InputStreamStringBuilder().toString(this._httpInputStream, theEncoding);
                    }
                    catch (IOException e) {
                        this._httpBody = e.getMessage();
                    }
                }
            }
        }
        return this._httpBody;
    }

    @Override
    public Url getUrl() {
        return this._url;
    }

    public String toString() {
        return this.getClass().getName() + " [httpStatusCode=" + this._httpStatusCode + "]";
    }
}

