/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.ext.factory.HtmlCanonicalMapFactorySingleton;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class HtmlMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.TEXT_HTML, MediaType.APPLICATION_XHTML_XML};

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public <SRC> String toMarshaled(SRC aContext) throws MarshalException {
        return this.toMarshaled((Object)aContext, (Map)null);
    }

    @Override
    public <SRC> String toMarshaled(SRC aObject, Map<String, String> aProperties) throws MarshalException {
        CanonicalMapBuilderImpl theCanoniocalMap = new CanonicalMapBuilderImpl(aObject);
        if (aObject.getClass().isArray()) {
            theCanoniocalMap = new CanonicalMapBuilderImpl(theCanoniocalMap.retrieveTo("html", "body", "value"));
            theCanoniocalMap.put(new String[]{"html", "body", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (Collection.class.isAssignableFrom(aObject.getClass())) {
            theCanoniocalMap = new CanonicalMapBuilderImpl(theCanoniocalMap.retrieveTo("html", "body", "value"));
            theCanoniocalMap.put(new String[]{"html", "body", TYPE_ANNOTATION}, aObject.getClass().getName());
        }
        return HtmlCanonicalMapFactorySingleton.getInstance().toMarshaled(theCanoniocalMap);
    }

    @Override
    public <T> T toUnmarshaled(String aContext, Class<T> aType) throws UnmarshalException {
        return this.toUnmarshaled(aContext, aType, (Map<String, String>)null);
    }

    @Override
    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType, Map<String, String> aProperties) throws UnmarshalException {
        CanonicalMap theCanoniocalMap = HtmlCanonicalMapFactorySingleton.getInstance().toUnmarshaled(aHttpBody, aProperties);
        if (aType.isArray()) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("html", "body", "value");
        } else if (Collection.class.isAssignableFrom(aType)) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("html", "body", "value");
        } else {
            if (aType.isAssignableFrom(HttpBodyMap.class)) {
                return (T)new HttpBodyMap((Object)theCanoniocalMap);
            }
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("html", "body");
        }
        return theCanoniocalMap.toType(aType);
    }

    @Override
    public <T> T fromMarshaled(InputStream aContentInputStream, Class<T> aType) throws UnmarshalException {
        return this.fromMarshaled(aContentInputStream, aType, (Map<String, String>)null);
    }

    @Override
    public Object fromMarshaled(InputStream aContentInputStream, Map<String, String> aProperties, Class<?> ... aTypes) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder theBuilder = HtmlCanonicalMapFactorySingleton.getInstance().fromMarshaled(aContentInputStream, aProperties);
        for (Class<?> eType : aTypes) {
            try {
                return theBuilder.toType(eType);
            }
            catch (Exception exception) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the input stream to fit into one of the provided types.");
    }
}

