/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Encoding;
import org.refcodes.web.AbstractHttpFields;

public class FormFields
extends AbstractHttpFields<FormFields> {
    private static final long serialVersionUID = 1L;

    public FormFields() {
    }

    public FormFields(Map<String, List<String>> aHttpFields) {
        super(aHttpFields);
    }

    public FormFields(String aHttpFormFields) {
        this.fromUrlQueryString(aHttpFormFields);
    }

    public void fromUrlQueryString(String aQueryString) {
        if (aQueryString != null && aQueryString.length() != 0) {
            if (aQueryString.startsWith("" + Delimiter.URL_QUERY.getChar())) {
                aQueryString = aQueryString.substring(1);
            }
            this.fromBodyFormFields(aQueryString);
        }
    }

    public void fromBodyFormFields(String aHttpFormFields) {
        if (aHttpFormFields != null) {
            String[] theFields;
            for (String eField : theFields = aHttpFormFields.split("\\" + Delimiter.WEB_FIELD.getChar())) {
                String[] eFieldPair = eField.split("" + Delimiter.PROPERTY.getChar());
                if (eFieldPair.length == 1) {
                    this.addTo(eFieldPair[0], "");
                    continue;
                }
                try {
                    this.addTo(eFieldPair[0], URLDecoder.decode(eFieldPair[1], Encoding.UTF_8.getCode()));
                }
                catch (UnsupportedEncodingException e) {
                    this.addTo(eFieldPair[0], eFieldPair[1]);
                }
            }
        }
    }

    public String toUrlQueryString() {
        if (this.isEmpty()) {
            return null;
        }
        return Delimiter.URL_QUERY.getChar() + this.toBodyFormFields();
    }

    public String toBodyFormFields() {
        if (this.isEmpty()) {
            return null;
        }
        Object theQueryString = "";
        for (String eKey : this.keySet()) {
            List eValues = (List)this.get(eKey);
            for (String eValue : eValues) {
                try {
                    eValue = URLEncoder.encode(eValue, Encoding.UTF_8.getCode());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (((String)theQueryString).length() != 0 && ((String)theQueryString).charAt(((String)theQueryString).length() - 1) != Delimiter.URL_QUERY.getChar() && ((String)theQueryString).charAt(((String)theQueryString).length() - 1) != Delimiter.WEB_FIELD.getChar()) {
                    theQueryString = (String)theQueryString + Delimiter.WEB_FIELD.getChar();
                }
                theQueryString = (String)theQueryString + eKey + Delimiter.PROPERTY.getChar() + eValue;
            }
        }
        return theQueryString;
    }

    public int toContentLength() {
        return this.toBodyFormFields().length();
    }

    public void fromUrl(String aUrl) {
        int index;
        if (aUrl != null && (index = aUrl.indexOf(Delimiter.URL_QUERY.getChar())) != -1) {
            this.fromUrlQueryString(aUrl.substring(index + 1));
        }
    }
}

