/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.Collection;
import java.util.Map;
import org.refcodes.data.Delimiter;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.struct.Relation;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeAccessor;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.TopLevelType;
import org.refcodes.web.TopLevelTypeAccessor;

public class ContentType
extends PropertiesBuilderImpl
implements TopLevelTypeAccessor,
MediaTypeAccessor,
HttpMediaType {
    private static final long serialVersionUID = 1L;
    private final MediaType _mediaType;

    public ContentType(MediaType aMediaType) {
        if (aMediaType == null) {
            throw new IllegalArgumentException("You must set a <MediaType> and not <null> as a <ContentType> without <MediaType> does not make sense.");
        }
        this._mediaType = aMediaType;
    }

    public ContentType(String aHttpMediaType) {
        String theHttpContentType;
        if (aHttpMediaType == null || aHttpMediaType.isEmpty()) {
            throw new IllegalArgumentException("You must set a HTTP content type and not <null> (or an empty >String>) as a <ContentType> without <MediaType> does not make sense.");
        }
        int indexOf = aHttpMediaType.indexOf(Delimiter.MEDIA_TYPE_PARAMETERS.getChar());
        if (indexOf != -1) {
            theHttpContentType = aHttpMediaType.substring(0, indexOf);
            if (aHttpMediaType.length() > indexOf) {
                String[] theParameters;
                for (String eTupel : theParameters = aHttpMediaType.substring(indexOf + 1).split("" + Delimiter.MEDIA_TYPE_PARAMETERS.getChar())) {
                    if (eTupel == null) continue;
                    PropertyImpl eProperty = new PropertyImpl(eTupel);
                    this.put(((String)eProperty.getKey()).trim(), eProperty.getValue() != null ? ((String)eProperty.getValue()).trim() : null);
                }
            }
        } else {
            theHttpContentType = aHttpMediaType;
        }
        theHttpContentType = theHttpContentType.trim();
        this._mediaType = MediaType.fromHttpMediaSubtype(theHttpContentType);
        if (this._mediaType == null) {
            throw new IllegalArgumentException("Unable to detect valid known Media-Type from argument <" + aHttpMediaType + ">.");
        }
    }

    public ContentType(MediaType aMediaType, Map<String, String> aProperties) {
        if (aMediaType == null) {
            throw new IllegalArgumentException("You must set a <MediaType> and not <null> as a <ContentType> without <MediaType> does not make sense.");
        }
        this._mediaType = aMediaType;
        this.putAll(aProperties);
    }

    @Override
    public TopLevelType getTopLevelType() {
        return this.getMediaType().getTopLevelType();
    }

    @Override
    public String put(MediaTypeParameter aParameter, String aValue) {
        return this.put(aParameter.getName(), aValue);
    }

    @Override
    public ContentType withPut(MediaTypeParameter aParameter, String aValue) {
        this.put(aParameter.getName(), aValue);
        return this;
    }

    public String getCharsetParametrer() {
        return (String)this.get((Object)MediaTypeParameter.CHARSET.getName());
    }

    public String putCharsetParametrer(String aCharsetCode) {
        return this.put(MediaTypeParameter.CHARSET.getName(), aCharsetCode);
    }

    public ContentType withCharsetParametrer(String aValue) {
        this.put(MediaTypeParameter.CHARSET.getName(), aValue);
        return this;
    }

    @Override
    public String toHttpMediaType() {
        String theResult = null;
        MediaType theMediaType = this.getMediaType();
        if (theMediaType != null) {
            theResult = theMediaType.toHttpMediaType(this);
        }
        return theResult;
    }

    @Override
    public ContentType withPut(Collection<?> aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPut(Object[] aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPut(Relation<String, String> aProperty) {
        this.put(aProperty);
        return this;
    }

    @Override
    public ContentType withPut(String aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPut(Property aProperty) {
        this.put(aProperty);
        return this;
    }

    @Override
    public ContentType withPut(String[] aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutBoolean(Collection<?> aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutBoolean(Object aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutBoolean(Object[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutBoolean(String aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutBoolean(String[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutByte(Collection<?> aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutByte(Object aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutByte(Object[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutByte(String aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutByte(String[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutChar(Collection<?> aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutChar(Object aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutChar(Object[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutChar(String aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutChar(String[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> ContentType withPutClass(Collection<?> aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> ContentType withPutClass(Object aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    @Override
    public <C> ContentType withPutClass(Object[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> ContentType withPutClass(String aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    @Override
    public <C> ContentType withPutClass(String[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutDouble(Collection<?> aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutDouble(Object aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutDouble(Object[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutDouble(String aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutDouble(String[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ContentType withPutEnum(Collection<?> aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ContentType withPutEnum(Object aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ContentType withPutEnum(Object[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ContentType withPutEnum(String aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ContentType withPutEnum(String[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutFloat(Collection<?> aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutFloat(Object aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutFloat(Object[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutFloat(String aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutFloat(String[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutInt(Collection<?> aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutInt(Object aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutInt(Object[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutInt(String aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutInt(String[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutLong(Collection<?> aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutLong(Object aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutLong(Object[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutLong(String aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutLong(String[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutShort(Collection<?> aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutShort(Object aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutShort(Object[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutShort(String aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutShort(String[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutString(Collection<?> aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutString(Object aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutString(Object[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withPutString(String aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    @Override
    public ContentType withPutString(String[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public ContentType withInsert(Object aObj) {
        this.insert(aObj);
        return this;
    }

    @Override
    public ContentType withInsert(PathMap<String> aFrom) {
        this.insert(aFrom);
        return this;
    }

    @Override
    public ContentType withInsertBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertBetween(Collection<?> aToPathElements, PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withInsertBetween(Object aToPath, PathMap<String> aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withInsertBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertBetween(Object[] aToPathElements, PathMap<String> aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertBetween(String aToPath, Object aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withInsertBetween(String aToPath, PathMap<String> aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withInsertBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertBetween(String[] aToPathElements, PathMap<String> aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertFrom(Object aFrom, Object aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withInsertFrom(Object aFrom, Object ... aFromPathElements) {
        this.withInsertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertFrom(Object aFrom, String aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withInsertFrom(Object aFrom, String ... aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertFrom(PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertFrom(PathMap<String> aFrom, Object aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withInsertFrom(PathMap<String> aFrom, Object ... aFromPathElements) {
        this.withInsertFrom((PathMap)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertFrom(PathMap<String> aFrom, String aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withInsertFrom(PathMap<String> aFrom, String ... aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withInsertTo(Collection<?> aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withInsertTo(Collection<?> aToPathElements, PathMap<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withInsertTo(Object aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ContentType withInsertTo(Object aToPath, PathMap<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ContentType withInsertTo(Object[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withInsertTo(Object[] aToPathElements, PathMap<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withInsertTo(String aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ContentType withInsertTo(String aToPath, PathMap<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ContentType withInsertTo(String[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withInsertTo(String[] aToPathElements, PathMap<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withMerge(Object aObj) {
        this.merge(aObj);
        return this;
    }

    @Override
    public ContentType withMerge(PathMap<String> aFrom) {
        this.merge(aFrom);
        return this;
    }

    @Override
    public ContentType withMergeBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeBetween(Collection<?> aToPathElements, PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withMergeBetween(Object aToPath, PathMap<String> aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withMergeBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeBetween(Object[] aToPathElements, PathMap<String> aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, (Object)aFromPathElements, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeBetween(String aToPath, Object aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withMergeBetween(String aToPath, PathMap<String> aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withMergeBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeBetween(String[] aToPathElements, PathMap<String> aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeFrom(Object aFrom, Object aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withMergeFrom(Object aFrom, Object ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeFrom(Object aFrom, String aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withMergeFrom(Object aFrom, String ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeFrom(PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeFrom(PathMap<String> aFrom, Object aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withMergeFrom(PathMap<String> aFrom, Object ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeFrom(PathMap<String> aFrom, String aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ContentType withMergeFrom(PathMap<String> aFrom, String ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ContentType withMergeTo(Collection<?> aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withMergeTo(Collection<?> aToPathElements, PathMap<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withMergeTo(Object aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ContentType withMergeTo(Object aToPath, PathMap<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ContentType withMergeTo(Object[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withMergeTo(Object[] aToPathElements, PathMap<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withMergeTo(String aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ContentType withMergeTo(String aToPath, PathMap<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ContentType withMergeTo(String[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withMergeTo(String[] aToPathElements, PathMap<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ContentType withPutDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
        this.putDirAt((Collection)aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(Collection<?> aPathElements, int aIndex, PathMap<String> aDir) {
        this.putDirAt((Collection)aPathElements, aIndex, (PathMap)aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(int aIndex, Object aDir) {
        this.putDirAt(aIndex, aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(int aIndex, PathMap<String> aDir) {
        this.putDirAt(aIndex, (PathMap)aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(Object aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(Object aPath, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPath, aIndex, (PathMap)aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(Object[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(Object[] aPathElements, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPathElements, aIndex, (PathMap)aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(String aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(String aPath, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPath, aIndex, (PathMap)aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(String[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ContentType withPutDirAt(String[] aPathElements, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPathElements, aIndex, (PathMap)aDir);
        return this;
    }

    @Override
    public ContentType withRemoveFrom(Collection<?> aPathElements) {
        this.removeFrom((Collection)aPathElements);
        return this;
    }

    @Override
    public ContentType withRemoveFrom(Object aPath) {
        this.removeFrom(aPath);
        return this;
    }

    @Override
    public ContentType withRemoveFrom(Object ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public ContentType withRemoveFrom(String aPath) {
        this.removeFrom(aPath);
        return this;
    }

    @Override
    public ContentType withRemoveFrom(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public ContentType withRemovePaths(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public MediaType getMediaType() {
        return this._mediaType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._mediaType == null ? 0 : this._mediaType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        return this._mediaType == other._mediaType;
    }

    public String toString() {
        return this._mediaType.toHttpMediaType();
    }
}

