/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.data.Text;

public class VerboseTextBuilder {
    public static final char DEFAULT_COLLECTION_HEAD = '{';
    public static final char DEFAULT_COLLECTION_TAIL = '}';
    private Collection<Object> _collection = null;
    private Map<Object, Object> _map = null;
    private Character _collectionHead = Character.valueOf('{');
    private Character _collectionTail = Character.valueOf('}');

    public void setCollectionHead(Character aHead) {
        this._collectionHead = aHead;
    }

    public Character getCollectionHead() {
        return this._collectionHead;
    }

    public void setCollectionTail(Character aTail) {
        this._collectionTail = aTail;
    }

    public Character getCollectionTail() {
        return this._collectionTail;
    }

    public Object[] getElements() {
        return this._collection.toArray();
    }

    public void setElements(Object[] aElements) {
        this._collection = new ArrayList<Object>();
        this._map = null;
        for (Object eElement : aElements) {
            this._collection.add(eElement);
        }
    }

    public void setElements(Collection<?> aElements) {
        this._collection = aElements;
    }

    public void setElements(Map<?, ?> aElements) {
        this._collection = null;
        this._map = aElements;
    }

    public void setElements(boolean[] aElements) {
        Boolean[] theElements = new Boolean[aElements.length];
        for (int i = 0; i < theElements.length; ++i) {
            theElements[i] = aElements[i];
        }
        this.setElements((Object[])theElements);
    }

    public void setElements(byte[] aElements) {
        Byte[] theElements = new Byte[aElements.length];
        for (int i = 0; i < theElements.length; ++i) {
            theElements[i] = aElements[i];
        }
        this.setElements((Object[])theElements);
    }

    public void setElements(short[] aElements) {
        Short[] theElements = new Short[aElements.length];
        for (int i = 0; i < theElements.length; ++i) {
            theElements[i] = aElements[i];
        }
        this.setElements((Object[])theElements);
    }

    public void setElements(int[] aElements) {
        Integer[] theElements = new Integer[aElements.length];
        for (int i = 0; i < theElements.length; ++i) {
            theElements[i] = aElements[i];
        }
        this.setElements((Object[])theElements);
    }

    public void setElements(long[] aElements) {
        Long[] theElements = new Long[aElements.length];
        for (int i = 0; i < theElements.length; ++i) {
            theElements[i] = aElements[i];
        }
        this.setElements((Object[])theElements);
    }

    public void setElements(float[] aElements) {
        Float[] theElements = new Float[aElements.length];
        for (int i = 0; i < theElements.length; ++i) {
            theElements[i] = Float.valueOf(aElements[i]);
        }
        this.setElements((Object[])theElements);
    }

    public void setElements(double[] aElements) {
        Double[] theElements = new Double[aElements.length];
        for (int i = 0; i < theElements.length; ++i) {
            theElements[i] = aElements[i];
        }
        this.setElements((Object[])theElements);
    }

    public void setElements(char[] aElements) {
        Character[] theElements = new Character[aElements.length];
        for (int i = 0; i < theElements.length; ++i) {
            theElements[i] = Character.valueOf(aElements[i]);
        }
        this.setElements((Object[])theElements);
    }

    public VerboseTextBuilder withElements(boolean[] aElements) {
        this.setElements(aElements);
        return this;
    }

    public VerboseTextBuilder withElements(byte[] aElements) {
        this.setElements(aElements);
        return this;
    }

    public VerboseTextBuilder withElements(short[] aElements) {
        this.setElements(aElements);
        return this;
    }

    public VerboseTextBuilder withElements(int[] aElements) {
        this.setElements(aElements);
        return this;
    }

    public VerboseTextBuilder withElements(long[] aElements) {
        this.setElements(aElements);
        return this;
    }

    public VerboseTextBuilder withElements(float[] aElements) {
        this.setElements(aElements);
        return this;
    }

    public VerboseTextBuilder withElements(double[] aElements) {
        this.setElements(aElements);
        return this;
    }

    public VerboseTextBuilder withElements(char[] aElements) {
        this.setElements(aElements);
        return this;
    }

    public void setElements(Boolean[] aElements) {
        this.setElements((Object[])aElements);
    }

    public void setElements(Byte[] aElements) {
        this.setElements((Object[])aElements);
    }

    public void setElements(Short[] aElements) {
        this.setElements((Object[])aElements);
    }

    public void setElements(Integer[] aElements) {
        this.setElements((Object[])aElements);
    }

    public void setElements(Long[] aElements) {
        this.setElements((Object[])aElements);
    }

    public void setElements(Float[] aElements) {
        this.setElements((Object[])aElements);
    }

    public void setElements(Double[] aElements) {
        this.setElements((Object[])aElements);
    }

    public void setElements(Character[] aElements) {
        this.setElements((Object[])aElements);
    }

    public void setElements(String[] aElements) {
        this.setElements((Object[])aElements);
    }

    public VerboseTextBuilder withElements(Object[] aElements) {
        this.setElements(aElements);
        return this;
    }

    public VerboseTextBuilder withElements(Collection<?> aElements) {
        this.setElements(aElements);
        return this;
    }

    public void setElements(Object aElements) {
        if (aElements == null || aElements.getClass().isArray()) {
            this.setElements((Object[])aElements);
        } else if (aElements instanceof Collection) {
            this.setElements((Collection)aElements);
        } else if (aElements instanceof Map) {
            this.setElements((Map)aElements);
        } else {
            this.setElements(new Object[]{aElements});
        }
    }

    public VerboseTextBuilder withElements(Object aElements) {
        this.setElements(aElements);
        return this;
    }

    public VerboseTextBuilder withElements(Map<?, ?> aElements) {
        this.setElements(aElements);
        return this;
    }

    public String toString() {
        if (this._collection != null) {
            return VerboseTextBuilder.asVerboseString(this._collectionHead, this._collection, this._collectionTail);
        }
        if (this._map != null) {
            return VerboseTextBuilder.asVerboseString(this._collectionHead, this._map, this._collectionTail);
        }
        return Text.NULL_VALUE.getText();
    }

    public String toString(boolean[] aElements) {
        ArrayList<Boolean> theElements = new ArrayList<Boolean>();
        for (boolean aElement : aElements) {
            theElements.add(aElement);
        }
        return this.toString(theElements);
    }

    public String toString(byte[] aElements) {
        ArrayList<Byte> theElements = new ArrayList<Byte>();
        for (byte aElement : aElements) {
            theElements.add(aElement);
        }
        return this.toString(theElements);
    }

    public String toString(short[] aElements) {
        ArrayList<Short> theElements = new ArrayList<Short>();
        for (short aElement : aElements) {
            theElements.add(aElement);
        }
        return this.toString(theElements);
    }

    public String toString(int[] aElements) {
        ArrayList<Integer> theElements = new ArrayList<Integer>();
        for (int aElement : aElements) {
            theElements.add(aElement);
        }
        return this.toString(theElements);
    }

    public String toString(long[] aElements) {
        ArrayList<Long> theElements = new ArrayList<Long>();
        for (long aElement : aElements) {
            theElements.add(aElement);
        }
        return this.toString(theElements);
    }

    public String toString(float[] aElements) {
        ArrayList<Float> theElements = new ArrayList<Float>();
        for (float aElement : aElements) {
            theElements.add(Float.valueOf(aElement));
        }
        return this.toString(theElements);
    }

    public String toString(double[] aElements) {
        ArrayList<Double> theElements = new ArrayList<Double>();
        for (double aElement : aElements) {
            theElements.add(aElement);
        }
        return this.toString(theElements);
    }

    public String toString(char[] aElements) {
        ArrayList<Character> theElements = new ArrayList<Character>();
        for (char aElement : aElements) {
            theElements.add(Character.valueOf(aElement));
        }
        return this.toString(theElements);
    }

    public String toString(Boolean[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(Byte[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(Short[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(Integer[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(Long[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(Float[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(Double[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(Character[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(String[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(Object[] aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, Arrays.asList(aElements), this._collectionTail);
    }

    public String toString(Collection<?> aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, aElements, this._collectionTail);
    }

    public String toString(Map<?, ?> aElements) {
        return VerboseTextBuilder.asVerboseString(this._collectionHead, aElements, this._collectionTail);
    }

    public VerboseTextBuilder withCollectionHead(Character aHead) {
        this.setCollectionHead(aHead);
        return this;
    }

    public String toString(Object aElements) {
        if (aElements.getClass().isArray()) {
            return this.toString((Object[])aElements);
        }
        if (aElements instanceof Collection) {
            return this.toString((Collection)aElements);
        }
        if (aElements instanceof Map) {
            return this.toString((Map)aElements);
        }
        return this.toString(new Object[]{aElements});
    }

    public static String asString(boolean[] aElements) {
        if (aElements == null) {
            return null;
        }
        ArrayList<Boolean> theList = new ArrayList<Boolean>();
        for (boolean eValue : aElements) {
            theList.add(eValue);
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), theList, Character.valueOf('}'));
    }

    public static String asString(byte[] aElements) {
        if (aElements == null) {
            return null;
        }
        ArrayList<Byte> theList = new ArrayList<Byte>();
        for (byte eValue : aElements) {
            theList.add(eValue);
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), theList, Character.valueOf('}'));
    }

    public static String asString(short[] aElements) {
        if (aElements == null) {
            return null;
        }
        ArrayList<Short> theList = new ArrayList<Short>();
        for (short eValue : aElements) {
            theList.add(eValue);
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), theList, Character.valueOf('}'));
    }

    public static String asString(int[] aElements) {
        if (aElements == null) {
            return null;
        }
        ArrayList<Integer> theList = new ArrayList<Integer>();
        for (int eValue : aElements) {
            theList.add(eValue);
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), theList, Character.valueOf('}'));
    }

    public static String asString(long[] aElements) {
        if (aElements == null) {
            return null;
        }
        ArrayList<Long> theList = new ArrayList<Long>();
        for (long eValue : aElements) {
            theList.add(eValue);
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), theList, Character.valueOf('}'));
    }

    public static String asString(float[] aElements) {
        if (aElements == null) {
            return null;
        }
        ArrayList<Float> theList = new ArrayList<Float>();
        for (float eValue : aElements) {
            theList.add(Float.valueOf(eValue));
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), theList, Character.valueOf('}'));
    }

    public static String asString(double[] aElements) {
        if (aElements == null) {
            return null;
        }
        ArrayList<Double> theList = new ArrayList<Double>();
        for (double eValue : aElements) {
            theList.add(eValue);
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), theList, Character.valueOf('}'));
    }

    public static String asString(char[] aElements) {
        if (aElements == null) {
            return null;
        }
        ArrayList<Character> theList = new ArrayList<Character>();
        for (char eValue : aElements) {
            theList.add(Character.valueOf(eValue));
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), theList, Character.valueOf('}'));
    }

    public static String asString(Boolean[] aElements) {
        if (aElements == null) {
            return null;
        }
        ArrayList<Boolean> theList = new ArrayList<Boolean>();
        Boolean[] booleanArray = aElements;
        int n = booleanArray.length;
        for (int i = 0; i < n; ++i) {
            boolean eValue = booleanArray[i];
            theList.add(eValue);
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), theList, Character.valueOf('}'));
    }

    public static String asString(Byte[] aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), Arrays.asList(aElements), Character.valueOf('}'));
    }

    public static String asString(Short[] aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), Arrays.asList(aElements), Character.valueOf('}'));
    }

    public static String asString(Integer[] aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), Arrays.asList(aElements), Character.valueOf('}'));
    }

    public static String asString(Long[] aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), Arrays.asList(aElements), Character.valueOf('}'));
    }

    public static String asString(Float[] aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), Arrays.asList(aElements), Character.valueOf('}'));
    }

    public static String asString(Double[] aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), Arrays.asList(aElements), Character.valueOf('}'));
    }

    public static String asString(Character[] aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), Arrays.asList(aElements), Character.valueOf('}'));
    }

    public static String asString(String[] aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), Arrays.asList(aElements), Character.valueOf('}'));
    }

    public static String asString(Object[] aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), Arrays.asList(aElements), Character.valueOf('}'));
    }

    public static String asString(Collection<?> aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), aElements, Character.valueOf('}'));
    }

    public static String asString(Map<?, ?> aElements) {
        if (aElements == null) {
            return null;
        }
        return VerboseTextBuilder.asVerboseString(Character.valueOf('{'), aElements, Character.valueOf('}'));
    }

    public static String asString(Object aElements) {
        if (aElements == null) {
            return null;
        }
        if (aElements instanceof boolean[]) {
            return VerboseTextBuilder.asString((boolean[])aElements);
        }
        if (aElements instanceof byte[]) {
            return VerboseTextBuilder.asString((byte[])aElements);
        }
        if (aElements instanceof char[]) {
            return VerboseTextBuilder.asString((char[])aElements);
        }
        if (aElements instanceof short[]) {
            return VerboseTextBuilder.asString((short[])aElements);
        }
        if (aElements instanceof int[]) {
            return VerboseTextBuilder.asString((int[])aElements);
        }
        if (aElements instanceof long[]) {
            return VerboseTextBuilder.asString((long[])aElements);
        }
        if (aElements instanceof float[]) {
            return VerboseTextBuilder.asString((float[])aElements);
        }
        if (aElements instanceof double[]) {
            return VerboseTextBuilder.asString((double[])aElements);
        }
        if (aElements.getClass().isArray()) {
            return VerboseTextBuilder.asString((Object[])aElements);
        }
        if (aElements instanceof Collection) {
            return VerboseTextBuilder.asString((Collection)aElements);
        }
        if (aElements instanceof Map) {
            return VerboseTextBuilder.asString((Map)aElements);
        }
        return VerboseTextBuilder.asString(new Object[]{aElements});
    }

    protected static String asVerboseString(Character aCollectionHead, Collection<?> aCollection, Character aCollectionTail) {
        Object theCollectionHead = "";
        if (aCollectionHead != null) {
            theCollectionHead = "" + aCollectionHead;
        }
        Object theCollectionTail = "";
        if (aCollectionTail != null) {
            theCollectionTail = "" + aCollectionTail;
        }
        if (aCollection.isEmpty()) {
            return (String)theCollectionHead + (String)theCollectionTail;
        }
        StringBuilder theBuffer = new StringBuilder();
        if (aCollectionHead != null) {
            theBuffer.append(aCollectionHead + " ");
        }
        Iterator<?> e = aCollection.iterator();
        while (e.hasNext()) {
            Object eValue = e.next();
            if (eValue != null && eValue.getClass().isArray()) {
                eValue = eValue instanceof byte[] ? VerboseTextBuilder.asString((byte[])eValue) : (eValue instanceof short[] ? VerboseTextBuilder.asString((short[])eValue) : (eValue instanceof int[] ? VerboseTextBuilder.asString((int[])eValue) : (eValue instanceof long[] ? VerboseTextBuilder.asString((long[])eValue) : (eValue instanceof float[] ? VerboseTextBuilder.asString((float[])eValue) : (eValue instanceof double[] ? VerboseTextBuilder.asString((double[])eValue) : (eValue instanceof boolean[] ? VerboseTextBuilder.asString((boolean[])eValue) : (eValue instanceof char[] ? VerboseTextBuilder.asString((char[])eValue) : VerboseTextBuilder.asString((Object[])eValue))))))));
                theBuffer.append(eValue);
            } else if (eValue instanceof String) {
                theBuffer.append("\"" + eValue + "\"");
            } else if (eValue instanceof Character) {
                theBuffer.append("'" + eValue + "'");
            } else if (eValue instanceof Enum) {
                theBuffer.append(((Enum)eValue).name());
            } else {
                theBuffer.append(eValue);
            }
            if (!e.hasNext()) continue;
            theBuffer.append(", ");
        }
        if (aCollectionTail != null) {
            theBuffer.append(" " + aCollectionTail);
        }
        return theBuffer.toString();
    }

    protected static String asVerboseString(Character aCollectionHead, Map<?, ?> aMap, Character aCollectionTail) {
        Object theCollectionHead = "";
        if (aCollectionHead != null) {
            theCollectionHead = "" + aCollectionHead;
        }
        Object theCollectionTail = "";
        if (aCollectionTail != null) {
            theCollectionTail = "" + aCollectionTail;
        }
        if (aMap.isEmpty()) {
            return (String)theCollectionHead + (String)theCollectionTail;
        }
        StringBuilder theBuffer = new StringBuilder();
        if (aCollectionHead != null) {
            theBuffer.append(aCollectionHead);
        }
        theBuffer.append('\n');
        Iterator<?> e = aMap.keySet().iterator();
        while (e.hasNext()) {
            Object eKey = e.next();
            Object eValue = aMap.get(eKey);
            if (eValue != null && eValue.getClass().isArray()) {
                eValue = eValue instanceof byte[] ? VerboseTextBuilder.asString((byte[])eValue) : (eValue instanceof short[] ? VerboseTextBuilder.asString((short[])eValue) : (eValue instanceof int[] ? VerboseTextBuilder.asString((int[])eValue) : (eValue instanceof long[] ? VerboseTextBuilder.asString((long[])eValue) : (eValue instanceof float[] ? VerboseTextBuilder.asString((float[])eValue) : (eValue instanceof double[] ? VerboseTextBuilder.asString((double[])eValue) : (eValue instanceof boolean[] ? VerboseTextBuilder.asString((boolean[])eValue) : (eValue instanceof char[] ? VerboseTextBuilder.asString((char[])eValue) : VerboseTextBuilder.asString((Object[])eValue))))))));
                theBuffer.append("  " + eKey + " = " + eValue);
            } else if (eValue instanceof String) {
                theBuffer.append("  " + eKey + " = \"" + eValue + "\"");
            } else if (eValue instanceof Enum) {
                theBuffer.append("  " + eKey + " = \"" + ((Enum)eValue).name() + "\"");
            } else {
                theBuffer.append("  " + eKey + " = " + eValue);
            }
            if (e.hasNext()) {
                theBuffer.append(',');
            }
            theBuffer.append('\n');
        }
        if (aCollectionTail != null) {
            theBuffer.append(aCollectionTail);
        }
        return theBuffer.toString();
    }
}

