/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.CharSet;
import org.refcodes.mixin.TruncateMode;
import org.refcodes.mixin.TruncateModeAccessor;
import org.refcodes.textual.AbstractText;

public class TruncateTextBuilder
extends AbstractText<TruncateTextBuilder>
implements TruncateModeAccessor.TruncateModeProperty,
TruncateModeAccessor.TruncateModeBuilder<TruncateTextBuilder> {
    private TruncateMode _truncateTextMode = TruncateMode.TAIL;
    private char[] _truncateChars = CharSet.WHITE_SPACES.getCharSet();

    @Override
    public TruncateMode getTruncateMode() {
        return this._truncateTextMode;
    }

    @Override
    public void setTruncateMode(TruncateMode aTruncateTextMode) {
        this._truncateTextMode = aTruncateTextMode;
    }

    public char[] getTruncateChars() {
        return this._truncateChars;
    }

    public void setTruncateChars(char ... aTruncateChars) {
        this._truncateChars = aTruncateChars;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... aText) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = TruncateTextBuilder.asTruncated(aText[i], this._truncateTextMode, this._truncateChars);
        }
        return theResult;
    }

    @Override
    public TruncateTextBuilder withTruncateMode(TruncateMode aTruncateTextMode) {
        this.setTruncateMode(aTruncateTextMode);
        return this;
    }

    @Override
    public TruncateTextBuilder withText(String ... aTextLines) {
        this.setText(aTextLines);
        return this;
    }

    public TruncateTextBuilder withStripChars(char ... aStripChars) {
        this.setTruncateChars(aStripChars);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static String asTruncated(String aText, TruncateMode aTruncateTextMode) {
        return TruncateTextBuilder.asTruncated(aText, aTruncateTextMode, CharSet.WHITE_SPACES.getCharSet());
    }

    public static String asTruncated(String aText, TruncateMode aTruncateTextMode, char ... aChars) {
        switch (aTruncateTextMode) {
            case HEAD: {
                return TruncateTextBuilder.asTruncatedLeft(aText, aChars);
            }
            case HEAD_AND_TAIL: {
                return TruncateTextBuilder.toStrip(aText, aChars);
            }
            case TAIL: {
                return TruncateTextBuilder.asTruncatedRight(aText, aChars);
            }
        }
        throw new IllegalArgumentException("You must pass a valid text strip mode, though you actually passed <" + aTruncateTextMode + ">!");
    }

    public static String asTruncatedLeft(String aText) {
        return TruncateTextBuilder.asTruncatedRight(aText, CharSet.WHITE_SPACES.getCharSet());
    }

    public static String asTruncatedLeft(String aText, char ... aChars) {
        StringBuilder theStringBuffer = new StringBuilder(aText);
        for (char aChar : aChars) {
            TruncateTextBuilder.doStripLeft(theStringBuffer, aChar);
        }
        return theStringBuffer.toString();
    }

    public static String asTruncatedRight(String aText) {
        return TruncateTextBuilder.asTruncatedRight(aText, CharSet.WHITE_SPACES.getCharSet());
    }

    public static String asTruncatedRight(String aText, char ... aChars) {
        StringBuilder theStringBuffer = new StringBuilder(aText);
        for (char aChar : aChars) {
            TruncateTextBuilder.doStripRight(theStringBuffer, aChar);
        }
        return theStringBuffer.toString();
    }

    protected static void doStripLeft(StringBuilder aStringBuffer, char aChar) {
        for (int i = 0; i < aStringBuffer.length() && aStringBuffer.charAt(i) == aChar; ++i) {
            aStringBuffer.deleteCharAt(i);
            --i;
        }
    }

    protected static void doStripRight(StringBuilder aStringBuffer, char aChar) {
        for (int i = aStringBuffer.length() - 1; i >= 0 && aStringBuffer.charAt(i) == aChar; --i) {
            aStringBuffer.deleteCharAt(i);
        }
    }

    protected static void doStrip(StringBuilder aStringBuffer, char aChar) {
        TruncateTextBuilder.doStripLeft(aStringBuffer, aChar);
        TruncateTextBuilder.doStripRight(aStringBuffer, aChar);
    }

    protected static String toStrip(String aText, char[] aChars) {
        return TruncateTextBuilder.asTruncatedRight(TruncateTextBuilder.asTruncatedLeft(aText, aChars), aChars);
    }
}

