/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.CharSet;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.FillCharAccessor;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.HorizAlignTextModeAccessor;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TextLineBuilder;

public class TextBlockBuilder
extends AbstractText<TextBlockBuilder>
implements FillCharAccessor.FillCharProperty,
FillCharAccessor.FillCharBuilder<TextBlockBuilder>,
ColumnWidthAccessor.ColumnWidthBuilder<TextBlockBuilder>,
ColumnWidthAccessor.ColumnWidthProperty,
HorizAlignTextModeAccessor.HorizAlignTextModeProperty,
HorizAlignTextModeAccessor.HorizAlignTextModeBuilder<TextBlockBuilder> {
    public static final String LINE_BREAKS = new String(new char[]{'\t', '\n', '\r'});
    private int _columnWidth = Terminal.toHeuristicWidth();
    private HorizAlignTextMode _alignTextMode = HorizAlignTextMode.LEFT;
    private SplitTextMode _splitTextMode = SplitTextMode.AT_SPACE;
    private char _fillChar = (char)32;

    @Override
    public char getFillChar() {
        return this._fillChar;
    }

    @Override
    public void setFillChar(char aFillChar) {
        this._fillChar = aFillChar;
    }

    @Override
    public TextBlockBuilder withColumnWidth(int aColumnWidth) {
        this.setColumnWidth(aColumnWidth);
        return this;
    }

    @Override
    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    @Override
    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public void setHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this._alignTextMode = aHorizAlignTextMode;
    }

    @Override
    public HorizAlignTextMode getHorizAlignTextMode() {
        return this._alignTextMode;
    }

    public SplitTextMode getSplitTextMode() {
        return this._splitTextMode;
    }

    public void setSplitTextMode(SplitTextMode aSplitTextMode) {
        this._splitTextMode = aSplitTextMode;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... aText) {
        return TextBlockBuilder.asTextBlock(aText, this.getColumnWidth(), this.getHorizAlignTextMode(), this.getSplitTextMode(), this.getFillChar());
    }

    @Override
    public TextBlockBuilder withHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.setHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    @Override
    public TextBlockBuilder withFillChar(char aFillChar) {
        this.setFillChar(aFillChar);
        return this;
    }

    public TextBlockBuilder withSplitTextMode(SplitTextMode aSplitTextMode) {
        this.setSplitTextMode(aSplitTextMode);
        return this;
    }

    public static String[] asTextBlock(String aText, int aColumnWidth) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, false);
    }

    public static String[] asTextBlock(String aText, int aColumnWidth, SplitTextMode aSplitTextMode) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, aSplitTextMode, false);
    }

    public static String[] asTextBlock(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, aHorizAlignTextMode, false);
    }

    public static String[] asTextBlock(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, SplitTextMode aSplitTextMode, char aFillChar) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, aHorizAlignTextMode, aSplitTextMode, aFillChar, false);
    }

    public static String[] asTextBlock(String[] aText, int aColumnWidth) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, false);
    }

    public static String[] asTextBlock(String[] aText, int aColumnWidth, SplitTextMode aSplitTextMode) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, aSplitTextMode, false);
    }

    public static String[] asTextBlock(String[] aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, aHorizAlignTextMode, false);
    }

    public static String[] asTextBlock(String[] aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, SplitTextMode aSplitTextMode, char aFillChar) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, aHorizAlignTextMode, aSplitTextMode, aFillChar, false);
    }

    public static String[] asTextBlock(String aText, int aColumnWidth, boolean hasAnsiEscapeCodes) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, null, null, ' ', hasAnsiEscapeCodes);
    }

    public static String[] asTextBlock(String aText, int aColumnWidth, SplitTextMode aSplitTextMode, boolean hasAnsiEscapeCodes) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, null, aSplitTextMode, ' ', hasAnsiEscapeCodes);
    }

    public static String[] asTextBlock(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, boolean hasAnsiEscapeCodes) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, aHorizAlignTextMode, null, ' ', hasAnsiEscapeCodes);
    }

    public static String[] asTextBlock(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, SplitTextMode aSplitTextMode, char aFillChar, boolean hasAnsiEscapeCodes) {
        if (aText == null) {
            return null;
        }
        if (aSplitTextMode == null) {
            aSplitTextMode = SplitTextMode.AT_FIXED_WIDTH;
        }
        switch (aSplitTextMode) {
            case AT_END_OF_LINE: {
                return TextBlockBuilder.toSplitAtEndOfLineTextBlock(aText, aColumnWidth, aHorizAlignTextMode, aFillChar, hasAnsiEscapeCodes);
            }
            case AT_FIRST_END_OF_LINE: {
                return TextBlockBuilder.toSplitAtFirstEndOfLineTextBlock(aText, aColumnWidth, aHorizAlignTextMode, aFillChar, hasAnsiEscapeCodes);
            }
            case AT_SPACE: {
                return TextBlockBuilder.toSplitAtSpaceTextBlock(aText, aColumnWidth, aHorizAlignTextMode, aFillChar, hasAnsiEscapeCodes);
            }
        }
        return TextBlockBuilder.toSplitAtFixedWidthTextBlock(aText, aColumnWidth, aHorizAlignTextMode, aFillChar, hasAnsiEscapeCodes);
    }

    public static String[] asTextBlock(String[] aText, int aColumnWidth, boolean hasAnsiEscapeCodes) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, null, null, ' ', hasAnsiEscapeCodes);
    }

    public static String[] asTextBlock(String[] aText, int aColumnWidth, SplitTextMode aSplitTextMode, boolean hasAnsiEscapeCodes) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, null, aSplitTextMode, ' ', hasAnsiEscapeCodes);
    }

    public static String[] asTextBlock(String[] aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, boolean hasAnsiEscapeCodes) {
        return TextBlockBuilder.asTextBlock(aText, aColumnWidth, aHorizAlignTextMode, null, ' ', hasAnsiEscapeCodes);
    }

    public static String[] asTextBlock(String[] aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, SplitTextMode aSplitTextMode, char aFillChar, boolean hasAnsiEscapeCodes) {
        ArrayList<String> theText = new ArrayList<String>();
        for (int i = 0; i < aText.length; ++i) {
            String eLine = aText[i];
            Collections.addAll(theText, TextBlockBuilder.asTextBlock(eLine, aColumnWidth, aHorizAlignTextMode, aSplitTextMode, aFillChar, hasAnsiEscapeCodes));
            if (i >= aText.length - 1) continue;
            theText.add(new TextLineBuilder().withLineChar(' ').withColumnWidth(((String)theText.get(0)).length()).toString());
        }
        return theText.toArray(new String[theText.size()]);
    }

    private static String toNonBreakingLine(String aText) {
        if (aText == null) {
            return null;
        }
        StringBuilder theStringBuffer = new StringBuilder();
        StringTokenizer e = new StringTokenizer(aText, LINE_BREAKS);
        while (e.hasMoreTokens()) {
            String eText = e.nextToken();
            theStringBuffer.append(eText);
            if (!e.hasMoreTokens() || theStringBuffer.length() <= 0 || theStringBuffer.charAt(theStringBuffer.length() - 1) == ' ') continue;
            if (!TextBlockBuilder.hasAtEndOfLine(theStringBuffer, CharSet.LINE_BREAK_MARKERS) && !TextBlockBuilder.hasAtEndOfLine(theStringBuffer, CharSet.OPENING_BRACES) && theStringBuffer.charAt(theStringBuffer.length() - 1) != '.') {
                theStringBuffer.append('.');
            }
            theStringBuffer.append(' ');
        }
        return theStringBuffer.toString();
    }

    private static boolean hasAtEndOfLine(StringBuilder aBuffer, CharSet aEolChars) {
        boolean hasEndOfLineChar = false;
        for (int i = 0; i < aEolChars.getCharSet().length; ++i) {
            if (aBuffer.charAt(aBuffer.length() - 1) != aEolChars.getCharSet()[i]) continue;
            hasEndOfLineChar = true;
            break;
        }
        return hasEndOfLineChar;
    }

    private static String[] toSplitAtSpaceTextBlock(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, char aFillChar, boolean hasAnsiEscapeCodes) {
        String[] theSubstringArray;
        ArrayList<String> theStringList = new ArrayList<String>();
        String eText = TextBlockBuilder.toNonBreakingLine(aText);
        while (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > aColumnWidth) {
            eText = TextBlockBuilder.toTruncatePrefixedSpaces(eText, hasAnsiEscapeCodes);
            String eSubstring = TextBlockBuilder.toLastSpaceIndex(eText, aColumnWidth, hasAnsiEscapeCodes);
            eSubstring = TextBlockBuilder.toTruncateTrailingSpaces(eSubstring, hasAnsiEscapeCodes);
            theStringList.add(HorizAlignTextBuilder.asAligned(eSubstring, aColumnWidth, aFillChar, aHorizAlignTextMode, hasAnsiEscapeCodes));
            eText = eText.substring(eSubstring.length());
        }
        if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > 0) {
            eText = TextBlockBuilder.toTruncatePrefixedSpaces(eText, hasAnsiEscapeCodes);
            if (AnsiEscapeCode.toLength(eText = TextBlockBuilder.toTruncateTrailingSpaces(eText, hasAnsiEscapeCodes), hasAnsiEscapeCodes) > 0) {
                theStringList.add(HorizAlignTextBuilder.asAligned(eText, aColumnWidth, aFillChar, aHorizAlignTextMode, hasAnsiEscapeCodes));
            }
        }
        if (theStringList.size() == 0) {
            theSubstringArray = new String[]{aText};
        } else {
            theSubstringArray = new String[theStringList.size()];
            for (int i = 0; i < theSubstringArray.length; ++i) {
                theSubstringArray[i] = (String)theStringList.get(i);
            }
        }
        return theSubstringArray;
    }

    private static String toLastSpaceIndex(String aText, int aColumnWidth, boolean hasAnsiEscapeCodes) {
        String eText = aText;
        while (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > aColumnWidth) {
            int index = TextBlockBuilder.lastIndexOf(eText, CharSet.SPACE_MARKERS.getCharSet());
            if (index == -1) {
                return aText.substring(0, aColumnWidth);
            }
            eText = eText.substring(0, index);
        }
        return eText;
    }

    private static int lastIndexOf(String aText, char[] aCharSet) {
        for (int i = aText.length() - 1; i > 0; --i) {
            for (int l = 0; l < aCharSet.length; ++l) {
                if (aText.charAt(i) != CharSet.SPACE_MARKERS.getCharSet()[l]) continue;
                return i;
            }
        }
        return -1;
    }

    private static String[] toSplitAtFixedWidthTextBlock(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, char aFillChar, boolean hasAnsiEscapeCodes) {
        String[] theSubstringArray;
        ArrayList<String> theStringList = new ArrayList<String>();
        String eText = aText;
        while (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > aColumnWidth) {
            String eSubstring = eText.substring(0, aColumnWidth);
            eText = eText.substring(aColumnWidth);
            theStringList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{eSubstring})).withColumnWidth(aColumnWidth).withFillChar(aFillChar).withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > 0) {
            theStringList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{eText})).withColumnWidth(aColumnWidth).withFillChar(aFillChar).withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (theStringList.size() == 0) {
            theSubstringArray = new String[]{aText};
        } else {
            theSubstringArray = new String[theStringList.size()];
            for (int i = 0; i < theSubstringArray.length; ++i) {
                theSubstringArray[i] = (String)theStringList.get(i);
            }
        }
        return theSubstringArray;
    }

    private static String[] toSplitAtFirstEndOfLineTextBlock(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, char aFillChar, boolean hasAnsiEscapeCodes) {
        String[] theSubstringArray;
        int eTempIndex;
        int i;
        int eLineBreakIndex;
        String eSubstring;
        ArrayList<String> theStringList = new ArrayList<String>();
        String eText = aText;
        while (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > aColumnWidth) {
            eSubstring = eText.substring(0, aColumnWidth + 1);
            eSubstring = TextBlockBuilder.toTruncateTrailingSpaces(eSubstring, hasAnsiEscapeCodes);
            eLineBreakIndex = -1;
            for (i = 0; i < CharSet.END_OF_LINE.getCharSet().length; ++i) {
                eTempIndex = eSubstring.indexOf(CharSet.END_OF_LINE.getCharSet()[i]);
                if (eLineBreakIndex != -1 && (eTempIndex == -1 || eTempIndex >= eLineBreakIndex)) continue;
                eLineBreakIndex = eTempIndex;
            }
            if (eLineBreakIndex > aColumnWidth) {
                for (i = 0; i < CharSet.LINE_BREAK_MARKERS.getCharSet().length; ++i) {
                    eTempIndex = eSubstring.lastIndexOf(CharSet.LINE_BREAK_MARKERS.getCharSet()[i]);
                    if (eLineBreakIndex != -1 && (eTempIndex == -1 || eTempIndex <= eLineBreakIndex)) continue;
                    eLineBreakIndex = eTempIndex;
                }
            }
            if (eLineBreakIndex != -1) {
                eSubstring = eText.substring(0, eLineBreakIndex + 1);
                eSubstring = TextBlockBuilder.toTruncateTrailingSpaces(eSubstring, hasAnsiEscapeCodes);
                if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > eLineBreakIndex) {
                    eText = eText.substring(eLineBreakIndex + 1);
                    eText = TextBlockBuilder.toTruncatePrefixedSpaces(eText, hasAnsiEscapeCodes);
                } else {
                    eText = "";
                }
            } else if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > aColumnWidth) {
                eSubstring = eText.substring(0, aColumnWidth);
                eText = eText.substring(aColumnWidth);
            } else {
                eText = "";
            }
            theStringList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(eSubstring)})).withColumnWidth(aColumnWidth).withFillChar(aFillChar).withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > 0) {
            do {
                eLineBreakIndex = -1;
                for (i = 0; i < CharSet.END_OF_LINE.getCharSet().length; ++i) {
                    eTempIndex = eText.indexOf(CharSet.END_OF_LINE.getCharSet()[i]);
                    if (eLineBreakIndex != -1 && (eTempIndex == -1 || eTempIndex >= eLineBreakIndex)) continue;
                    eLineBreakIndex = eTempIndex;
                }
                if (eLineBreakIndex == -1) continue;
                eSubstring = eText.substring(0, eLineBreakIndex + 1);
                eSubstring = TextBlockBuilder.toTruncateTrailingSpaces(eSubstring, hasAnsiEscapeCodes);
                if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > eLineBreakIndex) {
                    eText = eText.substring(eLineBreakIndex + 1);
                    eText = TextBlockBuilder.toTruncatePrefixedSpaces(eText, hasAnsiEscapeCodes);
                    theStringList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(eSubstring)})).withColumnWidth(aColumnWidth).withFillChar(aFillChar).withHorizAlignTextMode(aHorizAlignTextMode).toString());
                    continue;
                }
                eText = "";
            } while (eLineBreakIndex != -1);
        }
        if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > 0) {
            theStringList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(eText)})).withColumnWidth(aColumnWidth).withFillChar(aFillChar).withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (theStringList.size() == 0) {
            theSubstringArray = new String[]{aText};
        } else {
            theSubstringArray = new String[theStringList.size()];
            for (int i2 = 0; i2 < theSubstringArray.length; ++i2) {
                theSubstringArray[i2] = (String)theStringList.get(i2);
            }
        }
        return theSubstringArray;
    }

    private static String[] toSplitAtEndOfLineTextBlock(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, char aFillChar, boolean hasAnsiEscapeCodes) {
        String[] theSubstringArray;
        ArrayList<String> theStringList = new ArrayList<String>();
        String eText = aText;
        while (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > aColumnWidth) {
            String eSubstring = eText.substring(0, aColumnWidth + 1);
            eSubstring = TextBlockBuilder.toTruncateTrailingSpaces(eSubstring, hasAnsiEscapeCodes);
            int eLineBreakIndex = -1;
            for (int i = 0; i < CharSet.LINE_BREAK_MARKERS.getCharSet().length; ++i) {
                int eTempIndex = eSubstring.lastIndexOf(CharSet.LINE_BREAK_MARKERS.getCharSet()[i]);
                if (eLineBreakIndex != -1 && (eTempIndex == -1 || eTempIndex <= eLineBreakIndex)) continue;
                eLineBreakIndex = eTempIndex;
            }
            if (eLineBreakIndex != -1) {
                eSubstring = eText.substring(0, eLineBreakIndex + 1);
                eSubstring = TextBlockBuilder.toTruncateTrailingSpaces(eSubstring, hasAnsiEscapeCodes);
                if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > eLineBreakIndex) {
                    eText = eText.substring(eLineBreakIndex + 1);
                    eText = TextBlockBuilder.toTruncatePrefixedSpaces(eText, hasAnsiEscapeCodes);
                } else {
                    eText = "";
                }
            } else if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > aColumnWidth) {
                eSubstring = eText.substring(0, aColumnWidth);
                eText = eText.substring(aColumnWidth);
            } else {
                eText = "";
            }
            theStringList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(eSubstring)})).withColumnWidth(aColumnWidth).withFillChar(aFillChar).withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (AnsiEscapeCode.toLength(eText, hasAnsiEscapeCodes) > 0) {
            theStringList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(eText)})).withColumnWidth(aColumnWidth).withFillChar(aFillChar).withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (theStringList.size() == 0) {
            theSubstringArray = new String[]{aText};
        } else {
            theSubstringArray = new String[theStringList.size()];
            for (int i = 0; i < theSubstringArray.length; ++i) {
                theSubstringArray[i] = (String)theStringList.get(i);
            }
        }
        return theSubstringArray;
    }

    private static String toTruncateTrailingSpaces(String aText, boolean hasAnsiEscapeCodes) {
        while (AnsiEscapeCode.toLength(aText, hasAnsiEscapeCodes) > 0 && aText.charAt(aText.length() - 1) == ' ') {
            aText = aText.substring(0, AnsiEscapeCode.toLength(aText, hasAnsiEscapeCodes) - 1);
        }
        return aText;
    }

    private static String toTruncatePrefixedSpaces(String aText, boolean hasAnsiEscapeCodes) {
        if (AnsiEscapeCode.toLength(aText, hasAnsiEscapeCodes) > 1) {
            while (aText.charAt(0) == ' ') {
                aText = aText.substring(1);
            }
        }
        return aText;
    }
}

