/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.textual.AbstractText;
import org.refcodes.textual.OverwriteTextMode;

public class OverwriteTextBuilder
extends AbstractText<OverwriteTextBuilder> {
    private String _overwritingText = null;
    private OverwriteTextMode _overwriteTextMode = OverwriteTextMode.RIGHT;

    public String getOverwritingText() {
        return this._overwritingText;
    }

    public void setOverwritingText(String aOverwritingText) {
        this._overwritingText = aOverwritingText;
    }

    public OverwriteTextMode getOverwriteTextMode() {
        return this._overwriteTextMode;
    }

    public void setTextOverwriteMode(OverwriteTextMode aTextOverwriteMode) {
        this._overwriteTextMode = aTextOverwriteMode;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... aText) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = OverwriteTextBuilder.asOverwriteText(aText[i], this._overwritingText, this._overwriteTextMode);
        }
        return theResult;
    }

    public OverwriteTextBuilder withOverwritingText(String aOverwritingText) {
        this.setOverwritingText(aOverwritingText);
        return this;
    }

    public OverwriteTextBuilder withOverwriteTextMode(OverwriteTextMode aOverwriteTextMode) {
        this.setTextOverwriteMode(aOverwriteTextMode);
        return this;
    }

    public static String asOverwriteText(String aText, String aWriteOverText, OverwriteTextMode aOverwriteTextMode) {
        switch (aOverwriteTextMode) {
            case LEFT: {
                return OverwriteTextBuilder.asOverwriteLeft(aText, aWriteOverText);
            }
            case RIGHT: {
                return OverwriteTextBuilder.asOverwriteRight(aText, aWriteOverText);
            }
        }
        throw new IllegalArgumentException("You must pass a valid overwrite text mode, though you actually passed <" + aOverwriteTextMode + ">!");
    }

    public static String asOverwriteLeft(String aText, String aWriteOverText) {
        if (aWriteOverText.length() > aText.length()) {
            return aWriteOverText.substring(0, aText.length());
        }
        if (aWriteOverText.length() == aText.length()) {
            return aWriteOverText;
        }
        String theText = aWriteOverText + aText.substring(aWriteOverText.length());
        return theText;
    }

    public static String asOverwriteRight(String aText, String aWriteOverText) {
        if (aWriteOverText.length() > aText.length()) {
            return aWriteOverText.substring(aWriteOverText.length() - aText.length());
        }
        if (aWriteOverText.length() == aText.length()) {
            return aWriteOverText;
        }
        String theText = aText.substring(0, aText.length() - aWriteOverText.length()) + aWriteOverText;
        return theText;
    }
}

