/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.Prefix;
import org.refcodes.mixin.DelimiterAccessor;
import org.refcodes.mixin.TrimAccessor;
import org.refcodes.textual.CsvEscapeModeAccessor;

public interface CsvMixin
extends CsvEscapeModeAccessor.CsvEscapeModeProperty,
CsvEscapeModeAccessor.CsvEscapeModeBuilder<CsvMixin>,
TrimAccessor.TrimProperty,
TrimAccessor.TrimBuilder<CsvMixin>,
DelimiterAccessor.DelimiterProperty,
DelimiterAccessor.DelimiterBuilder<CsvMixin> {
    public void setCommentPrefixes(String ... var1);

    public String[] getCommentPrefixes();

    public void clearCommentPrefixes();

    public CsvMixin withCommentPrefixes(String ... var1);

    default public boolean isComment(String aLine) {
        if (this.getCommentPrefixes() != null && aLine != null) {
            for (String ePrefix : this.getCommentPrefixes()) {
                if (!aLine.startsWith(ePrefix)) continue;
                return true;
            }
        }
        return false;
    }

    default public String uncomment(String aLine) {
        if (!this.isComment(aLine)) {
            return aLine;
        }
        for (String ePrefix : this.getCommentPrefixes()) {
            if (!aLine.startsWith(ePrefix)) continue;
            aLine = aLine.substring(ePrefix.length());
            while (aLine.startsWith(" ")) {
                aLine = aLine.substring(1);
            }
            break;
        }
        return aLine;
    }

    default public String toComment(String aLine) {
        String theCommentPrefix = this.getCommentPrefixes() == null || this.getCommentPrefixes().length == 0 || this.getCommentPrefixes()[0] == null || this.getCommentPrefixes()[0].isEmpty() ? Prefix.CSV_COMMENT.getPrefix() : this.getCommentPrefixes()[0];
        return theCommentPrefix + " " + aLine;
    }
}

