/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.textual.Case;
import org.refcodes.textual.CaseStyleBuilder;

public enum CaseStyle {
    NONE(null),
    CAMEL_CASE(new CaseStyleBuilder()),
    PASCAL_CASE(new CaseStyleBuilder()),
    SNAKE_CASE(new CaseStyleBuilder().withCase(Case.LOWER)),
    KEBAB_CASE(new CaseStyleBuilder().withCase(Case.LOWER)),
    SNAKE_UPPER_CASE(new CaseStyleBuilder().withCase(Case.UPPER)),
    KEBAB_UPPER_CASE(new CaseStyleBuilder().withCase(Case.UPPER));

    private CaseStyleBuilder _caseStyleBuilder;

    private CaseStyle(CaseStyleBuilder aCaseStyleBuilder) {
        this._caseStyleBuilder = aCaseStyleBuilder;
    }

    public String toCaseStyle(String aText) {
        switch (this) {
            case CAMEL_CASE: {
                return this._caseStyleBuilder.toCamelCase(aText);
            }
            case KEBAB_CASE: {
                return this._caseStyleBuilder.toKebabCase(aText);
            }
            case KEBAB_UPPER_CASE: {
                return this._caseStyleBuilder.toKebabCase(aText);
            }
            case PASCAL_CASE: {
                return this._caseStyleBuilder.toPascalCase(aText);
            }
            case SNAKE_CASE: {
                return this._caseStyleBuilder.toSnakeCase(aText);
            }
            case SNAKE_UPPER_CASE: {
                return this._caseStyleBuilder.toSnakeCase(aText);
            }
        }
        return aText;
    }
}

