/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.refcodes.data.Delimiter;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnFactory;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderImpl;
import org.refcodes.tabular.Record;
import org.refcodes.time.DateFormats;

public final class TabularUtility {
    private TabularUtility() {
    }

    public static <T> Header<T> toHeader(String[] aColumnKeys, ColumnFactory<T> aColumnFactory) {
        return TabularUtility.toHeader(Arrays.asList(aColumnKeys), aColumnFactory);
    }

    public static <T> Header<T> toHeader(Collection<String> aColumnKeys, ColumnFactory<T> aColumnFactory) {
        Column[] theColumns = new Column[aColumnKeys.size()];
        Iterator<String> e = aColumnKeys.iterator();
        int i = 0;
        while (e.hasNext()) {
            theColumns[i] = aColumnFactory.create(e.next());
            ++i;
        }
        return new HeaderImpl(theColumns);
    }

    public static String toString(Record<?> aRecord) {
        return TabularUtility.toString(aRecord, Delimiter.CSV.getChar(), DateFormats.DEFAULT_DATE_FORMATS.getDateFormats());
    }

    public static String toString(Record<?> aRecord, char aSeparator, DateTimeFormatter[] aDateFormats) {
        StringBuilder theBuffer = new StringBuilder();
        Iterator e = aRecord.keySet().iterator();
        while (e.hasNext()) {
            String eKey = (String)e.next();
            theBuffer.append(eKey);
            theBuffer.append('=');
            Object eValue = aRecord.get(eKey);
            if (eValue instanceof Date) {
                Instant theInstant = Instant.ofEpochMilli(((Date)eValue).getTime());
                theBuffer.append(aDateFormats[0].format(theInstant));
            } else if (eValue != null) {
                theBuffer.append(TabularUtility.toString(eValue));
            }
            if (!e.hasNext()) continue;
            theBuffer.append(aSeparator);
        }
        return theBuffer.toString();
    }

    public static String toSeparatedValues(Record<?> aRecord) {
        return TabularUtility.toSeparatedValues(aRecord, Delimiter.CSV.getChar());
    }

    public static String toSeparatedValues(Record<?> aRecord, char aDelimiter) {
        StringBuilder theBuffer = new StringBuilder();
        Iterator e = aRecord.keySet().iterator();
        while (e.hasNext()) {
            String eKey = (String)e.next();
            theBuffer.append(eKey);
            theBuffer.append('=');
            Object eValue = aRecord.get(eKey);
            if (eValue != null) {
                theBuffer.append(TabularUtility.toString(eValue));
            }
            if (!e.hasNext()) continue;
            theBuffer.append(aDelimiter);
        }
        return theBuffer.toString();
    }

    private static Object toString(Object aValue) {
        if (aValue instanceof Object[]) {
            Object[] theValues = (Object[])aValue;
            String[] theResult = new String[theValues.length];
            for (int i = 0; i < theValues.length; ++i) {
                theResult[i] = theValues[i].toString();
            }
            return theResult;
        }
        return aValue.toString();
    }
}

