/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.refcodes.io.RowWriter;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.TypeUtility;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderAccessor;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.Record;

public interface RecordWriter<T>
extends RowWriter<T[]>,
HeaderAccessor<T> {
    public void parseHeader(String ... var1);

    public void writeHeader(String ... var1);

    public void writeHeader(Header<T> var1);

    public void writeHeader();

    @Override
    public void writeNext(T ... var1);

    default public <TYPE> void writeNextType(TYPE aRecord) {
        ArrayList<Object> theRow;
        Header theHeader = this.getHeader();
        if (theHeader != null) {
            Map<String, Object> theRecord = TypeUtility.toMap(aRecord);
            theRow = new ArrayList<Object>();
            for (Column eColumn : theHeader.values()) {
                Object eValue = theRecord.get(eColumn.getKey());
                if (eValue != null) {
                    if (eColumn.getType().isAssignableFrom(eValue.getClass())) {
                        theRow.add(eValue);
                        continue;
                    }
                    if (eColumn.getType().isAssignableFrom(String.class)) {
                        String eStringValue = SimpleType.fromSimpleType(eValue);
                        if (eStringValue == null) {
                            eValue = eValue.toString();
                        }
                        theRow.add(eStringValue);
                        continue;
                    }
                    throw new IllegalArgumentException("For the key <" + (String)eColumn.getKey() + "> the value " + (eValue instanceof String ? "\"" : "<") + eValue + (eValue instanceof String ? "\"" : ">") + " (" + eValue.getClass().getName() + ") is not of the required type <" + eColumn.getType().getName() + ">!");
                }
                theRow.add(null);
            }
        } else {
            throw new IllegalStateException("In order to use this method you must have configured / initialized a Header instance.");
        }
        this.writeNext(theRow.toArray());
    }

    default public <TYPE> void writeNextLine(String ... aRecord) throws ColumnMismatchException, HeaderMismatchException, ParseException {
        Header theHeader = this.getHeader();
        if (theHeader == null) {
            throw new IllegalStateException("In order to use this method you must have configured / initialized a Header instance.");
        }
        this.writeNext(theHeader.toRecord(aRecord));
    }

    @Override
    public void writeNext(Record<T> var1) throws ColumnMismatchException, HeaderMismatchException;
}

