/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.tabular.AbstractColumn;

public class EnumColumn<T extends Enum<T>>
extends AbstractColumn<T> {
    public EnumColumn(String aKey, Class<T> aType) {
        super(aKey, aType);
    }

    @Override
    public String[] toStorageStrings(T aValue) {
        if (aValue instanceof AliasAccessor) {
            return new String[]{((AliasAccessor)aValue).getAlias()};
        }
        return new String[]{((Enum)aValue).name()};
    }

    @Override
    public T fromStorageStrings(String[] aStringValues) throws ParseException {
        if (aStringValues == null || aStringValues.length == 0) {
            return null;
        }
        if (aStringValues.length == 1) {
            if (aStringValues[0] == null) {
                return null;
            }
            try {
                return Enum.valueOf(this.getType(), aStringValues[0]);
            }
            catch (Exception exception) {
                if (AliasAccessor.class.isAssignableFrom(this.getType())) {
                    for (Enum eValue : (Enum[])this.getType().getEnumConstants()) {
                        if (!aStringValues[0].equals(((AliasAccessor)((Object)eValue)).getAlias())) continue;
                        return (T)eValue;
                    }
                }
                try {
                    return (T)((Enum[])this.getType().getEnumConstants())[Integer.parseInt(aStringValues[0])];
                }
                catch (NumberFormatException e) {
                    throw new ParseException("The value \"" + aStringValues[0] + "\" cannot be converted to the type <" + this.getType().getName() + ">!", 0);
                }
            }
        }
        throw new IllegalArgumentException("The type <" + this.getType().getName() + "> is not an array type though the number of elements in the provided string array is <" + aStringValues.length + "> whereas only one element is being expected.");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

