/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Text;
import org.refcodes.exception.Trap;
import org.refcodes.io.ZipUtility;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnFactory;
import org.refcodes.tabular.FieldImpl;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderImpl;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordImpl;
import org.refcodes.tabular.RecordReader;
import org.refcodes.tabular.StringColumnFactory;
import org.refcodes.tabular.TabularUtility;
import org.refcodes.textual.CsvBuilder;
import org.refcodes.textual.CsvEscapeMode;
import org.refcodes.textual.CsvMixin;

public class CsvRecordReader<T>
implements CsvMixin,
RecordReader<T> {
    private Header<T> _header = null;
    private BufferedReader _reader;
    private String _nextLine;
    private int _line = -1;
    private boolean _isStrict;
    private long _erroneousRecordCount = 0L;
    private CsvBuilder _csvBuilder;
    private ColumnFactory<T> _columnFactory;
    private String[] _commentPrefixes = null;

    public CsvRecordReader(Header<T> aHeader, File aCsvFile) throws IOException {
        this(aHeader, null, ZipUtility.toInputStream(aCsvFile), null, Delimiter.CSV.getChar(), true);
    }

    public CsvRecordReader(Header<T> aHeader, File aCsvFile, char aCsvSeparator) throws IOException {
        this(aHeader, null, ZipUtility.toInputStream(aCsvFile), null, aCsvSeparator, true);
    }

    public CsvRecordReader(Header<T> aHeader, File aCsvFile, boolean isStrict) throws IOException {
        this(aHeader, null, ZipUtility.toInputStream(aCsvFile), null, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvRecordReader(Header<T> aHeader, File aCsvFile, char aCsvSeparator, boolean isStrict) throws IOException {
        this(aHeader, null, ZipUtility.toInputStream(aCsvFile), null, aCsvSeparator, isStrict);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, File aCsvFile) throws IOException {
        this(null, aColumnFactory, ZipUtility.toInputStream(aCsvFile), null, Delimiter.CSV.getChar(), true);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, File aCsvFile, char aCsvSeparator) throws IOException {
        this(null, aColumnFactory, ZipUtility.toInputStream(aCsvFile), null, aCsvSeparator, true);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, File aCsvFile, boolean isStrict) throws IOException {
        this(null, aColumnFactory, ZipUtility.toInputStream(aCsvFile), null, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, File aCsvFile, char aCsvSeparator, boolean isStrict) throws IOException {
        this(null, aColumnFactory, ZipUtility.toInputStream(aCsvFile), null, aCsvSeparator, isStrict);
    }

    public CsvRecordReader(Header<T> aHeader, InputStream aCsvInputStream) throws IOException {
        this(aHeader, null, aCsvInputStream, null, Delimiter.CSV.getChar(), true);
    }

    public CsvRecordReader(Header<T> aHeader, InputStream aCsvInputStream, boolean isStrict) throws IOException {
        this(aHeader, null, aCsvInputStream, null, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvRecordReader(Header<T> aHeader, InputStream aCsvInputStream, char aCsvDelimiter) throws IOException {
        this(aHeader, null, aCsvInputStream, null, aCsvDelimiter, true);
    }

    public CsvRecordReader(Header<T> aHeader, InputStream aCsvInputStream, char aCsvDelimiter, boolean isStrict) throws IOException {
        this(aHeader, null, aCsvInputStream, null, aCsvDelimiter, isStrict);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, null, Delimiter.CSV.getChar(), true);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, boolean isStrict) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, null, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, char aCsvDelimiter) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, null, aCsvDelimiter, true);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, char aCsvDelimiter, boolean isStrict) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, null, aCsvDelimiter, isStrict);
    }

    public CsvRecordReader(Header<T> aHeader, File aCsvFile, Charset aEncoding) throws IOException {
        this(aHeader, null, ZipUtility.toInputStream(aCsvFile), aEncoding, Delimiter.CSV.getChar(), true);
    }

    public CsvRecordReader(Header<T> aHeader, File aCsvFile, Charset aEncoding, char aCsvSeparator) throws IOException {
        this(aHeader, null, ZipUtility.toInputStream(aCsvFile), aEncoding, aCsvSeparator, true);
    }

    public CsvRecordReader(Header<T> aHeader, File aCsvFile, Charset aEncoding, boolean isStrict) throws IOException {
        this(aHeader, null, ZipUtility.toInputStream(aCsvFile), aEncoding, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvRecordReader(Header<T> aHeader, File aCsvFile, Charset aEncoding, char aCsvSeparator, boolean isStrict) throws IOException {
        this(aHeader, null, ZipUtility.toInputStream(aCsvFile), aEncoding, aCsvSeparator, isStrict);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, File aCsvFile, Charset aEncoding) throws IOException {
        this(null, aColumnFactory, ZipUtility.toInputStream(aCsvFile), aEncoding, Delimiter.CSV.getChar(), true);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, File aCsvFile, Charset aEncoding, char aCsvSeparator) throws IOException {
        this(null, aColumnFactory, ZipUtility.toInputStream(aCsvFile), aEncoding, aCsvSeparator, true);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, File aCsvFile, Charset aEncoding, boolean isStrict) throws IOException {
        this(null, aColumnFactory, ZipUtility.toInputStream(aCsvFile), aEncoding, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, File aCsvFile, Charset aEncoding, char aCsvSeparator, boolean isStrict) throws IOException {
        this(null, aColumnFactory, ZipUtility.toInputStream(aCsvFile), aEncoding, aCsvSeparator, isStrict);
    }

    public CsvRecordReader(Header<T> aHeader, InputStream aCsvInputStream, Charset aEncoding) throws IOException {
        this(aHeader, null, aCsvInputStream, aEncoding, Delimiter.CSV.getChar(), true);
    }

    public CsvRecordReader(Header<T> aHeader, InputStream aCsvInputStream, Charset aEncoding, boolean isStrict) throws IOException {
        this(aHeader, null, aCsvInputStream, aEncoding, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvRecordReader(Header<T> aHeader, InputStream aCsvInputStream, Charset aEncoding, char aCsvDelimiter) throws IOException {
        this(aHeader, null, aCsvInputStream, aEncoding, aCsvDelimiter, true);
    }

    public CsvRecordReader(Header<T> aHeader, InputStream aCsvInputStream, Charset aEncoding, char aCsvDelimiter, boolean isStrict) throws IOException {
        this(aHeader, null, aCsvInputStream, aEncoding, aCsvDelimiter, isStrict);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, Charset aEncoding) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, aEncoding, Delimiter.CSV.getChar(), true);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, Charset aEncoding, boolean isStrict) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, aEncoding, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, Charset aEncoding, char aCsvDelimiter) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, aEncoding, aCsvDelimiter, true);
    }

    public CsvRecordReader(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, Charset aEncoding, char aCsvDelimiter, boolean isStrict) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, aEncoding, aCsvDelimiter, isStrict);
    }

    protected CsvRecordReader(Header<T> aHeader, ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, Charset aEncoding, char aCsvDelimiter, boolean isStrict) throws IOException {
        this._csvBuilder = new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withDelimiter(aCsvDelimiter);
        this._isStrict = isStrict;
        BufferedReader bufferedReader = this._reader = aEncoding != null ? new BufferedReader(new InputStreamReader(aCsvInputStream, aEncoding)) : new BufferedReader(new InputStreamReader(aCsvInputStream));
        if (aHeader == null && aColumnFactory == null) {
            throw new IllegalArgumentException("You must provide either a header or a column factory, but none was provided.");
        }
        this._header = aHeader;
        this._columnFactory = aColumnFactory;
        this.readNextLine();
    }

    @Override
    public Header<T> readHeader() throws IOException {
        return this.readHeader(this._header);
    }

    @Override
    public Header<T> readHeader(Column<T> ... aColumns) throws IOException {
        return this.readHeader(new HeaderImpl<T>(aColumns));
    }

    @Override
    public Header<T> readHeader(Header<T> aHeader) throws IOException {
        if (this._nextLine == null) {
            this.readNextLine();
            if (this._nextLine != null) {
                throw new IOException("Cannot read Header as there are no lines which can be read anymore.");
            }
        }
        String[] theHeaderKeys = this._csvBuilder.toFields(this._nextLine);
        Header<Object> theHeader = this._columnFactory != null ? TabularUtility.toHeader(theHeaderKeys, this._columnFactory) : TabularUtility.toHeader(theHeaderKeys, new StringColumnFactory());
        this._header = this.toHeader(theHeader, aHeader);
        this._columnFactory = null;
        this.readNextLine();
        return this._header;
    }

    @Override
    public String skipHeader() throws IOException {
        String currentLine = this._nextLine;
        this.readNextLine();
        return currentLine;
    }

    @Override
    public boolean hasNext() {
        if (this._header == null) {
            try {
                this.readHeader();
            }
            catch (IOException e) {
                return false;
            }
        }
        return this._nextLine != null;
    }

    @Override
    public String[] nextRow() {
        Object theRecord = this.next();
        String[] theNext = new String[theRecord.size()];
        for (int i = 0; i < theNext.length; ++i) {
            Column column = (Column)this._header.get(i);
            Object eValue = theRecord.get(column.getKey());
            theNext[i] = column.toStorageString_(eValue);
        }
        return theNext;
    }

    @Override
    public <TYPE> TYPE nextType(Class<TYPE> aClass) {
        try {
            return this.next().toType(aClass);
        }
        catch (Exception e) {
            ++this._erroneousRecordCount;
            throw new NoSuchElementException("An exception of type \"" + e.getClass().getName() + "\" at line <" + this._line + "> occurred while parsing for type <" + aClass.getName() + ">", e);
        }
    }

    @Override
    public String nextRaw() {
        String theRawLine = this._nextLine;
        if (this._nextLine == null || this._header == null) {
            throw new NoSuchElementException("There is no more element beyond line <" + this._line + "> in this iterator.");
        }
        try {
            this.readNextLine();
        }
        catch (IOException e) {
            this._nextLine = null;
        }
        if (!this.hasNext()) {
            try {
                this._reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return theRawLine;
    }

    @Override
    public Record<T> next() {
        if (this._header == null) {
            try {
                this.readHeader();
            }
            catch (IOException e) {
                throw new NoSuchElementException("An exception of type \"" + e.getClass().getName() + "\" at line <" + this._line + "> occurred while probing for a header, the line is \"" + this._nextLine + "\": " + Trap.asMessage(e));
            }
        }
        if (this._nextLine == null || this._header == null) {
            throw new NoSuchElementException("There is no more element beyond line <" + this._line + "> in this iterator.");
        }
        ArrayList theItems = new ArrayList();
        String[] theValues = this._csvBuilder.toFields(this._nextLine);
        Object eValue = null;
        int theSize = this._header.size() <= theValues.length ? this._header.size() : theValues.length;
        for (int i = 0; i < theSize; ++i) {
            Column eColumn;
            block22: {
                eValue = null;
                String eString = theValues[i];
                eColumn = (Column)this._header.get(i);
                try {
                    if (eColumn.getType().isArray()) {
                        List<String> eStringList = new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withRecord(eString).withDelimiter(Delimiter.ARRAY.getChar()).toFields();
                        String[] eStringValues = eStringList.toArray(new String[eStringList.size()]);
                        eValue = eColumn.fromStorageStrings(eStringValues);
                    } else {
                        String eStringValue = eString;
                        eValue = eColumn.fromStorageString(eStringValue);
                    }
                }
                catch (ParseException e) {
                    ++this._erroneousRecordCount;
                    if (this._isStrict) {
                        throw new NoSuchElementException("A parse exception at line <" + this._line + "> occurred while parsing the value \"" + eString + "\" for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + ")\", the line is \"" + this._nextLine + "\": " + Trap.asMessage(e));
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    ++this._erroneousRecordCount;
                    if (this._isStrict) {
                        throw new NoSuchElementException("An index out of bounds exception at line <" + this._line + "> occurred while parsing the value for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + "), the line is \"" + this._nextLine + "\": " + Trap.asMessage(e));
                    }
                }
                catch (UnsupportedOperationException e) {
                    ++this._erroneousRecordCount;
                    if (this._isStrict) {
                        throw new NoSuchElementException("An unsupported operation exception at line <" + this._line + "> occurred while parsing the value for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + "), the line is \"" + this._nextLine + "\": " + Trap.asMessage(e));
                    }
                }
                catch (NumberFormatException e) {
                    ++this._erroneousRecordCount;
                    if (this._isStrict) {
                        throw new NoSuchElementException("A number format exception exception at line <" + this._line + "> occurred while parsing the value for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + "), the line is \"" + this._nextLine + "\": " + Trap.asMessage(e));
                    }
                }
                catch (Exception e) {
                    ++this._erroneousRecordCount;
                    if (!this._isStrict) break block22;
                    throw new NoSuchElementException("An exception of type \"" + e.getClass().getName() + "\" at line <" + this._line + "> occurred while parsing the value for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + "), the line is \"" + this._nextLine + "\": " + Trap.asMessage(e));
                }
            }
            theItems.add(new FieldImpl<Object>((String)eColumn.getKey(), eValue));
        }
        RecordImpl theRecord = new RecordImpl(theItems);
        try {
            this.readNextLine();
        }
        catch (IOException e) {
            this._nextLine = null;
        }
        if (!this.hasNext()) {
            try {
                this._reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return theRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    @Override
    public Header<T> getHeader() {
        if (this._header == null) {
            try {
                this.readHeader();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this._header;
    }

    @Override
    public void setCommentPrefixes(String ... aCommentPrefixes) {
        this._commentPrefixes = aCommentPrefixes;
    }

    @Override
    public String[] getCommentPrefixes() {
        return this._commentPrefixes;
    }

    @Override
    public void clearCommentPrefixes() {
        this._commentPrefixes = null;
    }

    @Override
    public CsvRecordReader<T> withCommentPrefixes(String ... aCommentPrefixes) {
        this.setCommentPrefixes(aCommentPrefixes);
        return this;
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
    }

    @Override
    public CsvEscapeMode getCsvEscapeMode() {
        return this._csvBuilder.getCsvEscapeMode();
    }

    @Override
    public boolean isTrim() {
        return this._csvBuilder.isTrim();
    }

    @Override
    public char getDelimiter() {
        return this._csvBuilder.getDelimiter();
    }

    @Override
    public void setTrim(boolean isTrim) {
        this._csvBuilder.setTrim(isTrim);
    }

    @Override
    public void setDelimiter(char aCsvDelimiter) {
        this._csvBuilder.setDelimiter(aCsvDelimiter);
    }

    @Override
    public CsvRecordReader<T> withTrim(boolean isTrim) {
        this._csvBuilder.setTrim(isTrim);
        return this;
    }

    @Override
    public CsvRecordReader<T> withCsvEscapeMode(CsvEscapeMode aCsvEscapeMode) {
        this._csvBuilder.setCsvEscapeMode(aCsvEscapeMode);
        return this;
    }

    @Override
    public CsvRecordReader<T> withDelimiter(char aCsvDelimiter) {
        this._csvBuilder.setDelimiter(aCsvDelimiter);
        return this;
    }

    @Override
    public void setCsvEscapeMode(CsvEscapeMode aCsvEscapeMode) {
        this._csvBuilder.setCsvEscapeMode(aCsvEscapeMode);
    }

    @Override
    public long getErroneousRecordCount() {
        return this._erroneousRecordCount;
    }

    private void readNextLine() throws IOException {
        this._nextLine = this._reader.readLine();
        if (this._nextLine != null) {
            ++this._line;
            while (this._nextLine != null && (this.isComment(this._nextLine) || this._nextLine.length() == 0)) {
                this._nextLine = this._reader.readLine();
                ++this._line;
            }
        }
    }
}

