/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.refcodes.data.Encoding;
import org.refcodes.data.MarshalParameter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.ext.factory.AbstractCanonicalMapFactory;
import org.refcodes.struct.ext.factory.XmlCanonicalMapFactory;

public class HtmlCanonicalMapFactory
extends AbstractCanonicalMapFactory {
    public static final String BODY = "body";
    public static final String HEAD = "head";
    public static final String HTML = "html";
    public static final String[] ROOT_SELECTOR = new String[]{"html", "body"};
    public static final String COMMENT_OPEN = "<!--";
    public static final String COMMENT_CLOSE = "-->";

    @Override
    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation) throws UnmarshalException {
        return this.fromMarshaled(aExternalRepresentation, (Map<String, String>)null);
    }

    @Override
    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation, Map<String, String> aProperties) throws UnmarshalException {
        char theDelimiter = this.toDelimiter(aProperties, PathMap.DELIMITER);
        try {
            String theBaseUri;
            String theCharsetName;
            String string = theCharsetName = aProperties != null ? aProperties.get(MarshalParameter.CHARSET.getName()) : null;
            if (theCharsetName == null) {
                theCharsetName = Encoding.UTF_8.getCode();
            }
            String string2 = theBaseUri = aProperties != null ? aProperties.get(MarshalParameter.BASE_URL.getName()) : null;
            if (theBaseUri == null) {
                theBaseUri = "";
            }
            CanonicalMapBuilderImpl theCanonicalMap = new CanonicalMapBuilderImpl(theDelimiter);
            Parser theParser = Parser.htmlParser();
            theParser.settings(new ParseSettings(true, true));
            Document theDocument = Jsoup.parse(aExternalRepresentation, theCharsetName, theBaseUri, theParser);
            Elements theElements = theDocument.children();
            this.visitElements(theCanonicalMap, theElements, theCanonicalMap.getRootPath(), theDelimiter);
            this.postProcess(theCanonicalMap);
            return theCanonicalMap;
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from input stream <" + aExternalRepresentation + ">!", e);
        }
    }

    @Override
    public CanonicalMap.CanonicalMapBuilder toUnmarshaled(String aExternalRepresentation, Map<String, String> aProperties) throws UnmarshalException {
        char theDelimiter = this.toDelimiter(aProperties, PathMap.DELIMITER);
        try {
            String theBaseUri = null;
            if (aProperties != null) {
                theBaseUri = aProperties.get(MarshalParameter.BASE_URL.getName());
            }
            if (theBaseUri == null) {
                theBaseUri = "";
            }
            CanonicalMapBuilderImpl theCanonicalMap = new CanonicalMapBuilderImpl(theDelimiter);
            Parser theParser = Parser.htmlParser();
            theParser.settings(new ParseSettings(true, true));
            Document doc = Jsoup.parse(aExternalRepresentation, theBaseUri, theParser);
            Elements theElements = doc.children();
            this.visitElements(theCanonicalMap, theElements, theCanonicalMap.getRootPath(), theDelimiter);
            this.postProcess(theCanonicalMap);
            return theCanonicalMap;
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the external representation \"" + aExternalRepresentation + "\"!", e);
        }
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.toMarshaled(aDataStructure, (Map<String, String>)null);
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        boolean isWellFormedHtml;
        block5: {
            String theRoot;
            isWellFormedHtml = false;
            Set<String> eDirs = aDataStructure.dirs();
            Set<String> eLeaves = aDataStructure.leaves();
            if (eDirs.size() == 1 && eLeaves.size() == 0 && HTML.equalsIgnoreCase(theRoot = eDirs.iterator().next()) && (eDirs = aDataStructure.children(theRoot)).size() >= 1 && eDirs.size() <= 2) {
                for (String eDir : eDirs) {
                    if (HEAD.equalsIgnoreCase(eDir) || BODY.equalsIgnoreCase(eDir)) continue;
                    break block5;
                }
                isWellFormedHtml = true;
            }
        }
        if (!isWellFormedHtml) {
            aDataStructure = aDataStructure.retrieveTo(ROOT_SELECTOR);
        }
        String theXml = XmlCanonicalMapFactory.toXml(aDataStructure);
        Object theHead = "";
        String theComment = this.toComment(aProperties);
        if (theComment != null && theComment.length() > 0) {
            String[] theLines;
            for (String eLine : theLines = theComment.split("\\r?\\n")) {
                theHead = (String)theHead + "<!-- " + eLine + " -->" + System.lineSeparator();
            }
        }
        return (String)theHead + theXml;
    }

    @Override
    public InputStream fromUnmarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.fromUnmarshaled(aDataStructure, (Map<String, String>)null);
    }

    @Override
    public InputStream fromUnmarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        String theMarshaled = this.toMarshaled(aDataStructure, aProperties);
        ByteArrayInputStream theMarshalledStream = new ByteArrayInputStream(theMarshaled.getBytes());
        return theMarshalledStream;
    }

    private void visitElements(CanonicalMap.CanonicalMapBuilder aCanonicalMap, Elements elements, String aPath, char aDelimiter) {
        for (Element eElement : elements) {
            String ePath = aCanonicalMap.toPath(aPath, eElement.nodeName());
            int next = this.toAttributeIndex(eElement.attributes());
            String eValue = null;
            if (eElement.hasText()) {
                eValue = eElement.ownText();
            }
            if ((eValue == null || eValue.isEmpty()) && eElement.val() != null && eElement.val().length() != 0) {
                eValue = eElement.val();
            }
            if ((eValue == null || eValue.isEmpty()) && eElement.data() != null && eElement.data().length() != 0) {
                eValue = eElement.data();
            }
            if (eValue != null && eValue.trim().isEmpty()) {
                eValue = null;
            }
            if (eValue != null) {
                if (next != -1) {
                    aCanonicalMap.putValueAt(ePath, next, eValue);
                } else if (aCanonicalMap.isArray(ePath)) {
                    next = aCanonicalMap.nextArrayIndex(ePath);
                    aCanonicalMap.putValueAt(ePath, next, eValue);
                } else if (aCanonicalMap.containsKey((Object)ePath)) {
                    aCanonicalMap.putValueAt(ePath, 1, eValue);
                    eValue = (String)aCanonicalMap.remove((Object)ePath);
                    aCanonicalMap.putValueAt(ePath, 0, eValue);
                } else {
                    aCanonicalMap.put(ePath, eValue);
                }
            }
            if (next != -1) {
                ePath = aCanonicalMap.toPath(ePath, next);
            }
            this.visitAttributes(aCanonicalMap, eElement.attributes(), ePath, aDelimiter);
            this.visitElements(aCanonicalMap, eElement.children(), ePath, aDelimiter);
        }
    }

    private int toAttributeIndex(Attributes aAttribs) {
        int index = -1;
        if (aAttribs != null) {
            try {
                for (Attribute eAttrib : aAttribs) {
                    if (!"index".equals(eAttrib.getKey())) continue;
                    return Integer.parseInt(eAttrib.getValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private void visitAttributes(CanonicalMap.CanonicalMapBuilder aCanonicalMap, Attributes aAttribs, String aPath, char aDelimiter) {
        for (Attribute eAttrib : aAttribs) {
            if ("index".equals(eAttrib.getKey())) continue;
            aCanonicalMap.put(new String[]{aPath, PathMap.ANNOTATOR + eAttrib.getKey()}, eAttrib.getValue());
        }
    }
}

