/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.refcodes.struct.Range;

public class RangeImpl<V extends Number>
implements Range<V> {
    protected V _minValue = null;
    protected V _maxValue = null;

    protected RangeImpl() {
    }

    RangeImpl(String aRange, Class<V> aType) {
        int index = aRange.indexOf(45);
        if (index == -1) {
            throw new IllegalArgumentException("The range <" + aRange + "> must be separated by a '-' (minus) symbol!");
        }
        String theMin = aRange.substring(0, index);
        String theMax = aRange.substring(index + 1);
        try {
            Method method = aType.getMethod("valueOf", String.class);
            this._minValue = (Number)method.invoke(null, theMin);
            this._maxValue = (Number)method.invoke(null, theMax);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Creating range for type <" + aType.getName() + "> with range <" + aRange + "> failed when invoking the \"valueOf\" method with <" + theMin + "> and/or <" + theMax + ">!", e);
        }
    }

    public RangeImpl(V aMinValue, V aMaxValue) {
        this._minValue = aMinValue;
        this._maxValue = aMaxValue;
    }

    @Override
    public V getMinValue() {
        return this._minValue;
    }

    @Override
    public V getMaxValue() {
        return this._maxValue;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [minValue=" + this._minValue + ", maxValue=" + this._maxValue + "]";
    }

    public static class RangeBuilderImpl<V extends Number>
    extends RangeImpl<V>
    implements Range.RangeBuilder<V> {
        public RangeBuilderImpl() {
        }

        public RangeBuilderImpl(V aMinValue, V aMaxValue) {
            super(aMinValue, aMaxValue);
        }

        @Override
        public void setMinValue(V aMinValue) {
            this._minValue = aMinValue;
        }

        @Override
        public void setMaxValue(V aMaxValue) {
            this._maxValue = aMaxValue;
        }
    }
}

