/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Delimiter;
import org.refcodes.struct.CanonicalMapImpl;
import org.refcodes.struct.InterOperableMap;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;

public interface CanonicalMap
extends InterOperableMap<String> {
    default public String[] asArray(Object aKey) {
        return this.asArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public String[] asArray(Object aKey, char aDelimiter) {
        return this.asArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public String[] asArray(String aKey) {
        return this.asArray(aKey, Delimiter.LIST.getChar());
    }

    default public String[] asArray(String aKey, char aDelimiter) {
        String[] theArray = null;
        String theValue = (String)this.get((Object)aKey);
        if (theValue != null && theValue.length() != 0) {
            theArray = theValue.split(Pattern.quote("" + aDelimiter));
        }
        return theArray;
    }

    default public boolean[] asBooleanArray(Object aKey) {
        return this.asBooleanArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public boolean[] asBooleanArray(Object aKey, char aDelimiter) {
        return this.asBooleanArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public boolean[] asBooleanArray(String aKey) {
        return this.asBooleanArray(aKey, Delimiter.LIST.getChar());
    }

    default public boolean[] asBooleanArray(String aKey, char aDelimiter) {
        boolean[] theBooleanArray = null;
        Object[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theBooleanArray = new boolean[theArray.length];
            block0: for (int i = 0; i < theArray.length; ++i) {
                for (String eTrue : BooleanLiterals.TRUE.getNames()) {
                    if (!eTrue.equalsIgnoreCase(theArray[i].trim())) continue;
                    theBooleanArray[i] = true;
                    continue block0;
                }
                for (String eFalse : BooleanLiterals.FALSE.getNames()) {
                    if (!eFalse.equalsIgnoreCase(((String)theArray[i]).trim())) continue;
                    theBooleanArray[i] = false;
                    continue block0;
                }
                throw new NumberFormatException("Unable to parse boolean from key <" + aKey + "> using delimiter '" + aDelimiter + "' at position <" + i + "> of the array <" + Arrays.toString(theArray) + ">!");
            }
        }
        return theBooleanArray;
    }

    default public byte[] asByteArray(Object aKey) {
        return this.asByteArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public byte[] asByteArray(Object aKey, char aDelimiter) {
        return this.asByteArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public byte[] asByteArray(String aKey) {
        return this.asByteArray(aKey, Delimiter.LIST.getChar());
    }

    default public byte[] asByteArray(String aKey, char aDelimiter) {
        byte[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new byte[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.endsWith(".0")) {
                    eValue = eValue.substring(0, eValue.length() - 2);
                }
                theToArray[i] = Byte.valueOf(eValue);
            }
        }
        return theToArray;
    }

    default public char[] asCharArray(Object aKey) {
        return this.asCharArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public char[] asCharArray(Object aKey, char aDelimiter) {
        return this.asCharArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public char[] asCharArray(String aKey) {
        return this.asCharArray(aKey, Delimiter.LIST.getChar());
    }

    default public char[] asCharArray(String aKey, char aDelimiter) {
        char[] theToArray = null;
        Object[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new char[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.isEmpty()) {
                    eValue = theArray[i];
                }
                if (eValue.length() != 1) {
                    throw new NumberFormatException("Unable to convert from key <" + aKey + "> using delimiter '" + aDelimiter + "' at position <" + i + "> of the array <" + Arrays.toString(theArray) + ">!");
                }
                theToArray[i] = eValue.charAt(0);
            }
        }
        return theToArray;
    }

    default public double[] asDoubleArray(Object aKey) {
        return this.asDoubleArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public double[] asDoubleArray(Object aKey, char aDelimiter) {
        return this.asDoubleArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public double[] asDoubleArray(String aKey) {
        return this.asDoubleArray(aKey, Delimiter.LIST.getChar());
    }

    default public double[] asDoubleArray(String aKey, char aDelimiter) {
        double[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new double[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                theToArray[i] = Double.valueOf(theArray[i].trim());
            }
        }
        return theToArray;
    }

    default public float[] asFloatArray(Object aKey) {
        return this.asFloatArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public float[] asFloatArray(Object aKey, char aDelimiter) {
        return this.asFloatArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public float[] asFloatArray(String aKey) {
        return this.asFloatArray(aKey, Delimiter.LIST.getChar());
    }

    default public float[] asFloatArray(String aKey, char aDelimiter) {
        float[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new float[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                theToArray[i] = Float.valueOf(theArray[i].trim()).floatValue();
            }
        }
        return theToArray;
    }

    default public int[] asIntArray(Object aKey) {
        return this.asIntArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public int[] asIntArray(Object aKey, char aDelimiter) {
        return this.asIntArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public int[] asIntArray(String aKey) {
        return this.asIntArray(aKey, Delimiter.LIST.getChar());
    }

    default public int[] asIntArray(String aKey, char aDelimiter) {
        int[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new int[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.endsWith(".0")) {
                    eValue = eValue.substring(0, eValue.length() - 2);
                }
                theToArray[i] = Integer.valueOf(eValue);
            }
        }
        return theToArray;
    }

    default public long[] asLongArray(Object aKey) {
        return this.asLongArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public long[] asLongArray(Object aKey, char aDelimiter) {
        return this.asLongArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public long[] asLongArray(String aKey) {
        return this.asLongArray(aKey, Delimiter.LIST.getChar());
    }

    default public long[] asLongArray(String aKey, char aDelimiter) {
        long[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new long[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.endsWith(".0")) {
                    eValue = eValue.substring(0, eValue.length() - 2);
                }
                theToArray[i] = Long.valueOf(eValue);
            }
        }
        return theToArray;
    }

    default public short[] asShortArray(Object aKey) {
        return this.asShortArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public short[] asShortArray(Object aKey, char aDelimiter) {
        return this.asShortArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public short[] asShortArray(String aKey) {
        return this.asShortArray(aKey, Delimiter.LIST.getChar());
    }

    default public short[] asShortArray(String aKey, char aDelimiter) {
        short[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new short[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.endsWith(".0")) {
                    eValue = eValue.substring(0, eValue.length() - 2);
                }
                theToArray[i] = Short.valueOf(eValue);
            }
        }
        return theToArray;
    }

    @Override
    default public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    default public CanonicalMap getDirAt(String[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public CanonicalMap getDirAt(int aIndex) {
        return this.getDirAt(this.getRootPath(), aIndex);
    }

    default public CanonicalMap getDirAt(String aPath, int aIndex) {
        return this.retrieveFrom(this.toPath(aPath, Integer.toString(aIndex)));
    }

    default public CanonicalMap getDirAt(Collection<?> aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public CanonicalMap getDirAt(Object aPath, int aIndex) {
        return this.getDirAt(this.toPath(aPath), aIndex);
    }

    default public CanonicalMap getDirAt(Object[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public CanonicalMap query(Collection<?> aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public CanonicalMap query(Object ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public CanonicalMap query(Pattern aRegExp) {
        return new CanonicalMapImpl(InterOperableMap.super.query(aRegExp));
    }

    default public CanonicalMap query(String aPathQuery) {
        return new CanonicalMapImpl(InterOperableMap.super.query(aPathQuery));
    }

    default public CanonicalMap query(String ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public CanonicalMap queryBetween(Collection<?> aFromPath, Collection<?> aPathQuery, Collection<?> aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public CanonicalMap queryBetween(Object aFromPath, Object aPathQuery, Object aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public CanonicalMap queryBetween(Object[] aFromPath, Object[] aPathQuery, Object[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public CanonicalMap queryBetween(String aFromPath, Pattern aRegExp, String aToPath) {
        return new CanonicalMapImpl(InterOperableMap.super.queryBetween(aFromPath, aRegExp, aToPath));
    }

    default public CanonicalMap queryBetween(String aFromPath, String aPathQuery, String aToPath) {
        return new CanonicalMapImpl(InterOperableMap.super.queryBetween(aFromPath, aPathQuery, aToPath));
    }

    default public CanonicalMap queryBetween(String[] aFromPath, String[] aPathQuery, String[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public CanonicalMap queryFrom(Collection<?> aPathQuery, Collection<?> aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public CanonicalMap queryFrom(Object aPathQuery, Object aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public CanonicalMap queryFrom(Object[] aPathQuery, Object[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public CanonicalMap queryFrom(Pattern aRegExp, String aFromPath) {
        return new CanonicalMapImpl(InterOperableMap.super.queryFrom(aRegExp, aFromPath));
    }

    default public CanonicalMap queryFrom(String aPathQuery, String aFromPath) {
        return new CanonicalMapImpl(InterOperableMap.super.queryFrom(aPathQuery, aFromPath));
    }

    default public CanonicalMap queryFrom(String[] aPathQuery, String[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public CanonicalMap queryTo(Collection<?> aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public CanonicalMap queryTo(Object aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public CanonicalMap queryTo(Object[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public CanonicalMap queryTo(Pattern aRegExp, String aToPath) {
        return new CanonicalMapImpl(InterOperableMap.super.queryTo(aRegExp, aToPath));
    }

    default public CanonicalMap queryTo(String aPathQuery, String aToPath) {
        return new CanonicalMapImpl(InterOperableMap.super.queryTo(aPathQuery, aToPath));
    }

    default public CanonicalMap queryTo(String[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public CanonicalMap retrieveBetween(Collection<?> aFromPath, Collection<?> aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public CanonicalMap retrieveBetween(Object aFromPath, Object aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public CanonicalMap retrieveBetween(Object[] aFromPath, Object[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public CanonicalMap retrieveBetween(String aFromPath, String aToPath) {
        CanonicalMap thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public CanonicalMap retrieveBetween(String[] aFromPath, String[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public CanonicalMap retrieveFrom(Collection<?> aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public CanonicalMap retrieveFrom(Object aParentPath) {
        return this.retrieveFrom(this.toPath(aParentPath));
    }

    default public CanonicalMap retrieveFrom(Object ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    public CanonicalMap retrieveFrom(String var1);

    default public CanonicalMap retrieveFrom(String ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public CanonicalMap retrieveTo(Collection<?> aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    default public CanonicalMap retrieveTo(Object aToPath) {
        return this.retrieveTo(this.toPath(aToPath));
    }

    default public CanonicalMap retrieveTo(Object ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public CanonicalMap retrieveTo(String var1);

    default public CanonicalMap retrieveTo(String ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    default public CanonicalMap getDir(Collection<?> aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public CanonicalMap getDir(Object aPath) {
        return this.getDir(this.toPath(aPath));
    }

    default public CanonicalMap getDir(Object ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public CanonicalMap getDir(String aPath) {
        return this.retrieveFrom(aPath);
    }

    default public CanonicalMap getDir(String ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public CanonicalMap[] getDirs(Collection<?> aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public CanonicalMap[] getDirs(Object aPath) {
        return this.getDirs(this.toPath(aPath));
    }

    default public CanonicalMap[] getDirs(Object ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public CanonicalMap[] getDirs(String aPath) {
        CanonicalMap[] theDirs;
        if (this.isIndexDir(aPath)) {
            int[] theIndexes = this.getDirIndexes(aPath);
            theDirs = new CanonicalMap[theIndexes[theIndexes.length - 1] + 1];
            for (int i : theIndexes) {
                theDirs[theIndexes[i]] = this.getDirAt(aPath, theIndexes[i]);
            }
        } else {
            theDirs = new CanonicalMap[]{this.getDir(aPath)};
        }
        return theDirs;
    }

    default public CanonicalMap[] getDirs(String ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    @Override
    default public Map<String, String> toMap() {
        HashMap<String, String> theProperties = new HashMap<String, String>();
        for (String eKey : this.keySet()) {
            theProperties.put(eKey, (String)this.get((Object)eKey));
        }
        return theProperties;
    }

    default public Properties toProperties() {
        Properties theProperties = new Properties();
        for (String eKey : this.keySet()) {
            theProperties.put(this.toPropertyPath(eKey), this.get((Object)eKey));
        }
        return theProperties;
    }

    public static interface MutableCanonicalMap
    extends CanonicalMap,
    InterOperableMap.MutableInterOperableMap<String>,
    Map<String, String> {
        @Override
        default public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        default public void insert(CanonicalMap aFrom) {
            this.insert((Object)aFrom);
        }

        default public void insertBetween(String aToPath, CanonicalMap aFrom, String aFromPath) {
            this.insertBetween(aToPath, (Object)aFrom, aFromPath);
        }

        default public void insertFrom(CanonicalMap aFrom, String aFromPath) {
            this.insertFrom((Object)aFrom, aFromPath);
        }

        default public void insertTo(String aToPath, CanonicalMap aFrom) {
            this.insertTo(aToPath, (Object)aFrom);
        }

        @Override
        default public String put(Object aKey, String aValue) {
            return this.put(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null), aValue);
        }

        @Override
        default public String put(Object[] aPathElements, String aValue) {
            return this.put(this.toPath(aPathElements), aValue);
        }

        default public String put(Property aProperty) {
            return this.put((String)aProperty.getKey(), (String)aProperty.getValue());
        }

        @Override
        default public String put(Relation<String, String> aRelation) {
            return this.put((String)aRelation.getKey(), (String)aRelation.getValue());
        }

        @Override
        default public String put(String[] aPathElements, String aValue) {
            return this.put(this.toPath(aPathElements), aValue);
        }

        default public void putAll(CanonicalMap aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (String)this.get(eKey));
            }
        }

        default public void putAll(Properties aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (String)this.get(eKey));
            }
        }

        @Override
        default public void putAll(Map<? extends String, ? extends String> aProperties) {
            for (String string : aProperties.keySet()) {
                this.put(string, (String)this.get((Object)string));
            }
        }

        default public CanonicalMap putDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public CanonicalMap putDirAt(Collection<?> aPathElements, int aIndex, PathMap<String> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (PathMap)aDir);
        }

        default public CanonicalMap putDirAt(int aIndex, Object aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, aDir);
        }

        default public CanonicalMap putDirAt(int aIndex, PathMap<String> aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, (PathMap)aDir);
        }

        default public CanonicalMap putDirAt(Object aPath, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, aDir);
        }

        default public CanonicalMap putDirAt(Object aPath, int aIndex, PathMap<String> aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, (PathMap)aDir);
        }

        default public CanonicalMap putDirAt(Object[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public CanonicalMap putDirAt(Object[] aPathElements, int aIndex, PathMap<String> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (PathMap)aDir);
        }

        default public CanonicalMap putDirAt(String aPath, int aIndex, Object aDir) {
            CanonicalMap theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public CanonicalMap putDirAt(String aPath, int aIndex, PathMap<String> aDir) {
            CanonicalMap theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public CanonicalMap putDirAt(String[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public CanonicalMap putDirAt(String[] aPathElements, int aIndex, PathMap<String> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (PathMap)aDir);
        }

        default public CanonicalMap removeAll(Collection<?> aPathQueryElements) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(aPathQueryElements));
        }

        default public CanonicalMap removeAll(Object ... aPathQueryElements) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(aPathQueryElements));
        }

        default public CanonicalMap removeAll(Object aPathQuery) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(aPathQuery));
        }

        default public CanonicalMap removeAll(Pattern aRegExp) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(aRegExp));
        }

        default public CanonicalMap removeAll(String ... aPathQueryElements) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(aPathQueryElements));
        }

        default public CanonicalMap removeAll(String aPathQuery) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(aPathQuery));
        }

        default public CanonicalMap removeDirAt(int aIndex) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(aIndex));
        }

        default public CanonicalMap removeDirAt(Object aPath, int aIndex) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(aPath, aIndex));
        }

        default public CanonicalMap removeDirAt(Object[] aPathElements, int aIndex) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(aPathElements, aIndex));
        }

        default public CanonicalMap removeDirAt(String aPath, int aIndex) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(aPath, aIndex));
        }

        default public CanonicalMap removeDirAt(String[] aPathElements, int aIndex) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(aPathElements, aIndex));
        }

        default public CanonicalMap removeFrom(Collection<?> aPathElements) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(aPathElements));
        }

        default public CanonicalMap removeFrom(Object ... aPathElements) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(aPathElements));
        }

        default public CanonicalMap removeFrom(Object aPath) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(aPath));
        }

        default public CanonicalMap removeFrom(String aPath) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(aPath));
        }

        default public CanonicalMap removeFrom(String ... aPathElements) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(aPathElements));
        }

        default public CanonicalMap removePaths(Collection<?> aPaths) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removePaths(aPaths));
        }

        default public CanonicalMap removePaths(String ... aPaths) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removePaths(aPaths));
        }

        @Override
        default public Map<String, String> toDump(Map<String, String> aDump) {
            aDump.putAll(this);
            return aDump;
        }
    }

    public static interface CanonicalMapBuilder
    extends MutableCanonicalMap,
    InterOperableMap.InterOperableMapBuilder<String> {
        @Override
        default public CanonicalMapBuilder withPut(Collection<?> aPathElements, String aValue) {
            this.put(aPathElements, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPut(Object[] aPathElements, String aValue) {
            this.put(aPathElements, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPut(Relation<String, String> aProperty) {
            this.put((Relation)aProperty);
            return this;
        }

        default public CanonicalMapBuilder withPut(Property aProperty) {
            this.put(aProperty);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPut(String[] aKey, String aValue) {
            this.put(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(Collection<?> aPathElements, Boolean aValue) {
            this.putBoolean(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(Object aKey, Boolean aValue) {
            this.putBoolean(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(Object[] aPathElements, Boolean aValue) {
            this.putBoolean(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(String aKey, Boolean aValue) {
            this.putBoolean(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(String[] aPathElements, Boolean aValue) {
            this.putBoolean(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(Collection<?> aPathElements, Byte aValue) {
            this.putByte(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(Object aKey, Byte aValue) {
            this.putByte(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(Object[] aPathElements, Byte aValue) {
            this.putByte(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(String aKey, Byte aValue) {
            this.putByte(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(String[] aPathElements, Byte aValue) {
            this.putByte(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(Collection<?> aPathElements, Character aValue) {
            this.putChar(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(Object aKey, Character aValue) {
            this.putChar(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(Object[] aPathElements, Character aValue) {
            this.putChar(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(String aKey, Character aValue) {
            this.putChar(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(String[] aPathElements, Character aValue) {
            this.putChar(aPathElements, aValue);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(Collection<?> aPathElements, Class<C> aValue) {
            this.putClass(aPathElements, aValue);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(Object aKey, Class<C> aValue) {
            this.putClass(aKey, aValue);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(Object[] aPathElements, Class<C> aValue) {
            this.putClass(aPathElements, aValue);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(String aKey, Class<C> aValue) {
            this.putClass(aKey, aValue);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(String[] aPathElements, Class<C> aValue) {
            this.putClass(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(Collection<?> aPathElements, Double aValue) {
            this.putDouble(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(Object aKey, Double aValue) {
            this.putDouble(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(Object[] aPathElements, Double aValue) {
            this.putDouble(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(String aKey, Double aValue) {
            this.putDouble(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(String[] aPathElements, Double aValue) {
            this.putDouble(aPathElements, aValue);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(Collection<?> aPathElements, E aValue) {
            this.putEnum(aPathElements, aValue);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(Object aKey, E aValue) {
            this.putEnum(aKey, aValue);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(Object[] aPathElements, E aValue) {
            this.putEnum(aPathElements, aValue);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(String aKey, E aValue) {
            this.putEnum(aKey, aValue);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(String[] aPathElements, E aValue) {
            this.putEnum(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(Collection<?> aPathElements, Float aValue) {
            this.putFloat(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(Object aKey, Float aValue) {
            this.putFloat(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(Object[] aPathElements, Float aValue) {
            this.putFloat(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(String aKey, Float aValue) {
            this.putFloat(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(String[] aPathElements, Float aValue) {
            this.putFloat(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(Collection<?> aPathElements, Integer aValue) {
            this.putInt(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(Object aKey, Integer aValue) {
            this.putInt(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(Object[] aPathElements, Integer aValue) {
            this.putInt(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(String aKey, Integer aValue) {
            this.putInt(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(String[] aPathElements, Integer aValue) {
            this.putInt(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(Collection<?> aPathElements, Long aValue) {
            this.putLong(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(Object aKey, Long aValue) {
            this.putLong(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(Object[] aPathElements, Long aValue) {
            this.putLong(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(String aKey, Long aValue) {
            this.putLong(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(String[] aPathElements, Long aValue) {
            this.putLong(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(Collection<?> aPathElements, Short aValue) {
            this.putShort(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(Object aKey, Short aValue) {
            this.putShort(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(Object[] aPathElements, Short aValue) {
            this.putShort(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(String aKey, Short aValue) {
            this.putShort(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(String[] aPathElements, Short aValue) {
            this.putShort(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutString(Collection<?> aPathElements, String aValue) {
            this.putString(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutString(Object aKey, String aValue) {
            this.putString(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutString(Object[] aPathElements, String aValue) {
            this.putString(aPathElements, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutString(String aKey, String aValue) {
            this.putString(aKey, aValue);
            return this;
        }

        default public CanonicalMapBuilder withPutString(String[] aPathElements, String aValue) {
            this.putString(aPathElements, aValue);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsert(Object aObj) {
            this.insert(aObj);
            return this;
        }

        default public CanonicalMapBuilder withInsert(PathMap<String> aFrom) {
            this.insert(aFrom);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(Collection<?> aToPathElements, PathMap<String> aFrom, Collection<?> aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertBetween(Object aToPath, Object aFrom, Object aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(Object aToPath, PathMap<String> aFrom, Object aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(Object[] aToPathElements, PathMap<String> aFrom, Object[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertBetween(String aToPath, Object aFrom, String aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(String aToPath, PathMap<String> aFrom, String aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(String[] aToPathElements, PathMap<String> aFrom, String[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(Object aFrom, Collection<?> aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertFrom(Object aFrom, Object aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertFrom(Object aFrom, Object ... aFromPathElements) {
            this.withInsertFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertFrom(Object aFrom, String aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertFrom(Object aFrom, String ... aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> aFrom, Collection<?> aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> aFrom, Object aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> aFrom, Object ... aFromPathElements) {
            this.withInsertFrom((PathMap)aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> aFrom, String aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> aFrom, String ... aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(Collection<?> aToPathElements, Object aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(Collection<?> aToPathElements, PathMap<String> aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertTo(Object aToPath, Object aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(Object aToPath, PathMap<String> aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertTo(Object[] aToPathElements, Object aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(Object[] aToPathElements, PathMap<String> aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertTo(String aToPath, Object aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(String aToPath, PathMap<String> aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertTo(String[] aToPathElements, Object aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(String[] aToPathElements, PathMap<String> aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMerge(Object aObj) {
            this.merge(aObj);
            return this;
        }

        default public CanonicalMapBuilder withMerge(PathMap<String> aFrom) {
            this.merge(aFrom);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(Collection<?> aToPathElements, PathMap<String> aFrom, Collection<?> aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeBetween(Object aToPath, Object aFrom, Object aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(Object aToPath, PathMap<String> aFrom, Object aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(Object[] aToPathElements, PathMap<String> aFrom, Object[] aFromPathElements) {
            this.mergeBetween(aToPathElements, (Object)aFromPathElements, aFromPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeBetween(String aToPath, Object aFrom, String aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(String aToPath, PathMap<String> aFrom, String aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(String[] aToPathElements, PathMap<String> aFrom, String[] aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(Object aFrom, Collection<?> aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeFrom(Object aFrom, Object aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeFrom(Object aFrom, Object ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeFrom(Object aFrom, String aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeFrom(Object aFrom, String ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> aFrom, Collection<?> aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> aFrom, Object aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> aFrom, Object ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> aFrom, String aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> aFrom, String ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(Collection<?> aToPathElements, Object aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(Collection<?> aToPathElements, PathMap<String> aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeTo(Object aToPath, Object aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(Object aToPath, PathMap<String> aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeTo(Object[] aToPathElements, Object aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(Object[] aToPathElements, PathMap<String> aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeTo(String aToPath, Object aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(String aToPath, PathMap<String> aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeTo(String[] aToPathElements, Object aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(String[] aToPathElements, PathMap<String> aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
            this.putDirAt((Collection)aPathElements, aIndex, aDir);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(Collection<?> aPathElements, int aIndex, PathMap<String> aDir) {
            this.putDirAt((Collection)aPathElements, aIndex, (PathMap)aDir);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(int aIndex, Object aDir) {
            this.putDirAt(aIndex, aDir);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(int aIndex, PathMap<String> aDir) {
            this.putDirAt(aIndex, (PathMap)aDir);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(Object aPath, int aIndex, Object aDir) {
            this.putDirAt(aPath, aIndex, aDir);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(Object aPath, int aIndex, PathMap<String> aDir) {
            this.putDirAt(aPath, aIndex, (PathMap)aDir);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(Object[] aPathElements, int aIndex, Object aDir) {
            this.putDirAt(aPathElements, aIndex, aDir);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(Object[] aPathElements, int aIndex, PathMap<String> aDir) {
            this.putDirAt(aPathElements, aIndex, (PathMap)aDir);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(String aPath, int aIndex, Object aDir) {
            this.putDirAt(aPath, aIndex, aDir);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(String aPath, int aIndex, PathMap<String> aDir) {
            this.putDirAt(aPath, aIndex, (PathMap)aDir);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(String[] aPathElements, int aIndex, Object aDir) {
            this.putDirAt(aPathElements, aIndex, aDir);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(String[] aPathElements, int aIndex, PathMap<String> aDir) {
            this.putDirAt(aPathElements, aIndex, (PathMap)aDir);
            return this;
        }

        default public CanonicalMapBuilder withRemoveFrom(Collection<?> aPathElements) {
            this.removeFrom((Collection)aPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withRemoveFrom(Object aPath) {
            this.removeFrom(aPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withRemoveFrom(Object ... aPathElements) {
            this.removeFrom(aPathElements);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withRemoveFrom(String aPath) {
            this.removeFrom(aPath);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withRemoveFrom(String ... aPathElements) {
            this.removeFrom(aPathElements);
            return this;
        }

        default public CanonicalMapBuilder withRemovePaths(String ... aPathElements) {
            this.removeFrom(aPathElements);
            return this;
        }
    }
}

