/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.alt.chaos;

import org.refcodes.security.DecryptionException;
import org.refcodes.security.Encrypter;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.alt.chaos.ChaosDecrypter;
import org.refcodes.security.alt.chaos.ChaosEncryptionOutputStream;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosMode;
import org.refcodes.security.alt.chaos.ChaosOptions;

public class ChaosEncrypter
implements Encrypter<byte[], byte[], EncryptionException> {
    private double _x;
    private double _a;
    private long _s;
    private byte _previousEncrypted = 0;
    private ChaosOptions _chaosMetrics;
    private ChaosEncrypter _childEncrypter = null;
    private ChaosDecrypter _verifyDecrypter = null;

    public ChaosEncrypter(ChaosKey aKey) {
        this(aKey, -1, false);
    }

    public ChaosEncrypter(ChaosKey aKey, int aChildDepth) {
        this(aKey, aChildDepth, false);
    }

    public ChaosEncrypter(ChaosKey aKey, boolean isVerify) {
        this(aKey, -1, isVerify);
    }

    public ChaosEncrypter(ChaosKey aKey, int aChildDepth, boolean isVerify) {
        this.init(aKey, aChildDepth);
        if (isVerify) {
            this._verifyDecrypter = new ChaosDecrypter(aKey, aChildDepth);
        }
    }

    protected ChaosEncrypter(ChaosKey aKey, int aChildDepth, ChaosEncrypter aChildEncrypter, boolean isVerify) {
        if (aChildEncrypter != null && aKey.getChild() != null) {
            throw new IllegalArgumentException("You provided a chaos key with child and a child encrypiter, either the key can have a child or a child encrypter is provided, but not both at the same time!");
        }
        this.init(aKey, aChildDepth);
        if (aChildEncrypter != null) {
            this._childEncrypter = aChildEncrypter;
        }
        if (isVerify) {
            this._verifyDecrypter = new ChaosDecrypter(aKey, aChildDepth, aChildEncrypter._verifyDecrypter);
            aChildEncrypter._verifyDecrypter = null;
        }
    }

    private void init(ChaosKey aKey, int aChildDepth) {
        this._x = aKey.getX0();
        this._a = aKey.getA();
        this._s = aKey.getS();
        ChaosOptions chaosOptions = this._chaosMetrics = aKey.getOptions() != null ? aKey.getOptions() : ChaosMode.NONE;
        if (aChildDepth != 0 && aKey.getChild() != null) {
            if (!aKey.getChild().getOptions().isFixedLength()) {
                throw new IllegalArgumentException("The provided chaos key chain is not(!) of a fixed length (<" + aKey.getChild().getOptions() + ">) when applied and requires something like a <" + ChaosEncryptionOutputStream.class.getSimpleName() + "> supporting the variable length features when applied!");
            }
            this._childEncrypter = new ChaosEncrypter(aKey.getChild(), aChildDepth != -1 ? aChildDepth - 1 : -1);
        }
        if (aKey.getChild() != null) {
            // empty if block
        }
    }

    @Override
    public byte[] toEncrypted(byte[] aDecrypted) throws EncryptionException {
        byte[] theEncrypted = new byte[aDecrypted.length];
        this.toEncrypted(aDecrypted, 0, aDecrypted.length, theEncrypted, 0);
        return theEncrypted;
    }

    @Override
    public int toEncrypted(byte[] aBuffer, int aOffset, int aLength, byte[] aOutBuffer, int aOutOffset) throws EncryptionException {
        if (aOutBuffer.length - aOutOffset < aLength) {
            throw new ArrayIndexOutOfBoundsException("Out buffer at index <" + aOutBuffer.length + "> too short to hold encrypted data!");
        }
        if (aBuffer.length < aLength + aOffset) {
            throw new IllegalArgumentException("The input length <" + aBuffer.length + "> is smaller than the offset <" + aOffset + "> and the processable length <" + aLength + ">!");
        }
        byte[] theBuffer = aOutBuffer;
        int theOffset = aOutOffset;
        if (this._childEncrypter != null) {
            theBuffer = new byte[aLength];
            theOffset = 0;
        }
        for (int i = 0; i < aLength; ++i) {
            byte n = aBuffer[aOffset + i];
            if (this._chaosMetrics.isMutateS()) {
                this._s = ChaosKey.addToS(this._s, this._previousEncrypted);
            }
            if (this._chaosMetrics.isXorNext()) {
                n = (byte)(0xFF & (n ^ this._previousEncrypted));
            }
            this._x = this._x * this._a * (1.0 - this._x);
            double k = (double)this._s * this._x;
            theBuffer[i + theOffset] = (byte)(((double)n + k) % 256.0);
            this._previousEncrypted = theBuffer[i + theOffset];
        }
        if (this._childEncrypter != null) {
            this._childEncrypter.toEncrypted(theBuffer, theOffset, aLength, aOutBuffer, aOutOffset);
        }
        if (this._verifyDecrypter != null) {
            this.verifyEncrypted(aBuffer, aOffset, aLength, aOutBuffer, aOutOffset);
        }
        return aLength;
    }

    @Override
    public int encrypt(byte[] aBuffer, int aOffset, int aLength) throws EncryptionException {
        if (this._verifyDecrypter == null) {
            return this.toEncrypted(aBuffer, aOffset, aLength, aBuffer, aOffset);
        }
        byte[] theBuffer = new byte[aLength];
        int length = this.toEncrypted(theBuffer, 0, aLength, aBuffer, aOffset);
        System.arraycopy(theBuffer, 0, aBuffer, aOffset, aLength);
        return length;
    }

    @Override
    public int encrypt(byte[] aBuffer) throws EncryptionException {
        int theLength = aBuffer.length;
        if (this._verifyDecrypter == null) {
            return this.toEncrypted(aBuffer, 0, theLength, aBuffer, 0);
        }
        byte[] theBuffer = new byte[theLength];
        int length = this.toEncrypted(theBuffer, 0, theLength, aBuffer, 0);
        System.arraycopy(theBuffer, 0, aBuffer, 0, theLength);
        return length;
    }

    @Override
    public void dispose() {
        this._a = -1.0;
        this._s = -1L;
        this._x = -1.0;
        this._previousEncrypted = (byte)-1;
        this._chaosMetrics = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [x=" + this._x + ", a=" + this._a + ", s=" + this._s + ", prev=" + this._previousEncrypted + ", chaosMetrics=" + this._chaosMetrics + "]";
    }

    private void verifyEncrypted(byte[] aBuffer, int aOffset, int aLength, byte[] aOutBuffer, int aOutOffset) throws EncryptionException {
        byte[] theVerifyBuffer = new byte[aLength];
        try {
            this._verifyDecrypter.toDecrypted(aOutBuffer, aOutOffset, aLength, theVerifyBuffer, 0);
            for (int i = 0; i < aLength; ++i) {
                if (theVerifyBuffer[i] == aBuffer[i + aOffset]) continue;
                throw new EncryptionException("Verifying encrypted data for (x = " + this._x + ", a = " + this._a + ", s = " + this._s + ", config = " + this._chaosMetrics + ") failed!");
            }
        }
        catch (DecryptionException e) {
            throw new EncryptionException("Verifying encrypted data for (x = " + this._x + ", a = " + this._a + ", s = " + this._s + ", config = " + this._chaosMetrics + ") failed!");
        }
    }
}

